
#include "sensors.h"


float average_samples(unsigned int cant_samples, AnalogIn input)
{
    unsigned int i;
    float sample;
    
    sample = 0;
    
    for(i=0;i<cant_samples;i++)
    {
        sample+= input.read();
    }
    sample = sample / (float)cant_samples;
    
    return (sample*VSAMPLE);
}

double volt_to_hum(float volt)
{
    double hum;
    
    hum = -12.5+125.0*((volt)/(double)VREF);
    return hum;
}

double volt_to_temp(float volt)
{
    double temp;
    temp = -66.875+218.75*((volt)/(double)VREF);
    return temp;
}

    
unsigned int reset_co2_buffer(char *co2_buffer)
{
    unsigned int i;
    for(i=0;i<CO2_MAX_BUFFER;i++)
    {
        co2_buffer[i] = 0;
    }
    return 0;
}

void print_menu_sensor(Serial *pc)
{
   pc->printf("\r\nMenu sensor CO2\r\n");
   pc->printf("c: Calibrar\r\n");
   pc->printf("d: Salida default\r\n");
   pc->printf("r: Leer valor\r\n");
   pc->printf("s: Salir\r\n");
   printf(": ");
}

char config_sensor(Serial *pc, Serial *co2sens, char *co2_buffer)
{
   time_t timeout;
   char c;
   bool pres;
   
   timeout = time(NULL); 
   print_menu_sensor(pc);
       
   while(1)
   {
       if(pc->readable())
       {
           c = pc->getc();
           switch(c)
           {
               case 'c':
                    pc->printf("\r\nCalibrando...\r\n");
                    co2sens->printf("G\r\n");
                    pres = true;
               break;
               
               case 'd':
                    pc->printf("\r\nSal default...\r\n");
                    co2sens->printf("M 6\r\n");               
                    pres = true;
               break;
                
               case 's':
               return 0;
               
               case 'r':
                    wait(0.1);
                    co2sens->gets(co2_buffer,CO2_MAX_BUFFER);
                    pc->printf("Resp: %s ",co2_buffer); 
               break;
                
               default:
                pc->printf("\r\nOpcion invalida\r\n");
           }
           
           if(pres)
           { 
            wait(0.1);
            co2sens->gets(co2_buffer,CO2_MAX_BUFFER);
            pc->printf("Resp: %s ",co2_buffer);
            pres = false;
           }

           timeout = time(NULL); 
           print_menu_sensor(pc);      
       }    
       else
       {
            if((time(NULL)-timeout)>=TIMEOUT_MENU_CO2)
            {
                pc->printf("\r\nTIMEOUT Menu\r\n");
                return 0;
            }
        }
     }
}

#define CO2_START "Z "
#define CO2_SEP ' '
#define CO2_MAX_DIGIT 6

unsigned int convert_co2(char *buffer)
{
    unsigned int i;
    char *punt;
    char aux[CO2_MAX_DIGIT];
    
    memset(aux,0,CO2_MAX_DIGIT);
    
    punt=strstr(buffer,(char *)CO2_START);
    if(punt == NULL)
    {
        return 0;
    }
    punt = punt + strlen(CO2_START);
    
    //Ejemplo : "Z 00004 z 00004"
    for(i=0; (i<strlen(punt))&&(i<CO2_MAX_DIGIT)&&(punt[i] != CO2_SEP); i++)
    {
        aux[i] = punt [i];
    }
    //pc.printf("\r\nAUX = %s\r\n",aux);
    return (atoi(aux));
}

#ifdef USE_NFC

#if defined(NFC_ORIG_LAYOUT) || defined(HIBER_DEMO)

void init_NFC_data(NFC_Memory_Layout *data)
{
    data->sn = 0;
    data->medicion_refint = 0;       //V
    data->medicion_analog_in_0 = 0;  //V
    data->medicion_temperatura = 0;  //ºC
    data->medicion_humedad = 0;      //%
    data->medicion_bateria = 0;      //V
    data->medicion_co2 = 0;          //%

    memset(data->DEVID,0,NFC_MAX_ID);
    memset(data->PAC,0,NFC_MAX_ID);
}

#else

void init_NFC_data(NFC_Memory_Layout *data)
{

    memset(data->temp_str,0,4);
    memset(data->hum_str,0,4);
    memset(data->co2_str,0,4);
    data->medicion_temperatura = 0;  //ºC
    data->medicion_humedad = 0;      //%
    data->medicion_bateria = 0;      //V
    data->medicion_co2 = 0;          //%

    memset(data->DEVID,0,NFC_MAX_ID);
    memset(data->PAC,0,NFC_MAX_ID);
}

#endif


static const int32_t fix16_one = 0x00010000; /*!< fix16_t value of 1 */
int32_t fix16_from_float( float a )
{
    float temp = a * fix16_one;
    temp += ( temp >= 0 ) ? 0.5f : -0.5f;
    return ( int32_t )temp;
}
#endif
