#ifndef __SENSORS_H__
#define __SENSORS_H__

#include "mbed.h"

//Sin dormir 
//#define NO_SLEEP 

/// Definimos el tipo de placa ///
#define PLACA_XDOT
//#define PLACA_MDOT

//Demo HIBER
//#define HIBER_DEMO

#ifdef PLACA_XDOT
#define VSAMPLE 3.3f
#endif

#ifdef PLACA_MDOT
#define VSAMPLE 3.0f
#endif

#define MEDIR_BAT

//Definir solo para probar sensado, sin conexion a la red
//#define ONLY_SENSORS

//Definir para placa de desarrollo 
//#define DESARROLLO

//Definir para sensor I2C en vez de conversor A/D
//Si es I2C
#define USE_SENSOR_I2C

#ifdef DESARROLLO
#define I2C_SENSOR_ADDRESS 0x45
#else
#define I2C_SENSOR_ADDRESS 0x44
#endif 

//Uso de NFC
#define USE_NFC

//tipo de lanza
#ifdef PLACA_BARCO
#define SENSOR_MODE 0x02
#else
#define SENSOR_MODE 0x01
#endif

#define MAX_DEVICE_ID 11

#ifdef USE_NFC
#define NFC_START_ADDRESS               0x00000
#define NFC_MAX_ID 20

#if defined(NFC_ORIG_LAYOUT) || defined(HIBER_DEMO)
//#ifdef NFC_ORIG_LAYOUT

typedef struct
{
    uint32_t sn;
    int32_t  medicion_refint;       //V
    int32_t  medicion_analog_in_0;  //V
    int32_t  medicion_temperatura;  //ºC
    int32_t  medicion_humedad;      //%
    int32_t  medicion_bateria;      //V
    int32_t  medicion_co2;          //%

    char DEVID[20];
    char PAC[20];
} NFC_Memory_Layout;

#else

typedef struct
{
    char temp_str[4];
    char hum_str[4];
    char co2_str[4];
    int32_t  medicion_temperatura;  //ºC
    int32_t  medicion_humedad;      //%
    int32_t  medicion_bateria;      //V
    int32_t  medicion_co2;          //%
    char DEVID[20];
    char PAC[20];
} NFC_Memory_Layout;

#endif //de NFC Layout


#endif //de USE_NFC 

//Definir para enviar mensajes repetitivos con nro seq para pruebas de alcance
//#define MODO_TEST_TX
#define SEQ_ADDRESS 0x1000
//#define I2C_RETRY_ADDRESS 0x1100
////////////////////////////

//Direccion de la NVRAM donde guardamos el timestamp antes de dormir
#define TIME_SLEEP_ADDRESS 0x10F0

#define NUMBER_SAMPLES 10
#define VREF 3.3

//Tiempo de espera en segundos para leer los sensores al despertarse
#ifndef MODO_TEST_TX
#define WARMING_UP_SENSORS 10
//#define WARMING_UP_SENSORS 5
#else
#define WARMING_UP_SENSORS 5
#endif



#define CO2_BAUDRATE 9600
#define CO2_MAX_BUFFER 20
#define TIMEOUT_MENU_CO2 10

//Declaracion de funciones
float average_samples(unsigned int cant_samples, AnalogIn input);
double volt_to_hum(float volt);
double volt_to_temp(float volt);
unsigned int reset_co2_buffer(char *co2_buffer);
void print_menu_sensor(Serial *pc);
char config_sensor(Serial *pc, Serial *co2sens, char *co2_buffer);
unsigned int convert_co2(char *buffer);
int32_t fix16_from_float( float a );

#ifdef USE_NFC
void init_NFC_data(NFC_Memory_Layout *data);
#endif

#endif // de __SENSORS_H__
