#include "mbed.h"
Serial pc(USBTX, USBRX);
Serial com(D1,D0);
DigitalOut NRST(A5);
char msg[256];
char data[256];

char rcmd = 0;
int cmdflag = 0;

void commandget()
{
    wait(0.5);
    rcmd=com.getc();
    cmdflag = 1;
}

void initialize()
{
    rcmd = NULL;
    cmdflag = 0;
}

int main()
{
    com.baud(115200);
    pc.baud(115200);
    //初期化
    NRST = 1;
    NRST = 0;
    wait(2);
    NRST = 1;
    com.scanf("%s",msg);
    pc.printf("%s\r\n",msg);
    if (strstr(msg,"Select")!=NULL) {
        com.printf("2\r\n");
        wait(0.5);
        com.printf("q 2\r\n");
        wait(0.5);
        com.printf("start\r\n");
        com.scanf("%s",msg);
        for(int i = 0; i<4; i++) {
            com.getc();
        }
    }
    pc.printf("Setting OK\r\n");
    com.attach(commandget,Serial::RxIrq);
    while(1) {
        pc.printf("HEPTA\r\n");
        wait(1.0);
        if (cmdflag == 1) {
            if (rcmd == 'a') {
                com.printf("UPLINK\r\n");   
            }
            initialize();
        }
    }
}