#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "fs");
HeptaXbee xbee(p9,p10);
HeptaCamera_GPS cam_gps(p13, p14,p25,p24);
Hepta9axis _9axis(p28,p27,0xD0,0x18);//sda,scl,acc&gyro_address,mag_gyro
HeptaTemp heptatemp(p17);
HeptaBattery bat(p16,p26);

DigitalOut myled1(LED1);
DigitalOut myled2(LED1);
DigitalOut myled3(LED1);
DigitalOut myled4(LED1);

int main()
{
    //Lighting up
    myled1 = 1;
    wait(0.5);
    myled2 = 1;
    wait(0.5);
    myled3 = 1;
    wait(0.5);
    myled4 = 1;
    wait(0.5);
    //Lighting off
    myled1 = 0;
    wait(0.5);
    myled2 = 0;
    wait(0.5);
    myled3 = 0;
    wait(0.5);
    myled4 = 0;
}