#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "fs");
HeptaXbee xbee(p9,p10);
HeptaCamera_GPS cam_gps(p13, p14,p25,p24);
Hepta9axis _9axis(p28,p27,0xD0,0x18);//sda,scl,acc&gyro_address,mag_gyro
HeptaTemp heptatemp(p17);
HeptaBattery bat(p16,p26);

int main()
{
    char mode;
    pc.baud(9600);
    pc.printf("Hello world.\r\n");
    while(1) {
        pc.printf("\r\n");
        pc.printf("*********************************\r\n");
        pc.printf("Please select mode.\r\n");
        pc.printf("a:SD test Mode\r\n");
        pc.printf("b:Check Battery Level\r\n");
        pc.printf("c:Gyro Sening Mode\r\n");
        pc.printf("d:Accel Sensing Mode\r\n");
        pc.printf("e:Magnet Sensig Mode\r\n");
        pc.printf("f:GPS Test Sensing Mode\r\n");
        pc.printf("g:GPS data_GPGGA Mode\r\n");
        pc.printf("h:Camera Synchro Mode\r\n");
        pc.printf("i:CAM SnapShot Mode\r\n");
        pc.printf("j:Saving Camera Data Mode\r\n");
        pc.printf("k:Camera Data Transmitting Mode\r\n");
        pc.printf("l:Temperature Sensing Mode\r\n");
        pc.printf("m:Xbee Mode\r\n");
        pc.printf("n:All Transmitting Mode\r\n");;
        pc.printf("*********************************");
        pc.printf("\r\n");

        mode = pc.getc();
        pc.printf("Your select Mode = %c\r\n",mode);

        switch(mode) {
            case'a': {
                pc.printf("SD test Mode\r\n");
                FILE *fp = fopen("/fs/myfile.txt", "w");
                if(fp == NULL) {
                    pc.printf("Could not open file for write\r\n");
                } else {
                    fprintf(fp, "\n\rHello World!\n\r");
                    pc.printf("SD Check Complete!!\r\n");
                    fclose(fp);
                }
                break;
            }//case'a'

            case'b': {
                pc.printf("Check Battery Level\r\n");
                float bt;
                for(int i = 0; i<30; i++) {
                    bat.vol(&bt);
                    pc.printf("V = %f\r\n",bt);
                    wait(0.5);
                }
                break;
            }//case'b'

            case'c': {
                pc.printf("Gyro sensing Mode\r\n");
                float gx,gy,gz;
                for(int i = 0; i < 30; i++) {
                    _9axis.sen_gyro(&gx,&gy,&gz);
                    pc.printf("GX = %f,GY = %f,GZ = %f\r\n",gx,gy,gz);
                    wait(0.5);
                }
                break;
            }//case'c'

            case'd': {
                pc.printf("Accel sensing Mode\r\n");
                float ax,ay,az;
                for(int i = 0; i < 30; i++) {
                    _9axis.sen_acc(&ax,&ay,&az);
                    pc.printf("AX = %f,AY = %f,AZ = %f\r\n",ax,ay,az);
                    wait(0.5);
                }
                break;
            }//case'd'

            case'e': {
                float mx,my,mz;
                pc.printf("Magnet sensing Mode\r\n");
                for(int i = 0; i < 30; i++) {
                    _9axis.sen_mag(&mx,&my,&mz);
                    pc.printf("MX = %f,MY = %f,MZ = %f\r\n",mx,my,mz);
                    wait(0.5);
                }
                break;
            }//case'e'

            case'f': {
                pc.printf("GPS sensing Mode\r\n");
                cam_gps.gps_setting();
                cam_gps.flushSerialBuffer();
                while(1) pc.putc(cam_gps.getc());
                break;
            }//case'f'


            case'g': {
                cam_gps.gps_setting();
                cam_gps.flushSerialBuffer();
                pc.printf("GPS GPGGA Mode\r\n");
                int quality=0,stnum=0,gps_check=0;
                char ns='A',ew='B',aunit='m';
                float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
                for(int i=1; i<10; i++) {
                    cam_gps.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                    if((gps_check==0)|(gps_check==1)) {
                        pc.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                    }
                }
                break;
            }//case'g'


            case'h': {
                wait(0.5);
                pc.printf("Camera Synchro\r\n");
                cam_gps.Sync();
                break;
            }//case'h'

            case'i': {
                pc.printf("CAM snapshot Mode\r\n");
                cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                cam_gps.test_jpeg_snapshot_picture(1);

                break;
            }//case'i'

            case'j': {
                pc.printf("Saving Camera Data Mode\r\n");
                cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                cam_gps.test_jpeg_snapshot_data(1);

                break;
            }//case'j'

            case'k': {
                pc.printf("Camera Data Transmitting  Mode\r\n");
                cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                cam_gps.test_jpeg_snapshot_picture(1);

                FILE *fp = fopen("/fs/test.txt", "r");
                if(fp == NULL) {
                    pc.printf("Could not open file for write\r\n");
                } else {
                    char str[1024];
                    while((fgets(str,256,fp))!=NULL) {
                        //pc.printf("%s",str);
                        pc.printf("%s",str);
                        wait(0.001);
                    }
                    fclose(fp);
                }

                break;
            }//case'k'

            case'l': {
                pc.printf("Temp sensing Mode\r\n");
                float temp;
                for(int i = 0; i<100; i++) {
                    heptatemp.temp_sense(&temp);
                    pc.printf("temper = %f\r\n",temp);
                    //xbee.printf("%f\r\n",temp);
                }
                break;
            }//case'l'

            case'm': {

                int i=0,rcmd=0,cmdflag=0;
                xbee.printf("Count Up!\r");
                while(1) {
                    xbee.printf("num = %d\r",i);
                    i++;
                    wait(1.0);
                    xbee.xbee_recieve(&rcmd,&cmdflag);
                    pc.printf("rcmd=%d, cmdflag=%d\r\n",rcmd, cmdflag);
                    if (cmdflag == 1) {
                        if (rcmd == 'a') {
                            xbee.printf("Command Get %d\r\n",rcmd);
                            xbee.printf("HEPTA Uplink OK\r");
                        }
                        xbee.initialize();
                    }
                }

                break;
            }//case'm'

            case'n': {
                cam_gps.gps_setting();
                cam_gps.flushSerialBuffer();
                pc.printf("All Transmitting Mode\r\n");
                //char iii = pc.getc();
                char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],mx[4],my[4],mz[4],lad[8],log[8],height[4],bt[4],temp[4];
                char ddata[64];
                int dsize[7];
                int Count = 0;
                char fname[64];
                while(1) {
                    snprintf(fname, sizeof(fname), "/fs/telemetry.txt");
                    FILE*fpx = fopen(fname, "a");
                    _9axis.sen_gyro_u16(gx,gy,gz,&dsize[0]);
                    _9axis.sen_acc_u16(ax,ay,az,&dsize[1]);
                    _9axis.sen_mag_u16(mx,my,mz,&dsize[2]);
                    bat.vol_u16(bt,&dsize[5]);
                    heptatemp.temp_sense_u16(temp,&dsize[6]);
                    cam_gps.lat_log_sensing_u16(lad,log,height,&dsize[3],&dsize[4]);
                    //xbee.printf("DN:%d",Count);
                    xbee.xbee_transmit(ddata,64,gx,gy,gz,ax,ay,az,mx,my,mz,lad,log,height,bt,temp,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[2],dsize[3],dsize[3],dsize[4],dsize[5],dsize[6],14);
                    fprintf(fpx,"DN%d:",Count);
                    for(int ii = 0; ii<64; ii++) {
                        fprintf(fpx,"%c",ddata[ii]);
                    }
                    fprintf(fpx,"\r\n");
                    fclose(fpx);
                    Count++;
                }
                break;
            }//case'9'

            default:
                break;


        }
    }
}