#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "fs");
HeptaXbee xbee(p9,p10);
HeptaCamera_GPS cam_gps(p13, p14,p25,p24);
Hepta9axis _9axis(p28,p27,0xD0,0x18);//sda,scl,acc&gyro_address,mag_gyro
HeptaTemp heptatemp(p17);
HeptaBattery bat(p16,p26);

int main()
{
    int i=0,rcmd=0,cmdflag=0;
    //char xdata[500];
    //xbee.printf("Count Up!\r");
    while(1) {
        //xbee.printf("num = %d\r",i);
        i++;
        wait(1.0);
        xbee.xbee_recieve(&rcmd,&cmdflag);
        pc.printf("rcmd=%d, cmdflag=%d\r\n",rcmd, cmdflag);
        if (cmdflag == 1) {
            pc.printf("Command Get %d\r\n",rcmd);
            pc.printf("HEPTA Uplink OK\r");

            switch(rcmd) {
                case'a': {
                    char bt[4];
                    int dsize[1];
                    for(int j = 0;j <= 50; j++){
                        bat.vol_u16(bt,&dsize[1]);
                        xbee.putc('A');
                        for(int k = 0; k<=3; k++) {
                            xbee.putc(bt[k]);
                        }
                        xbee.printf("\n");
                        wait(0.5);
                    }
                    break;
                    //*/
                }

                case'b': {
                   
                    break;
                }//case'c'

                case'c': {
                   
                    break;
                }//case'd'

                case'd': {
                 
                }//case'e'

                case'e': {
                    cam_gps.gps_setting();
                    cam_gps.flushSerialBuffer();
                    
                    break;
                }//case'g'


                case'f': {
                    
                    break;
                }//case'l'

                case'g': {
                   // pc.printf("CAM snapshot Mode\r\n");
                    cam_gps.Sync();
                    cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                    cam_gps.test_jpeg_snapshot_picture(1);
                    break;
                }//case'h'

                case'h': {
                    cam_gps.gps_setting();
                    cam_gps.flushSerialBuffer();
                    //pc.printf("All Transmitting Mode\r\n");
                    //char iii = pc.getc();
                    char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],mx[4],my[4],mz[4],lad[8],log[8],height[4],bt[4],temp[4];
                    char ddata[64];
                    int dsize[7];
                    int Count = 0;
                    char fname[64];
                    while(1) {
                        snprintf(fname, sizeof(fname), "/fs/telemetry.txt");
                        FILE*fpx = fopen(fname, "a");
                        _9axis.sen_gyro_u16(gx,gy,gz,&dsize[0]);
                        _9axis.sen_acc_u16(ax,ay,az,&dsize[1]);
                        _9axis.sen_mag_u16(mx,my,mz,&dsize[2]);
                        bat.vol_u16(bt,&dsize[5]);
                        heptatemp.temp_sense_u16(temp,&dsize[6]);
                        cam_gps.lat_log_sensing_u16(lad,log,height,&dsize[3],&dsize[4]);
                        //xbee.printf("DN:%d",Count);
                        xbee.putc('H');
                        xbee.xbee_transmit(ddata,64,gx,gy,gz,ax,ay,az,mx,my,mz,lad,log,height,bt,temp,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[2],dsize[3],dsize[3],dsize[4],dsize[5],dsize[6],14);
                        fprintf(fpx,"DN%d:",Count);
                        for(int ii = 0; ii<64; ii++) {
                            fprintf(fpx,"%c",ddata[ii]);
                        }
                        fprintf(fpx,"\r\n");
                        fclose(fpx);
                        Count++;
                    }
                    break;
                }//case'9'

                default:
                    break;


            }//switch
            xbee.initialize();
        }//if(cmdflag)
    }//while
}//main