#include "mbed.h"
#include "SDHCFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaSerial.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5, p6, p7, p8, "fs");
HeptaXbee xbee(p9,p10);
HeptaSerial camera(p13, p14,p25,p26);
HeptaMPU9250 MPU9250(p28,p27,0xD0,0x18);//sda,scl,acc&gyro_address,mag_gyro
HeptaTemp heptatemp(p17);
HeptaBattery bat(p16,p26);
/*
DigitalOut CAM_SW(p25);//CAM_control
DigitalOut GPS_SW(p24);//GPS_control
*/
int main()
{
     char mode;
    //pc.baud(9600);

    while(1) {

        pc.printf("\r\n");
        pc.printf("*********************************\r\n");
        pc.printf("Hello world.\r\n");
        pc.printf("My name is HEPTA2\r\n");
        pc.printf("Please select mode.\r\n");
        pc.printf("a:SD test Mode\r\n");
        pc.printf("b:Check Battery Level\r\n");
        pc.printf("c:Gyro Sening Mode\r\n");
        pc.printf("d:Accel Sensing Mode\r\n");
        pc.printf("e:Magnet Sensig Mode\r\n");
        pc.printf("f:GPS Test Sensing Mode\r\n");
        pc.printf("g:GPS data_GPGGA Mode\r\n");
        pc.printf("h:Camera Synchro Mode\r\n");
        pc.printf("i:CAM SnapShot Mode\r\n");
        pc.printf("j:Saving Camera Data Mode\r\n");
        pc.printf("k:Camera Data Transmitting Mode\r\n");
        pc.printf("l:Temperature Sensing Mode\r\n");
        pc.printf("m:Xbee Mode\r\n");
        pc.printf("n:Xbee & Temperature Mode\r\n");//恒温槽用
        pc.printf("o:All Transmitting Mode\r\n");
        pc.printf("*********************************\r\n");

        mode = pc.getc();
        pc.printf("\r\n");
        pc.printf("Your select Mode = %c\r\n",mode);
        wait(0.5);

        switch(mode) {
            case'a': {
                printf("=============\r\n");
                printf("SD test Mode\r\n");
                printf("=============\r\n");
                FILE *fp = fopen("/fs/myfile.txt", "w");
                if(fp == NULL) {
                    pc.printf("Could not open file for write\r\n");
                } else {
                    fprintf(fp, "\n\rHello World!\n\r");
                    printf("SD Check Complete!!\r\n");
                    fclose(fp);
                }


                break;
            }//case'a'

            case'b': {
                printf("===================\r\n");
                printf("Check Battery Level\r\n");
                printf("===================\r\n");
                float bt;
                for(int i = 0; i<50; i++) {
                    bat.vol(&bt);
                    pc.printf("V = %f\r\n",bt);
                }
                break;
            }//case'b'

            case'c': {
                printf("===================\r\n");
                printf("Gyro sensing Mode\r\n");
                printf("===================\r\n");
                float gx,gy,gz;
                for(int i = 0; i < 10; i++) {
                    MPU9250.sen_gyro(&gx,&gy,&gz);
                    pc.printf("GX = %f,GY = %f,GZ = %f\r\n",gx,gy,gz);
                    wait(0.5);
                }
                break;
            }//case'c'

            case'd': {
                printf("===================\r\n");
                printf("Accel sensing Mode\r\n");
                printf("===================\r\n");
                float ax,ay,az;
                for(int i = 0; i < 10; i++) {
                    MPU9250.sen_acc(&ax,&ay,&az);
                    pc.printf("AX = %f,AY = %f,AZ = %f\r\n",ax,ay,az);
                    wait(0.5);
                }
                break;
            }//case'd'

            case'e': {
                float mx,my,mz;
                printf("===================\r\n");
                printf("Magnet sensing Mode\r\n");
                printf("===================\r\n");
                for(int i = 0; i < 10; i++) {
                    MPU9250.sen_mag(&mx,&my,&mz);
                    pc.printf("MX = %f,MY = %f,MZ = %f\r\n",mx,my,mz);
                    wait(0.5);
                }
                break;
            }//case'e'

            case'f': {
                //GPS_SW = 1;
                //CAM_SW = 0;
                printf("===================\r\n");
                printf("GPS sensing Mode\r\n");
                printf("===================\r\n");
                while(1) pc.putc(camera.getc());
                break;
            }//case'f'


            case'g': {
                //GPS_SW = 1;
                //CAM_SW = 0;
                printf("===================\r\n");
                pc.printf("GPS GPGGA Mode\r\n");
                printf("===================\r\n");
                int quality=0,stnum=0,gps_check=0;
                char ns='A',ew='B',aunit='m';
                float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
                for(int i=1; i<10; i++) {
                    camera.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
                    if((gps_check==0)|(gps_check==1)) {
                        pc.printf("GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                    }
                }
                break;
            }//case'g'


            case'h': {
                //GPS_SW = 0;
                //CAM_SW = 1;
                wait(0.5);
                printf("\r\n");
                printf("==========\r\n");
                printf("Camera Synchro\r\n");
                printf("==========\r\n");
                camera.Sync();
                break;
            }//case'h'

            case'i': {
                //GPS_SW = 0;
                //CAM_SW = 1;
                printf("\r\n");
                printf("==========\r\n");
                printf("CameraC1098\r\n");
                printf("==========\r\n");
                camera.initialize(HeptaSerial::Baud115200, HeptaSerial::JpegResolution320x240);
                camera.test_jpeg_snapshot_picture(1);

                break;
            }//case'i'

            case'j': {
                //GPS_SW = 0;
                //CAM_SW = 1;
                printf("\r\n");
                printf("==========\r\n");
                printf("CameraC1098\r\n");
                printf("==========\r\n");
                camera.initialize(HeptaSerial::Baud115200, HeptaSerial::JpegResolution320x240);
                camera.test_jpeg_snapshot_data(1);

                break;
            }//case'j'

            case'k': {
                //GPS_SW = 0;
                //CAM_SW = 1;
                printf("\r\n");
                printf("==========\r\n");
                printf("CameraC1098\r\n");
                printf("==========\r\n");
                camera.initialize(HeptaSerial::Baud115200, HeptaSerial::JpegResolution320x240);
                camera.test_jpeg_snapshot_picture(1);

                FILE *fp = fopen("/fs/test.txt", "r");
                if(fp == NULL) {
                    pc.printf("Could not open file for write\r\n");
                } else {
                    char str[1024];
                    while((fgets(str,256,fp))!=NULL) {
                        xbee.printf("%s",str);
                    }
                    fclose(fp);
                }

                break;
            }//case'k'

            case'l': {
                printf("==================\r\n");
                printf("Temp sensing Mode\r\n");
                printf("==================\r\n");
                float temp;
                for(int i = 0; i<100; i++) {
                    heptatemp.temp_sense(&temp);
                    pc.printf("%f\r\n",temp);
                    //xbee.printf("%f\r\n",temp);
                }
                break;
            }//case'l'

            case'm': {

                int i=0,rcmd=0,cmdflag=0;
                xbee.printf("Count Up!\r");
                while(1) {
                    xbee.printf("num = %d\r",i);
                    i++;
                    wait(1.0);
                    xbee.xbee_recieve(&rcmd,&cmdflag);
                    pc.printf("rcmd=%d, cmdflag=%d\r\n",rcmd, cmdflag);
                    if (cmdflag == 1) {
                        if (rcmd == 'a') {
                            pc.printf("Command Get %d\r\n",rcmd);
                            xbee.printf("HEPTA Uplink OK\r");
                        }
                        xbee.initialize();
                    }
                }

                break;
            }//case'm'

            case'n': {
                printf("==================\r\n");
                printf("Temp sensing Mode & Xbee\r\n");
                printf("==================\r\n");
                float temp;
                while(1) {
                    FILE *fp = fopen("/fs/myfile.csv", "a");
                    heptatemp.temp_sense(&temp);
                    pc.printf("%f\r\n",temp);
                    xbee.printf("%f\r\n",temp);
                    fprintf(fp, "%f\n",temp);
                    fclose(fp);
                }
                break;
            }//case'n'

            case'o': {
                //GPS_SW = 1;
                //CAM_SW = 0;
                printf("==================\r\n");
                printf("All Transmitting Mode\r\n");
                printf("==================\r\n");
                char gx[4],gy[4],gz[4],ax[4],ay[4],az[4],mx[4],my[4],mz[4],lad[8],log[8],height[4],bt[4],temp[4];
                char ddata[64];
                int dsize[7];
                while(1) {

                    MPU9250.sen_gyro_u16(gx,gy,gz,&dsize[0]);
                    MPU9250.sen_acc_u16(ax,ay,az,&dsize[1]);
                    MPU9250.sen_mag_u16(mx,my,mz,&dsize[2]);
                    camera.lat_log_sensing_u16(lad,log,height,&dsize[3],&dsize[4]);
                    bat.vol_u16(bt,&dsize[5]);
                    heptatemp.temp_sense_u16(temp,&dsize[6]);
                    xbee.xbee_transmit(ddata,64,gx,gy,gz,ax,ay,az,mx,my,mz,lad,log,height,bt,temp,dsize[0],dsize[0],dsize[0],dsize[1],dsize[1],dsize[1],dsize[2],dsize[2],dsize[2],dsize[3],dsize[3],dsize[4],dsize[5],dsize[6],14);
                }
                break;
            }//case'9'

            default:
                break;


        }
    }
}