#include "mbed.h"
#include "QEI.h"
#include "PID.h"

QEI enc1(PA_8, PA_9, NC, 100, QEI::X4_ENCODING);
DigitalOut led(LED1);
PwmOut A(D5);
PwmOut B(D6);
DigitalOut stop(D13);
Serial pc(USBTX, USBRX, 115200);

PID rori(2.0,0,0,0.01);

int main() {
    stop=1;
    float Angle,AngleSet,power=0.0;
    
    rori.setInputLimits(-180.0,180.0);
    rori.setOutputLimits(-1.0,1.0);
    rori.setBias(0);
    rori.setMode(1);
    rori.setSetPoint(60.0);//
    
    AngleSet = (float)enc1.getPulses();
    while(1){
        Angle = (float)enc1.getPulses()-AngleSet;
        rori.setProcessValue(Angle);
        if(Angle>=60){
            rori.setSetPoint(-60.0);
        }else if(Angle<=-60){
            rori.setSetPoint(60.0);
        }
        power=rori.compute();
        if(power>0){
            A=0;
            B=power;
        }else{
            A=-1*power;
            B=0;
        }
        wait(0.01);
        pc.printf("%.2f\r\n",Angle);
    }
}