#include "mbed.h"
#include "DS18B20Sensor.h"
 
// Instantiate sensor with hardware in pin p30 
DS18B20Sensor sensor(PTB4);
 
// Setup a window to the world
//Serial pc(p13, p14);
Serial pc(USBTX, USBRX);
 
int main()
{
   char sensorBuf[25];
 
   // count will search for sensors, if not already called
   pc.printf("Found %d sensor/s\r", sensor.count());
 
   uint8_t result = sensor.startReading(true);     // start sensor readings and wait
 
   for (uint8_t i = 0; i < sensor.count(); i++) {
      sensor.getReading(sensorBuf, i);         // get result into buf
      pc.printf("Sensor %d : %s\r", i+1, sensorBuf);  // display it to the world
   }
 
}