#include <mbed.h>
#include "DS18B20.h"
#include "OneWireDefs.h"

#define THERMOMETER DS18B20

float temp;
// device( mbed pin )
THERMOMETER device(PTC11);

void readTemp(int deviceNum)
{
    temp = device.readTemperature(deviceNum);
    printf("Device %d is %f\n\r",deviceNum, temp);
    wait(0.5);
}

int main()
{
    
    while (!device.initialize());    // keep calling until it works

    int deviceCount = device.getDeviceCount();
    printf("Found %d sensors\n\r",deviceCount);

    device.setResolution(twelveBit);
    while (true)
    {
        for (int i = 0;i < deviceCount; i++)
            readTemp(i);
    }
}

