//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// main
#include "Maple_test.h"
#include "Maple_console.h"
#include "Maple_OLED.h"
#include "Maple_LCD.h"
#include "Maple_RTC.h"
#include "Maple_I2C.h"
#include "Maple.h"
#include "mbed.h"

// global variables
extern int console_mode;
extern int console_cursor;
extern int console_display;
extern int test_mode;
int test_choice;
int test_char_base;
int test_color[6];
int test_color_cursor;

// test
// display menu
void display_test(char row0[], char row1[], int &cursor_r, int &cursor_c) {
    const int position_r[CURSOR_TEST_SIZE] = {  0};
    const int position_c[CURSOR_TEST_SIZE] = {  0};
    const char select_t[9][17] = {
        "(select Up/Down)",
        " LCD all-font   ",
        " LCD shift-R/L  ",
        " RTC raw-read   ",
        " OLED color 1   ",
        " OLED color 2a  ",
        " OLED color 2b  ",
        " OLED color 2c  ",
        " OLED color font",
    };
    char d[17], s[3];

    switch(test_mode) {
    case TEST_FONT:
        console_display = DISPLAY_OFF;
        break;
        
    case TEST_SHIFT:
        console_display = DISPLAY_OFF;
        break;
        
    case TEST_RTCRAW:
        LCD_return_home();
        console_display = DISPLAY_ON;
        i2c_RTC_read(RTC_REG_CONTROL1, d, 16);
        for(int i = 0; i < 8; ++i) {
            copy_string(row0, i * 2, 2, int_to_hex2(d[i], s));
            row0[16] = '\0';
        }
        for(int i = 0; i < 8; ++i) {
            copy_string(row1, i * 2, 2, int_to_hex2(d[i + 8], s));
            row1[16] = '\0';
        }
        break;
        
    case TEST_OLEDCF:
        LCD_return_home();
        console_display = DISPLAY_ON;
        copy_string(row0, 0, 17, ">OLED color font");
        copy_string(row1, 0, 17, "exit<B>     test");
        break;
        
    default:
        LCD_return_home();
        console_display = DISPLAY_ON;
        copy_string(row0, 0, 17, select_t[test_choice]);
        copy_string(row1, 0, 17, "exec<B>     test");
    }
    cursor_r = position_r[console_cursor];
    cursor_c = position_c[console_cursor];
}

// enter mode test
void enter_mode_test() {
    console_mode = MODE_TEST;
    console_cursor = CURSOR_TEST_INIT;
    test_mode = TEST_HOME;
    test_choice = TEST_HOME;
}

// function select
void test_function() {
    switch(test_choice) {
    case TEST_FONT:
        if(test_mode == TEST_FONT) {
            test_mode = TEST_HOME;
        }
        else {
            test_mode = TEST_FONT;
            test_char_base = 0x20;
            LCD_print_n_char(test_char_base, 0x10);
        }
        break;

    case TEST_SHIFT:
        if(test_mode == TEST_SHIFT) {
            test_mode = TEST_HOME;
        }
        else {
            test_mode = TEST_SHIFT;
            test_char_base = 0x40;
            LCD_print_n_char(test_char_base, 0x20);
        }
        break;

    case TEST_RTCRAW:
        if(test_mode == TEST_RTCRAW) {
            test_mode = TEST_HOME;
        }
        else {
            test_mode = TEST_RTCRAW;
        }
        break;

    case TEST_OLEDC1:
        test_mode = TEST_HOME;
        OLED_test_c1();
        break;

    case TEST_OLEDC2A:
        test_mode = TEST_HOME;
        OLED_test_c2a();
        break;

    case TEST_OLEDC2B:
        test_mode = TEST_HOME;
        OLED_test_c2b();
        break;

    case TEST_OLEDC2C:
        test_mode = TEST_HOME;
        OLED_test_c2c();
        break;

    case TEST_OLEDCF:
        if(test_mode == TEST_OLEDCF) {
            test_mode = TEST_HOME;
        }
        else {
            test_mode = TEST_OLEDCF;
            test_color_cursor = 0;
            test_color[0] = 0x30;
            test_color[1] = 0x30;
            test_color[2] = 0x30;
            test_color[3] = 0x10;
            test_color[4] = 0x10;
            test_color[5] = 0x10;
            OLED_test_cf();
        }
        break;

    default:
        button_exit();
    }
}

// left, right
void cursor_move_test(int flag) {
    switch(test_mode) {
    case TEST_SHIFT:
        LCD_cursor_or_display_shift(1, flag?0:1);
        break;

    case TEST_OLEDCF:
        switch(flag) {
        case 0:     // move left .. decrement
            if(test_color_cursor == 0) {
                test_color_cursor = 6;
            }
            --test_color_cursor;
            break;
        default:    // move right .. increment
            ++test_color_cursor;
            if(test_color_cursor >= 6) {
                test_color_cursor = 0;
            }
        }
        OLED_test_cf();
        break;

    default:
        test_mode = TEST_HOME;
    }
}

// increment, decrement
void button_xxcrement_test(int flag) {
    switch(test_mode) {
    case TEST_HOME:
        switch(flag) {
        case 0:
            ++test_choice;
            if(test_choice == TEST_SIZE) {
                test_choice = 0;
            }
            break;    
        default:
            if(test_choice == 0) {
                test_choice = TEST_SIZE;
            }
            --test_choice;
        }
        break;

    case TEST_FONT:
        switch(flag) {
        case 0:
            if(test_char_base > 0x00) {
                test_char_base -= 0x20;
            }
            break;
        default:
            if(test_char_base < 0xe0) {
                test_char_base += 0x20;
            }
        }
        LCD_print_n_char(test_char_base, 0x10);
        break;

    case TEST_SHIFT:
        switch(flag) {
        case 0:
            if(test_char_base > 0x00) {
                test_char_base -= 0x40;
            }
            break;    
        default:
            if(test_char_base < 0xc0) {
                test_char_base += 0x40;
            }
        }
        LCD_print_n_char(test_char_base, 0x20);
        break;

    case TEST_OLEDCF:
        switch(flag) {
        case 0:
            if(test_color[test_color_cursor] > 0) {
                --test_color[test_color_cursor];
            }
            break;
        default:
            if(test_color[test_color_cursor] < 0x3f) {
                ++test_color[test_color_cursor];
            }
        }
        OLED_test_cf();
        break;

    default:
        test_mode = TEST_HOME;
    }
}

// print n characters in 2 lines
static void LCD_print_n_char(char base, int length) {
    LCD_locate(0, 0);
    for(int i = 0; i < length; ++i) {
        LCD_print_char(base + i);
    }
    LCD_locate(1, 0);
    for(int i = length; i < length * 2; ++i) {
        LCD_print_char(base + i);
    }
}

// OLED test: color variation 1
void OLED_test_c1() {
    int a, b, c;

    OLED_cs_assert(1);
    OLED_cs_assert(2);
    for(b = 0; b < 0x40; ++b) {
        for(c = 0; c < 0x40; ++c) {
            OLED_set_color(1, 0, b, c);
            OLED_fill_rectangle(1, c, 1, b, 1);
        }
    }
    for(c = 0; c < 0x40; ++c) {
        for(a = 0; a < 0x40; ++a) {
            OLED_set_color(1, a, 0, c);
            OLED_fill_rectangle(1, 0x40 + a, 1, c, 1);
        }
    }
    for(a = 0; a < 0x40; ++a) {
        for(b = 0; b < 0x40; ++b) {
            OLED_set_color(1, a, b, 0);
            OLED_fill_rectangle(1, b, 1, 0x40 + a, 1);
        }
    }
    for(int i = 0; i < 0x40; ++i) {
        OLED_set_color(1, i, 0, 0);
        OLED_fill_rectangle(1, 0x40 + i, 1, 0x40, 0x10);
        OLED_set_color(1, 0, i, 0);
        OLED_fill_rectangle(1, 0x40 + i, 1, 0x50, 0x10);
        OLED_set_color(1, 0, 0, i);
        OLED_fill_rectangle(1, 0x40 + i, 1, 0x60, 0x10);
        OLED_set_color(1, i, i, i);
        OLED_fill_rectangle(1, 0x40 + i, 1, 0x70, 0x10);
    }
    OLED_cs_negate();
}

// OLED test: color variation 2a
void OLED_test_c2a() {
    OLED_cs_assert(1);
    OLED_cs_assert(2);
    for(int i = 0; i < 0x80; ++i) {
        for(int j = 0; j < 0x80; ++j) {
            OLED_set_color(1, (j / 0x20) * 0x10 + (i / 0x20) * 0x04, (i % 0x20) * 2, (j % 0x20) * 2);
            OLED_fill_rectangle(1, i, 1, j, 1);
        }
    }
    OLED_cs_negate();
}

// OLED test: color variation 2b
void OLED_test_c2b() {
    OLED_cs_assert(1);
    OLED_cs_assert(2);
    for(int i = 0; i < 0x80; ++i) {
        for(int j = 0; j < 0x80; ++j) {
            OLED_set_color(1, (j % 0x20) * 2, (j / 0x20) * 0x10 + (i / 0x20) * 0x04, (i % 0x20) * 2);
            OLED_fill_rectangle(1, i, 1, j, 1);
        }
    }
    OLED_cs_negate();
}

// OLED test: color variation 2c
void OLED_test_c2c() {
    OLED_cs_assert(1);
    OLED_cs_assert(2);
    for(int i = 0; i < 0x80; ++i) {
        for(int j = 0; j < 0x80; ++j) {
            OLED_set_color(1, (i % 0x20) * 2, (j % 0x20) * 2, (j / 0x20) * 0x10 + (i / 0x20) * 0x04);
            OLED_fill_rectangle(1, i, 1, j, 1);
        }
    }
    OLED_cs_negate();
}

// OLED test: color variation 1
void OLED_test_cf() {
    OLED_cs_assert(1);
    OLED_cs_assert(2);

    OLED_set_color(0, 0, 0, 0);
    OLED_clear_screen(0);

    for(int i = 0; i < 6; ++i) {
        if(i < 3) {
            OLED_set_cursor( i * 0x10, 0x71);
        }
        else {
            OLED_set_cursor( i * 0x10 + 0x10, 0x71);
        }
        if(i == test_color_cursor) {
            OLED_set_color(1, 0, 0, 0);
            OLED_set_color(0, 0x3f, 0x3f, 0x3f);
        }
        else {
            OLED_set_color(0, 0, 0, 0);
            OLED_set_color(1, 0x3f, 0x3f, 0x3f);
        }
        OLED_print_hex(test_color[i]);
    } 

    OLED_set_color(1, test_color[0], test_color[1], test_color[2]);
    OLED_fill_rectangle(1, 0x00, 0x30, 0x40, 0x10);
    OLED_set_color(1, test_color[0], 0, 0);
    OLED_fill_rectangle(1, 0x00, 0x10, 0x50, 0x20);
    OLED_set_color(1, 0, test_color[1], 0);
    OLED_fill_rectangle(1, 0x10, 0x10, 0x50, 0x20);
    OLED_set_color(1, 0, 0, test_color[2]);
    OLED_fill_rectangle(1, 0x20, 0x10, 0x50, 0x20);

    OLED_set_color(0, test_color[3], test_color[4], test_color[5]);
    OLED_fill_rectangle(0, 0x40, 0x30, 0x40, 0x10);
    OLED_set_color(0, test_color[3], 0, 0);
    OLED_fill_rectangle(0, 0x40, 0x10, 0x50, 0x20);
    OLED_set_color(0, 0, test_color[4], 0);
    OLED_fill_rectangle(0, 0x50, 0x10, 0x50, 0x20);
    OLED_set_color(0, 0, 0, test_color[5]);
    OLED_fill_rectangle(0, 0x60, 0x10, 0x50, 0x20);

    OLED_set_color(1, test_color[0], test_color[1], test_color[2]);
    OLED_set_color(0, test_color[3], test_color[4], test_color[5]);
    OLED_set_cursor(0, 0);
    for(int i = 0x20; i < 0x80; i += 0x10) {
        for(char ch = i; ch < i + 0x10; ++ch) {
            OLED_print_character(ch);
        }
        OLED_print_string("\r\n");
    }
    OLED_cs_negate();
}
