//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// operation console utilizing text-LCD and buttons
#ifndef MAPLE_CONSOLE_H_
#define MAPLE_CONSOLE_H_

// constants
#define CONSOLE_REFRESH_RATE    0.1 // 100ms

#define DISPLAY_OFF     0
#define DISPLAY_ON      1

#define MODE_CLOCK      0
#define MODE_ADJUST     1
#define MODE_ALARM      2
#define MODE_TIMER      3
#define MODE_TEST       4

#define BUTTON_A        0
#define BUTTON_B        1
#define BUTTON_LEFT     2
#define BUTTON_DOWN     3
#define BUTTON_RIGHT    4
#define BUTTON_UP       5
#define BUTTON_SIZE     6

#define BUTTON_OFF      1
#define BUTTON_ON       0

#define BUTTON_THRESHOLD        0   // 0 x 100ms
#define BUTTON_REPEAT           10  // 1s
#define BUTTON_FAST             40  // 4s
#define BUTTON_PERIOD_REPEAT    3   // 300ms
#define BUTTON_PERIOD_FAST      1   // 100ms

#define BUTTON_IDLE 0   // button status not active
#define BUTTON_BUSY 1   // button status active once and repeat

// proto types
void console_initialize();
void console_refresh();

static void refresh_display();
static void button_action();
static void button_check(int r, int button_number);
static bool button_trigger(int b, int r, int f);
void button_exit();
static void button_function();
static void button_cursor_move(int flag);
void cursor_move(int flag, int cursor_max);
static void button_xxcrement(int flag);

#endif
