//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// alarm clock
#ifndef MAPLE_ALARM_CLOCK_H_
#define MAPLE_ALARM_CLOCK_H_

// constants
#define CURSOR_CLOCK_TIMER_FLAG    0
#define CURSOR_CLOCK_ALARM_FLAG    1
#define CURSOR_CLOCK_SIZE          2
#define CURSOR_CLOCK_INIT          1

#define CURSOR_ADJUST_CENTURY   0
#define CURSOR_ADJUST_YEAR      1
#define CURSOR_ADJUST_MONTH     2
#define CURSOR_ADJUST_DAY       3
#define CURSOR_ADJUST_HOUR      4
#define CURSOR_ADJUST_MINUTE    5
#define CURSOR_ADJUST_SECOND    6
#define CURSOR_ADJUST_SIZE      7
#define CURSOR_ADJUST_INIT      6

#define CURSOR_ALARM_DAY_DISABLE        0
#define CURSOR_ALARM_DAY                1
#define CURSOR_ALARM_WEEKDAY_DISABLE    2
#define CURSOR_ALARM_WEEKDAY            3
#define CURSOR_ALARM_INTERRUPT          4
#define CURSOR_ALARM_FLAG               5
#define CURSOR_ALARM_HOUR_DISABLE       6
#define CURSOR_ALARM_HOUR               7
#define CURSOR_ALARM_MINUTE_DISABLE     8
#define CURSOR_ALARM_MINUTE             9
#define CURSOR_ALARM_SIZE               10
#define CURSOR_ALARM_INIT               5

#define CURSOR_TIMER_SELECT     0
#define CURSOR_TIMER_COUNT      1
#define CURSOR_CLKOUT_ENABLE    2
#define CURSOR_TIMER_PERIODIC   3
#define CURSOR_TIMER_ENABLE     4
#define CURSOR_TIMER_INTERRUPT  5
#define CURSOR_TIMER_FLAG       6
#define CURSOR_CLKOUT_FREQUENCY 7
#define CURSOR_TIMER_SIZE       8
#define CURSOR_TIMER_INIT       6

// proto types
void display_clock( char row0[], char row1[], int &cursor_r, int &cursor_c);
void display_adjust(char row0[], char row1[], int &cursor_r, int &cursor_c);
void display_alarm( char row0[], char row1[], int &cursor_r, int &cursor_c);
void display_timer( char row0[], char row1[], int &cursor_r, int &cursor_c);

void enter_mode_clock();
void enter_mode_adjust();
void enter_mode_alarm();
void enter_mode_timer();

void cursor_move_clock( int flag);
void cursor_move_adjust(int flag);
void cursor_move_alarm( int flag);
void cursor_move_timer( int flag);

void button_xxcrement_clock( int flag);
void button_xxcrement_adjust(int flag);
static void button_xxcrement_adjust_date(int flag);
void button_xxcrement_alarm( int flag);
void button_xxcrement_timer( int flag);

#endif
