//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// RTC(RX-8564LC) driver
#ifndef MAPLE_RTC_H_
#define MAPLE_RTC_H_

// RTC register address
#define RTC_REG_CONTROL1            0x00
#define RTC_REG_CONTROL2            0x01
#define RTC_REG_SECOND              0x02
#define RTC_REG_MINUTE              0x03
#define RTC_REG_HOUR                0x04
#define RTC_REG_DAY                 0x05
#define RTC_REG_WEEKDAY             0x06
#define RTC_REG_MONTH_CENTURY       0x07
#define RTC_REG_YEAR                0x08
#define RTC_REG_ALARM_MINUTE        0x09
#define RTC_REG_ALARM_HOUR          0x0a
#define RTC_REG_ALARM_DAY           0x0b
#define RTC_REG_ALARM_WEEKDAY       0x0c
#define RTC_REG_CLKOUT_FREQUENCY    0x0d
#define RTC_REG_TIMER_CONTROL       0x0e
#define RTC_REG_TIMER               0x0f

// RTC register bits
#define RTC_STOP                    0x20    // RTC_REG_CONTROL1 
#define RTC_START                   0x00    // RTC_REG_CONTROL1
#define RTC_TIMER_PERIODIC          0x10    // RTC_REG_CONTROL2
#define RTC_ALARM_FLAG              0x08    // RTC_REG_CONTROL2
#define RTC_TIMER_FLAG              0x04    // RTC_REG_CONTROL2
#define RTC_ALARM_INTERRUPT_ENABLE  0x02    // RTC_REG_CONTROL2
#define RTC_TIMER_INTERRUPT_ENABLE  0x01    // RTC_REG_CONTROL2
#define RTC_VOLTAGE_LOW             0x80    // RTC_REG_SECOND
#define RTC_CENTURY                 0x80    // RTC_REG_MONTH_CENTURY
#define RTC_ALARM_DISABLE           0x80    // RTC_REG_ALARM_xx, AE=1: disable
#define RTC_CLKOUT_ENABLE           0x80    // RTC_REG_CLKOUT_FREQUENCY
#define RTC_TIMER_ENABLE            0x80    // RTC_REG_TIMER_CONTROL

// prototypes
void RTC_initialize();
char RTC_read1(int reg_address);
void RTC_write1(int reg_address, char write_data); 
char RTC_stop_read1(int reg_address);
void RTC_write1_start(int reg_address, char write_data); 
void RTC_stop_read_date(char &century, char &bcd_year, char &bcd_month, char &bcd_day);
void RTC_write_date_start(char century, char bcd_year, char bcd_month, char bcd_day, char weekday);

#endif
