//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// RTC(RX-8564LC) driver
#include "Maple_RTC.h"
#include "Maple_I2C.h"
#include "Maple.h"
#include "mbed.h"

//RTC initialize by sample data
void RTC_initialize() {
    char d[18];

    i2c_RTC_read(RTC_REG_SECOND, d, 1);
    if((d[0] & RTC_VOLTAGE_LOW) != 0) { // when RTC registers are not valid
        RTC_write1(RTC_REG_CONTROL1, RTC_STOP);
        d[ 0] = RTC_REG_CONTROL1;   // reg address to write 
        d[ 1] = 0x20;               // RTC_REG_CONTROL1         stop=1 
        d[ 2] = 0x00;               // RTC_REG_CONTROL2         TI/TP=0, AF=0, TF=0, AIE=0, TIE=0
        d[ 3] = 0x00;               // RTC_REG_SECOND           00:00:00
        d[ 4] = 0x00;               // RTC_REG_MINUTE
        d[ 5] = 0x00;               // RTC_REG_HOUR
        d[ 6] = 0x01;               // RTC_REG_DAY              2000/01/01(SAT)
        d[ 7] = 0x06;               // RTC_REG_WEEKDAY
        d[ 8] = 0x01;               // RTC_REG_MONTH_CENTURY
        d[ 9] = 0x00;               // RTC_REG_YEAR
        d[10] = 0xb0;               // RTC_REG_ALARM_MINUTE     AE=1, minute=30
        d[11] = 0x92;               // RTC_REG_ALARM_HOUR       AE=1, hour=12
        d[12] = 0x85;               // RTC_REG_ALARM_DAY        AE=1, day=05
        d[13] = 0x85;               // RTC_REG_ALARM_WEEKDAY    AE=1, weekday=FRI
        d[14] = 0x00;               // RTC_REG_CLKOUT_FREQUENCY FE=0, FD=00
        d[15] = 0x00;               // RTC_REG_TIMER_CONTROL    TE=0, TD=00
        d[16] = 0xff;               // RTC_REG_TIMER            preset=0xff
        i2c_RTC_write(d, 17);
        RTC_write1(RTC_REG_CONTROL1, RTC_START);
    }
}

// RTC read a register 
char RTC_read1(int reg_address) {
    char d[2];

    i2c_RTC_read(reg_address, d, 1);
    return d[0];
}

// RTC write a register
void RTC_write1(int reg_address, char write_data) { 
    char d[3];

    d[0] = reg_address;
    d[1] = write_data;
    d[2] = '\0';
    i2c_RTC_write(d, 2);
}

// RTC stop and read a register 
char RTC_stop_read1(int reg_address) {
    RTC_write1(RTC_REG_CONTROL1, RTC_STOP);
    return RTC_read1(reg_address);
}

// RTC write a register and start
void RTC_write1_start(int reg_address, char write_data) { 
    RTC_write1(reg_address, write_data);
    RTC_write1(RTC_REG_CONTROL1, RTC_START);
}

// RTC stop and read century, year, month, day in BCD 
void RTC_stop_read_date(char &century, char &bcd_year, char &bcd_month, char &bcd_day) {
    char d[5];

    RTC_write1(RTC_REG_CONTROL1, RTC_STOP);
    i2c_RTC_read(RTC_REG_DAY, d, 4);
    century   = (d[2] & RTC_CENTURY) >> 7;
    bcd_year  = d[3];
    bcd_month = d[2] & 0x1f;
    bcd_day   = d[0] & 0x3f;
}

// RTC write century, year, month, day, weekday in BCD and start
void RTC_write_date_start(char century, char bcd_year, char bcd_month, char bcd_day, char weekday) { 
    char d[6];

    d[0] = RTC_REG_DAY;
    d[1] = bcd_day;
    d[2] = weekday;
    d[3] = bcd_month | (century << 7);
    d[4] = bcd_year;
    i2c_RTC_write(d, 5);
    RTC_write1(RTC_REG_CONTROL1, RTC_START);
}
