//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// OLED(UG-2828GDEDF11, SSD1351) driver
#ifndef MAPLE_OLED_H_
#define MAPLE_OLED_H_

// SPI interface
#define CS_ASSERT   0
#define CS_NEGATE   1

// OLED interface
#define OLED_POWER_ON   1
#define OLED_POWER_OFF  0
#define OLED_RESET_ON   0
#define OLED_RESET_OFF  1

// OLED specification 
#define OLED_COLUMN_MAX     0x7f
#define OLED_ROW_MAX        0x7f

// OLED font related 
#define OLED_FONT_SIZE_X    6
#define OLED_FONT_SIZE_Y    9

// prototypes
void OLED_cs_assert(int slot);
void OLED_cs_negate();

void OLED_set_column_address(int a, int b);
void OLED_set_row_address(int a, int b);
void OLED_write_ram_command();
void OLED_read_ram_command();
void OLED_set_remap_color_depth(int a);
void OLED_set_display_start_line(int a);
void OLED_set_display_offset(int a);
void OLED_set_display_mode_all_off();
void OLED_set_display_mode_all_on();
void OLED_set_display_mode_normal();
void OLED_set_display_mode_inverse();
void OLED_function_selection(int a);
void OLED_no_operation_ad();
void OLED_set_sleep_mode_on();
void OLED_set_sleep_mode_off();
void OLED_no_operation_b0();
void OLED_set_reset_pre_charge_period(int a);
void OLED_display_enhancement(int a, int b, int c);
void OLED_front_clock_divider_oscillator_frequency(int a);
void OLED_set_segment_low_voltage();
void OLED_set_GPIO(int a);
void OLED_set_second_pre_charge_period(int a);
void OLED_look_up_table_for_gray_scale_pulse_width();
void OLED_use_built_in_linear_lut();
void OLED_set_pre_charge_voltage(int a);
void OLED_set_vcomh_voltage(int a);
void OLED_set_contrast_for_color_abc(int a, int b, int c);
void OLED_master_contrast_current_control(int a);
void OLED_set_mux_ratio(int a);
void OLED_no_operation_d1();
void OLED_no_operation_e3();
void OLED_set_command_lock(int a);
void OLED_horizontal_scroll(int a, int b, int c, int d, int e);
void OLED_stop_moving();
void OLED_start_moving();

void OLED_initialize();
static void OLED_initialize_sub();

void OLED_set_color(int mode, int a, int b, int c);
void OLED_set_cursor(int x, int y);
void OLED_clear_screen(int mode);
void OLED_fill_rectangle(int mode, int cs, int cl, int rs, int rl);
void OLED_write_pixel(int mode);

void OLED_print_string(char s[]);
void OLED_print_hex(int i);
void OLED_print_character(char ch);

#endif
