//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// LCD(TC1602E-25A) driver
// - 4-bit I/O port.
// - "r/w" is fixed to "w". Read instructions do not work.
#ifndef MAPLE_LCD_H_
#define MAPLE_LCD_H_

// prototypes
void LCD_clear_display();
void LCD_return_home();
void LCD_entry_mode_set(int id, int s);
void LCD_display_on_off_control(int d, int c, int b);
void LCD_cursor_or_display_shift(int sc, int rl);
void LCD_function_set(int n, int f);
void LCD_set_CGRAM_address(int a);
void LCD_set_DDRAM_address(int a);
char LCD_read_busy_flag_and_address();
void LCD_write_data_to_CG_or_DDRAM(char d);
char LCD_read_data_from_CG_or_DDRAM();
void LCD_CGRAM_customize();

void LCD_initialize();
void LCD_print_char(char c);
void LCD_print_string(char s[]);
void LCD_print_hex(int i);
void LCD_locate(int row, int column);
void LCD_cursor_on();
void LCD_cursor_off();

#endif
