//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// I2C driver
//   RTC, BTN, ..
#include "Maple_I2C.h"
#include "mbed.h"

// I2C interface
I2C i2c(p28, p27);  // Create an I2C master interface (SDA: data, SCL: clock)

// BTN=button(PCA8574N) driver
// I2C write to BTN
void i2c_BTN_write(char write_data) {
    char w[2];

    w[0] = write_data;
    w[1] = '\0';
    i2c.write(BTN_ADDR_WRITE, w, 1);
}

// BTN=button(PCA8574N) driver
// I2C read from BTN
char i2c_BTN_read() {
    char r[2];

    i2c.read(BTN_ADDR_READ, r, 1);
    return r[0];
}

// I2C write to RTC register
//   write_data[0]   : write address
//   write_data[1-16]: RTC register data
//   write_data[17]  : for '\0'
//   byte_count      : + 1 for write address
void i2c_RTC_write(char write_data[], int byte_count) {

    i2c.write(RTC_ADDR_WRITE, write_data, byte_count);
}

// I2C read from RTC register
//   read_data[0-15]: RTC register data
char* i2c_RTC_read(int read_address, char read_data[], int byte_count) {
    char w[2];
    
    w[0] = read_address;
    w[1] = '\0';
    i2c.write(RTC_ADDR_WRITE, w, 1);
    i2c.read(RTC_ADDR_READ, read_data, byte_count);
    return read_data;
}
