//copyright 2011 Uehara Yoshiyuki
//====================================================================
//The author provide the programs without any guarantees or warranty.
//The author is not responsible for any damage or losses of any kind 
//caused by using or misusing of the programs.
//The author is under no obligation to provide support, service, 
//corrections, or upgrades to the programs.
//====================================================================
// MAPLE board[MARM01-BASE]
// common functions
#include "Maple.h"
#include "mbed.h"

// string copy
char* copy_string(char destination_string[], int destination_position, int copy_length, const char source_string[]) {
    for(int i = 0; i < copy_length; ++i) {
        destination_string[destination_position + i] = source_string[i];
    }
    return destination_string;
}

// integer(4 bits) to hexadecimal character(1 digit)
char int_to_hex1(int i) {
    const char hex[] = "0123456789abcdef";

    return hex[i & 0x0f];
}

// integer(1 byte) to hexadecimal character(2 digits)
char* int_to_hex2(int i, char h[]) {
    h[0] = int_to_hex1(i >> 4);
    h[1] = int_to_hex1(i);
    h[2] = '\0';
    return h;
}

// BCD(1 byte) to integer
int bcd_to_int(char b) {
    return ((b >> 4) * 10) + (b & 0x0f);
}

// integer to BCD(1 byte)
char int_to_bcd(int i) {
    return ((i / 10) << 4) + (i % 10);
}

// decrement/increment BCD
//   flag 0:decrement, 1:increment
//    min,  max
//   0x00, 0x99 .. 00-99: year  0x00
//   0x01, 0x12 .. 01-12: month
//   0x01, max  .. 01-max: day
//   0x00, 0x23 .. 00-23: hour
//   0x00, 0x59 .. 00-59: minute, second
char xxcrement_bcd(int flag, char bcd_data, char bcd_min, char bcd_max) {
    if(flag == 0) {
        if(bcd_data < (bcd_min + 0x01)) {
            bcd_data = bcd_max;
        }        
        else if((bcd_data & 0x0f) == 0x00) {
            bcd_data -= 0x07;   // - 0x10 + 0x0a - 0x01;
        }
        else {
            bcd_data -= 0x01;
        }
        return bcd_data;
    }
    else {
        if((bcd_data & 0x0f) == 0x09) {
            bcd_data += 0x07;   // + 0x10 - 0x0a + 0x01
        }
        else {
            bcd_data += 0x01;
        }
        if(bcd_data > bcd_max) {
            bcd_data = bcd_min;
        }
        return bcd_data;
    }
}

// weekday to string(3 characters)
//   0(SUN) .. 6(SAT)
const char* weekday_to_string(int w, const char* s) {
    const char* weekday_string[7] = {"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};

    s = weekday_string[w];
    return s;
}

// year in 2cyy format
//   bcd_century .. 0x00/0x01
int bcd_to_year(char century, char bcd_year) {
    return 2000 + (century * 100) + bcd_to_int(bcd_year);
}

// check leap year
//   false: no, true:yes
bool leap_year(int year) {
    return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
}

// days in a month
int days_in_month(int year, int month) {
    const int days_leap[13]   = { 0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
    const int days_common[13] = { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

    if(leap_year(year)) {
        return days_leap[month];
    }
    else {
        return days_common[month];
    }
}

// days(BCD  in a month in BCD
char bcd_days_in_month(char bcd_century, char bcd_year, char bcd_month) {
    return int_to_bcd(days_in_month(bcd_to_year(bcd_century, bcd_year), bcd_to_int(bcd_month)));
}

// Zeller's congruence for Calendario gregoriano
//   0:SUN .. 6:SAT
int bcd_date_to_weekday(char bcd_century, char bcd_year, char bcd_month, char bcd_day) {
    int century, year, month, day;

    century = 20 + bcd_century;
    year    = bcd_to_int(bcd_year);
    month   = bcd_to_int(bcd_month);
    day     = bcd_to_int(bcd_day);
    return (day + (((month + 1) * 26 ) / 10) + year + year / 4 + century / 4 - century * 2 + 6) % 7;
}
