#include "mbed.h"
#include <string.h>
#include <stdio.h>
//Initialize peripheral ports.
DigitalOut light(LED_GREEN);
DigitalOut ac(LED_RED);
DigitalOut tv(LED_BLUE);
DigitalOut open_curtain(D9);
DigitalOut close_curtain(D8);
Serial bt(PTC15, PTC14);
char speech[255] = "";

int main()
{
    //initialize peripherals
    int curtain_pos = 0;
    light = 1;
    ac = 1;
    tv = 1;
    open_curtain = 0;
    close_curtain = 0;
    unsigned char rx;
    bt.baud(9600);
    while (1) {
        //check if data available via bluetooth
        if(bt.readable()) {
            rx = bt.getc();
            speech[0] = rx;

            //do respective task from code received by bluetooth
            if(strstr(speech,"1")!=NULL) {
                light = 0;
            }
            if(strstr(speech,"2")!=NULL) {
                light = 1;
            }
            if(strstr(speech,"3")!=NULL) {
                light = !light;
            }
            if(strstr(speech,"4")!=NULL) {
                ac = 0;
            }
            if(strstr(speech,"5")!=NULL) {
                ac = 1;
            }
            if(strstr(speech,"6")!=NULL) {
                ac = !ac;
            }
            if(strstr(speech,"7")!=NULL) {
                tv = 0;
              //  d9 = !d9;
            }
            if(strstr(speech,"8")!=NULL) {
                tv = 1;
            }
            if(strstr(speech,"9")!=NULL) {
                tv = !tv;
            }
            if(strstr(speech,"a")!=NULL) {
                ac = 0;
                light = 0;
                tv = 0;
                open_curtain = 1;
            }
            if(strstr(speech,"b")!=NULL) {
                ac = 1;
                light = 1;
                tv = 1;
                open_curtain = 0;
            }
            if(strstr(speech,"c")!=NULL) {
                ac = !ac;
                light = !light;
                tv = !tv;
                open_curtain = !open_curtain;
            }
            if(strstr(speech,"d")!=NULL) {
                printf("open curtain");
                close_curtain = 0;
                open_curtain = 1;
                wait_ms(10000);
                open_curtain =0;
                curtain_pos = 1;        
            }
            if(strstr(speech,"e")!=NULL) {
                close_curtain = 0;
                open_curtain = 1;
                wait_ms(5000);
                open_curtain =0;
                curtain_pos = 2;
            }
            if(strstr(speech,"f")!=NULL) {
                open_curtain = 0;
                close_curtain = 1;
                if(curtain_pos ==1)wait_ms(10000);
                else if(curtain_pos ==2)wait_ms(5000);
                close_curtain =0;
            }
        }
    }
}