#include <sstream>
#include "mbed.h"
#include "PN532.h"
#include "PN532_HSU.h"
#include "PN532_SPI.h"
#include "PN532_I2C.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "7QKJFB65MJBCNM3L";
EthernetInterface eth;
TCPSocketConnection sock;
DigitalOut ledBrd (LED1);   // arducleo onboard led
Serial pc(USBTX, USBRX);

// ----------------------------------------- HSU
//HardwareSerial pn532_hsu (PC_10, PC_11);
//PN532_HSU pn532_if (pn532_hsu);

// ----------------------------------------- SPI
SPI pn532_spi (D11, D12, D13);
PN532_SPI pn532_if (pn532_spi, D10);

// ----------------------------------------- I2C
//I2C pn532_i2c (I2C_SDA, I2C_SCL);
//PN532_I2C pn532_if (pn532_i2c);

PN532 nfc(pn532_if);
void setup(void)
{
    ledBrd = 0;
    uint32_t versiondata = 0;
    pc.baud(115200);
    while (1) {
        nfc.begin();
        versiondata = nfc.getFirmwareVersion();
        if (! versiondata) {
            pc.printf("Didn't find PN53x board\n\n\r");
            wait_ms(500);
        } else {
            break;
        }
    }
    pc.printf ("\rFound chip PN5%02X , Firmware ver. %d.%d\n",
               (versiondata>>24) & 0xFF,
               (versiondata>>16) & 0xFF,
               (versiondata>>8) & 0xFF);
    nfc.setPassiveActivationRetries(0xFF);

    // configure board to read RFID tags
    //nfc.SAMConfig();

    pc.printf ("\n\rWaiting for an ISO14443A card\n");
}
void loop(void)
{
    bool success;
    uint8_t uid[] = { 0, 0, 0, 0, 0, 0, 0 };
    uint8_t uidLength;
    success = nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, &uid[0], &uidLength);

    if (success) {
        pc.printf("\n\rFound a card!\n\r");
        pc.printf("UID Length: %d bytes\n\r", uidLength);
        pc.printf("UID Value: ");
        for (uint8_t i=0; i < uidLength; i++) {
            pc.printf(" 0x%02X", uid[i]);
        }
        uint8_t data[4];
        char card[4];
        memcpy(card, (const char[]) { 'a', 'n', 'i', 'k'
        }, sizeof card);
        // If you want to write something to block 4 to test with, uncomment
        // the following line and this text should be read back in a minute
        //memcpy(data, (const uint8_t[]){ 'a', 'n', 'i', 'k'}, sizeof data);
        //success = nfc.mifareclassic_WriteDataBlock (4, data);

        // Try to read the contents of block 4
        success = nfc.mifareclassic_ReadDataBlock(4, data);
        if (success) {
            char s = 's';
            for (uint8_t i = 0; i < 4; i++) {
                char c = data[i];
                if(c!=card[i]) {
                    s='f';
                }
            }
            char str[]="";
            int value = 0;
            if(s=='s') {
                pc.printf("\n\rCard for Aniket Accessed\n\r");
                strcat(str, "Aniket's Card Accessed");
                value = 1;
            } else {
                pc.printf("\n\rNo access for this card\n\r");
                strcat(str,"Invalid Card Accessed");
                value = 404;
            }
            HTTPClient http;
            char buffer[256];
            sprintf(buffer,"%s?api_key=%s&field1=%d",thingSpeakUrl,thingSpeakKey,value);
            printf("Send to %s\r\n", buffer);
            http.get(buffer, buffer , 10);
        }
        wait_ms (10000);
    } else {
        // PN532 probably timed out waiting for a card
        pc.printf("\n\rWaiting for a card\n\r");
        wait_ms (5000);
    }
}


/*==============================================================================
 * \brief main entry
 */
int main()
{

    eth.init(); //Use DHCP
    eth.connect();
    printf("\n\rEthernet connected, and IP Address is %s\n\r", eth.getIPAddress());
    setup();

    while (1)
        loop ();
    eth.disconnect();
}

