//Class created by J. C. Hanson
//3 June 2019
//Purpose: to obtain rate information directly from FPGA

#ifndef SN_SnRateListener
#define SN_SnRateListener

#include "mbed.h"
#include "SnConstants.h"

class SnRateListener
{
    public:
        SnRateListener() : 
        rateMSBs(0), 
        rateLSBs(0), 
        lastAcknowledge(false), 
        MMFC_address(0x47 << 1) 
        {};
        float getRate(); //Single channel rate (4-in. OR), units: MHz
        ~SnRateListener(){};
    protected:
        uint8_t rateMSBs;
        uint8_t rateLSBs;
        bool lastAcknowledge; //True means successfully reading from MMFC.
        void setMSBs(uint8_t);
        void setLSBs(uint8_t);
        void setLastAck(bool);
        bool getLastAck();
        uint8_t getMMFCAddress();
    private:
        //i2c address are left-shifted by 1 bit in mbed os 2.
        uint8_t MMFC_address;
};

#endif