#ifndef SN_SnL1SingleFreqSupp
#define SN_SnL1SingleFreqSupp

#include "SnConstants.h"
#include "SnEventFrame.h"
#include "SnSigProcUtils.h"

//#define USE_TEST_DATA

struct SnL1SingleFreqSupp {
    
    template<typename Num_t>
    static
    EL1TrigStatus ProcessEvent(const SnEventFrame& gEvent,
                               Num_t(& gChanFFT)[kNsamps],
                               const float maxRatio) {
#ifdef USE_TEST_DATA
        // 17750 - should fail
        static const uint16_t kTestData[kNchans][kNsamps] = {
            {1614, 1644, 1671, 1658, 1634, 1649, 1635, 1612, 1617, 1651, 1651, 1588, 1644, 1628, 1609, 1649, 1652, 1639, 1688, 1628, 1592, 1585, 1581, 1636, 1685, 1669, 1682, 1712, 1645, 1646, 1602, 1514, 1550, 1608, 1660, 1774, 1753, 1687, 1631, 1565, 1521, 1556, 1599, 1632, 1680, 1695, 1731, 1735, 1700, 1669, 1617, 1541, 1527, 1516, 1548, 1519, 1571, 1592, 1658, 1696, 1733, 1764, 1784, 1790, 1761, 1762, 1722, 1628, 1629, 1514, 1418, 1388, 1406, 1437, 1411, 1484, 1593, 1713, 1798, 1860, 1888, 1917, 1894, 1845, 1820, 1738, 1673, 1590, 1490, 1380, 1396, 1292, 1281, 1327, 1372, 1593, 1757, 1867, 1909, 1865, 1851, 1875, 1899, 1864, 1832, 1820, 1709, 1525, 1445, 1324, 1290, 1281, 1288, 1406, 1512, 1618, 1675, 1749, 1813, 1889, 1965, 1966, 1925, 1865, 1779, 1648, 1610, 1518, 1457, 1376, 1345, 1278, 1323, 1419, 1524, 1546, 1689, 1876, 1947, 1969, 1975, 1904, 1797, 1680, 1650, 1560, 1562, 1565, 1528, 1463, 1462, 1491, 1501, 1589, 1662, 1677, 1641, 1668, 1639, 1583, 1611, 1622, 1670, 1764, 1827, 1915, 1887, 1814, 1711, 1571, 1562, 1439, 1401, 1413, 1428, 1401, 1467, 1592, 1624, 1654, 1702, 1778, 1828, 1637, 1622, 1619, 1590, 1618, 1649, 1657, 1646, 1596, 1629, 1674, 1698, 1622, 1614, 1620, 1650, 1635, 1646, 1689, 1673, 1579, 1613, 1615, 1611, 1615, 1645, 1632, 1595, 1605, 1623, 1699, 1722, 1673, 1659, 1624, 1643, 1653, 1634, 1606, 1605, 1613, 1623, 1608, 1612, 1615, 1663, 1709, 1725, 1646, 1622, 1617, 1600, 1603, 1627, 1637, 1655, 1650, 1649, 1656, 1680, 1638, 1603, 1598, 1632, 1581, 1626, 1679, 1632, 1581, 1608, 1663, 1670, 1656},
            {1617,1651,1613,1626,1642,1651,1623,1599,1622,1643,1630,1637,1651,1623,1534,1557,1560,1592,1599,1675,1696,1678,1641,1658,1668,1583,1605,1614,1600,1665,1686,1611,1603,1613,1630,1607,1524,1568,1587,1604,1608,1662,1711,1672,1683,1651,1617,1577,1653,1716,1716,1686,1667,1558,1521,1497,1486,1454,1510,1645,1703,1758,1786,1750,1742,1704,1657,1578,1558,1494,1491,1518,1550,1592,1633,1694,1689,1697,1760,1767,1718,1651,1610,1561,1538,1517,1543,1535,1515,1547,1614,1707,1777,1778,1760,1733,1696,1608,1569,1509,1482,1523,1562,1580,1571,1621,1676,1751,1811,1788,1695,1695,1644,1617,1556,1502,1480,1437,1415,1507,1550,1636,1686,1673,1736,1788,1787,1712,1781,1798,1708,1647,1565,1546,1526,1535,1542,1413,1469,1494,1581,1699,1698,1690,1652,1654,1716,1686,1637,1712,1724,1726,1728,1655,1621,1574,1576,1510,1474,1445,1484,1595,1557,1615,1651,1701,1667,1723,1724,1697,1720,1655,1634,1646,1571,1584,1540,1482,1540,1623,1640,1618,1618,1609,1611,1687,1624,1600,1654,1688,1633,1634,1646,1654,1654,1594,1610,1659,1594,1591,1601,1597,1644,1576,1580,1640,1660,1669,1658,1640,1624,1600,1630,1641,1640,1625,1607,1608,1612,1594,1616,1659,1662,1586,1557,1584,1627,1665,1595,1648,1657,1616,1616,1595,1601,1635,1627,1673,1639,1635,1649,1604,1579,1598,1630,1616,1591,1627,1646,1625,1649,1644,1626,1597,1567,1621},
            {1580,1631,1595,1572,1625,1648,1682,1685,1662,1659,1623,1576,1548,1524,1577,1602,1641,1727,1726,1713,1689,1629,1632,1701,1649,1614,1602,1559,1471,1463,1543,1614,1644,1654,1663,1714,1738,1736,1743,1734,1726,1701,1651,1564,1517,1451,1467,1471,1522,1620,1635,1619,1586,1607,1687,1769,1786,1821,1832,1795,1737,1654,1608,1546,1469,1454,1488,1357,1339,1414,1489,1602,1714,1860,1929,2000,1977,1923,1777,1652,1524,1357,1322,1345,1378,1466,1530,1574,1636,1700,1821,1910,1909,1867,1785,1656,1603,1476,1475,1557,1530,1510,1565,1605,1642,1651,1674,1706,1677,1648,1709,1642,1658,1616,1644,1676,1593,1570,1587,1576,1610,1589,1577,1623,1653,1639,1661,1704,1695,1671,1699,1718,1743,1704,1625,1559,1457,1414,1449,1450,1504,1558,1615,1701,1754,1844,1853,1803,1733,1700,1678,1681,1639,1525,1492,1487,1481,1493,1515,1564,1627,1639,1675,1721,1729,1744,1716,1706,1708,1700,1667,1649,1622,1624,1625,1492,1462,1508,1569,1567,1601,1656,1607,1611,1627,1647,1584,1661,1675,1634,1611,1611,1610,1620,1613,1631,1632,1663,1648,1592,1636,1603,1661,1684,1651,1649,1591,1585,1654,1662,1642,1657,1598,1576,1583,1586,1653,1651,1670,1652,1618,1638,1639,1661,1626,1619,1624,1635,1629,1622,1625,1627,1642,1682,1667,1639,1617,1570,1571,1631,1620,1633,1701,1686,1638,1618,1614,1641,1593,1569,1637,1665,1645,1606,1684,1683},
            {1686,1599,1618,1595,1598,1636,1640,1657,1670,1653,1612,1608,1608,1663,1685,1657,1581,1533,1547,1580,1622,1664,1693,1702,1688,1669,1646,1607,1601,1608,1640,1659,1615,1592,1580,1528,1543,1595,1618,1672,1747,1677,1627,1640,1641,1679,1754,1711,1655,1591,1571,1527,1530,1578,1516,1474,1527,1628,1650,1737,1729,1782,1799,1785,1734,1675,1670,1611,1595,1532,1482,1450,1461,1479,1518,1643,1660,1664,1682,1692,1740,1823,1788,1787,1739,1707,1660,1551,1502,1467,1441,1452,1487,1540,1599,1644,1638,1700,1714,1767,1802,1815,1789,1743,1678,1580,1491,1427,1433,1475,1507,1567,1571,1601,1666,1746,1800,1803,1778,1767,1727,1556,1541,1496,1484,1520,1539,1590,1563,1615,1638,1675,1712,1654,1721,1730,1685,1708,1700,1647,1650,1558,1523,1519,1559,1618,1647,1635,1615,1614,1646,1691,1649,1660,1668,1611,1601,1580,1594,1628,1658,1614,1677,1700,1705,1688,1627,1560,1560,1622,1609,1617,1618,1550,1582,1569,1616,1704,1691,1643,1670,1674,1623,1625,1625,1663,1615,1607,1609,1634,1652,1643,1595,1635,1668,1662,1607,1605,1622,1616,1610,1637,1645,1643,1602,1594,1603,1659,1681,1644,1634,1682,1640,1593,1626,1598,1597,1662,1655,1620,1596,1613,1648,1623,1667,1631,1647,1634,1649,1642,1641,1639,1599,1605,1649,1604,1632,1614,1585,1646,1651,1605,1642,1659,1674,1666,1653,1647,1700,1623,1580,1569,1545,1606,1638,1685}
        };
        /*
        // 25803 - should pass
        static const uint16_t kTestData[kNchans][kNsamps] = {
            {1590, 1634, 1648, 1645, 1627, 1663, 1633, 1621, 1657, 1654, 1640, 1621, 1621, 1579, 1632, 1617, 1647, 1655, 1629, 1640, 1650, 1662, 1688, 1612, 1618, 1615, 1632, 1668, 1590, 1591, 1676, 1671, 1624, 1676, 1656, 1605, 1606, 1650, 1628, 1685, 1655, 1593, 1602, 1637, 1681, 1623, 1599, 1659, 1608, 1602, 1647, 1655, 1672, 1606, 1644, 1629, 1638, 1648, 1659, 1641, 1676, 1633, 1580, 1572, 1674, 1677, 1605, 1573, 1596, 1605, 1620, 1716, 1707, 1654, 1618, 1665, 1727, 1667, 1631, 1575, 1487, 1541, 1614, 1696, 1750, 1718, 1674, 1594, 1613, 1616, 1633, 1595, 1576, 1629, 1625, 1663, 1731, 1658, 1632, 1630, 1642, 1631, 1669, 1640, 1617, 1644, 1624, 1613, 1610, 1575, 1600, 1660, 1667, 1666, 1706, 1654, 1622, 1654, 1603, 1566, 1626, 1643, 1655, 1675, 1690, 1603, 1604, 1650, 1648, 1607, 1607, 1602, 1604, 1664, 1709, 1639, 1620, 1628, 1684, 1683, 1619, 1597, 1607, 1633, 1659, 1622, 1577, 1630, 1679, 1666, 1650, 1635, 1673, 1671, 1637, 1648, 1614, 1551, 1575, 1642, 1669, 1638, 1649, 1684, 1692, 1656, 1698, 1636, 1586, 1626, 1609, 1576, 1599, 1627, 1658, 1629, 1668, 1667, 1608, 1609, 1648, 1624, 1625, 1661, 1659, 1653, 1607, 1610, 1640, 1655, 1669, 1593, 1642, 1661, 1658, 1660, 1624, 1578, 1617, 1624, 1623, 1626, 1652, 1666, 1695, 1678, 1632, 1569, 1606, 1603, 1619, 1631, 1671, 1701, 1681, 1590, 1567, 1642, 1676, 1661, 1623, 1622, 1639, 1697, 1643, 1622, 1634, 1606, 1626, 1656, 1680, 1655, 1657, 1611, 1600, 1605, 1618, 1654, 1661, 1667, 1665, 1654, 1666, 1652, 1646, 1585, 1578, 1550, 1570, 1666, 1683, 1638, 1655, 1642, 1671, 1663},
            {1576, 1644, 1660, 1607, 1620, 1666, 1612, 1563, 1617, 1617, 1615, 1646, 1602, 1660, 1623, 1619, 1603, 1646, 1630, 1607, 1615, 1658, 1646, 1595, 1589, 1632, 1656, 1611, 1599, 1594, 1610, 1628, 1616, 1650, 1669, 1647, 1647, 1634, 1626, 1636, 1617, 1599, 1564, 1572, 1628, 1703, 1720, 1635, 1606, 1561, 1600, 1637, 1642, 1667, 1661, 1611, 1619, 1581, 1586, 1601, 1630, 1615, 1636, 1680, 1721, 1697, 1620, 1542, 1516, 1542, 1622, 1679, 1693, 1658, 1659, 1592, 1568, 1613, 1646, 1627, 1637, 1650, 1600, 1638, 1691, 1616, 1613, 1598, 1583, 1611, 1649, 1640, 1661, 1682, 1669, 1604, 1594, 1595, 1569, 1632, 1669, 1653, 1666, 1666, 1652, 1621, 1590, 1541, 1577, 1654, 1608, 1598, 1625, 1609, 1615, 1695, 1659, 1644, 1589, 1606, 1649, 1673, 1656, 1592, 1601, 1632, 1641, 1596, 1664, 1629, 1616, 1602, 1567, 1635, 1625, 1697, 1702, 1548, 1589, 1649, 1608, 1626, 1648, 1615, 1624, 1694, 1680, 1594, 1541, 1570, 1606, 1626, 1649, 1617, 1648, 1608, 1646, 1667, 1600, 1584, 1552, 1596, 1647, 1637, 1614, 1667, 1646, 1695, 1658, 1555, 1564, 1575, 1621, 1654, 1621, 1645, 1649, 1615, 1607, 1592, 1608, 1673, 1652, 1594, 1636, 1608, 1593, 1625, 1597, 1628, 1641, 1659, 1620, 1589, 1624, 1654, 1658, 1666, 1611, 1601, 1632, 1602, 1613, 1632, 1632, 1576, 1593, 1653, 1662, 1678, 1638, 1639, 1654, 1553, 1576, 1602, 1631, 1645, 1607, 1642, 1613, 1610, 1600, 1637, 1624, 1620, 1599, 1620, 1588, 1658, 1673, 1608, 1624, 1640, 1601, 1655, 1653, 1590, 1577, 1595, 1606, 1658, 1642, 1610, 1600, 1656, 1686, 1661, 1598, 1560, 1580, 1623, 1615, 1659, 1649, 1612},
            {1658, 1591, 1579, 1589, 1637, 1687, 1662, 1642, 1638, 1572, 1613, 1640, 1631, 1633, 1623, 1634, 1651, 1621, 1624, 1626, 1619, 1636, 1665, 1679, 1606, 1561, 1602, 1683, 1662, 1624, 1602, 1596, 1650, 1645, 1633, 1683, 1632, 1583, 1592, 1630, 1669, 1620, 1610, 1648, 1630, 1668, 1681, 1600, 1600, 1642, 1657, 1625, 1552, 1599, 1650, 1690, 1686, 1581, 1583, 1622, 1634, 1701, 1697, 1647, 1602, 1569, 1614, 1626, 1598, 1594, 1638, 1619, 1622, 1682, 1677, 1640, 1618, 1648, 1622, 1636, 1631, 1642, 1645, 1645, 1631, 1610, 1617, 1624, 1630, 1606, 1630, 1635, 1658, 1672, 1664, 1604, 1580, 1608, 1626, 1653, 1637, 1625, 1636, 1596, 1607, 1643, 1677, 1640, 1604, 1621, 1659, 1608, 1672, 1666, 1615, 1591, 1665, 1649, 1608, 1637, 1663, 1682, 1675, 1612, 1600, 1627, 1613, 1594, 1617, 1604, 1641, 1647, 1644, 1653, 1589, 1647, 1702, 1627, 1599, 1616, 1613, 1633, 1612, 1614, 1618, 1623, 1633, 1622, 1600, 1679, 1660, 1646, 1661, 1600, 1595, 1658, 1630, 1603, 1662, 1638, 1617, 1608, 1612, 1637, 1640, 1628, 1677, 1678, 1659, 1636, 1587, 1593, 1618, 1629, 1662, 1671, 1636, 1625, 1596, 1585, 1631, 1623, 1607, 1599, 1621, 1647, 1644, 1658, 1646, 1632, 1620, 1635, 1635, 1665, 1636, 1627, 1598, 1597, 1615, 1624, 1639, 1581, 1648, 1663, 1669, 1633, 1612, 1675, 1670, 1631, 1620, 1590, 1564, 1608, 1665, 1661, 1639, 1588, 1634, 1653, 1565, 1632, 1609, 1667, 1628, 1609, 1613, 1696, 1653, 1631, 1651, 1645, 1646, 1637, 1607, 1623, 1630, 1603, 1622, 1618, 1617, 1658, 1661, 1644, 1646, 1638, 1634, 1610, 1576, 1589, 1657, 1646, 1637, 1639, 1635, 1674},
            {1627, 1658, 1617, 1594, 1638, 1644, 1640, 1615, 1590, 1638, 1686, 1626, 1622, 1644, 1561, 1636, 1650, 1632, 1679, 1627, 1622, 1589, 1591, 1652, 1662, 1652, 1592, 1615, 1637, 1625, 1647, 1652, 1640, 1605, 1618, 1641, 1601, 1614, 1651, 1615, 1653, 1607, 1590, 1669, 1665, 1657, 1660, 1576, 1570, 1608, 1664, 1627, 1607, 1640, 1640, 1668, 1659, 1670, 1616, 1642, 1594, 1600, 1651, 1607, 1562, 1615, 1647, 1681, 1701, 1660, 1610, 1587, 1628, 1622, 1599, 1648, 1676, 1640, 1614, 1638, 1623, 1671, 1622, 1577, 1594, 1644, 1665, 1618, 1592, 1657, 1652, 1603, 1641, 1629, 1625, 1657, 1642, 1635, 1635, 1632, 1667, 1645, 1584, 1592, 1626, 1624, 1630, 1643, 1603, 1624, 1643, 1663, 1648, 1605, 1615, 1574, 1609, 1613, 1584, 1616, 1670, 1634, 1651, 1690, 1671, 1644, 1606, 1612, 1609, 1629, 1594, 1632, 1676, 1594, 1612, 1604, 1626, 1660, 1677, 1643, 1645, 1650, 1600, 1599, 1629, 1621, 1629, 1642, 1667, 1647, 1615, 1622, 1609, 1595, 1624, 1650, 1615, 1593, 1624, 1663, 1692, 1620, 1670, 1603, 1595, 1673, 1668, 1637, 1631, 1588, 1576, 1593, 1618, 1638, 1644, 1605, 1629, 1648, 1647, 1660, 1646, 1598, 1631, 1623, 1627, 1642, 1635, 1620, 1625, 1627, 1672, 1661, 1591, 1607, 1628, 1625, 1614, 1589, 1588, 1660, 1641, 1638, 1679, 1631, 1583, 1628, 1642, 1692, 1672, 1636, 1588, 1555, 1628, 1694, 1625, 1612, 1594, 1615, 1673, 1621, 1570, 1612, 1628, 1644, 1638, 1631, 1640, 1637, 1666, 1645, 1631, 1630, 1593, 1561, 1646, 1657, 1625, 1614, 1587, 1616, 1677, 1656, 1656, 1671, 1644, 1640, 1646, 1617, 1639, 1629, 1607, 1599, 1626, 1627, 1639, 1629}
        };
        */
#endif

        for (uint8_t ch=0; ch<kNchans; ++ch) {
            // put the data into the fft buffer
            SnSigProcUtils::MemCpyOrLoopCpy(gChanFFT, gEvent.GetData(ch), kNsamps);
#ifdef USE_TEST_DATA
            SnSigProcUtils::MemCpyOrLoopCpy(gChanFFT, kTestData[ch], kNsamps);
#endif
#ifdef DEBUG_
            printf("CHAN %hhu. data:\r\n", ch);
            for (uint32_t i=0; i<kNsamps; ++i) {
                printf("%g, ", gChanFFT[i]);
            }
            printf("\r\n");
#endif
            // take the real FFT
            const bool fok = SnSigProcUtils::RealFFT<kNsamps>(gChanFFT, false);
#ifdef DEBUG_
            printf("fft:\r\n");
            for (uint32_t i=0; i<kNsamps; ++i) {
                printf("%g, ", gChanFFT[i]);
            }
            printf("\r\n");    
#endif
            if (fok) {
                // get the spectrum
                const uint32_t nfreqs =
                    SnSigProcUtils::ReplaceRfftWithSpectrum(gChanFFT, kNsamps, 
                                                            false);
#ifdef DEBUG_
                printf("nfreqs=%u\r\n", nfreqs);
                for (uint32_t i=0; i<nfreqs; ++i) {
                    printf("%g, ", (float)gChanFFT[i]);
                }
#endif
                double sum(0), max(0);
                // skip the lowest freq bin
                SnSigProcUtils::GetArraySumAndMaxSingleLoop(gChanFFT+1, nfreqs-1,
                                                            sum, max);
#ifdef DEBUG
                printf("<SnL1SingleFreqSupp::ProcessEvent>: "
                       "L1=%g, maxRatio=%g, sum=%g, max=%g\r\n",
                        (1.0f / ( (sum/max) - 1.0f )), maxRatio, sum, max);
#endif
                if (max>1e-5) { // bigger than 0 for a float
                    if ( (1.0f / ( (sum/max) - 1.0f )) > maxRatio ) {
#ifdef DEBUG
                        printf("L1 fail\r\n");
#endif
                        return kL1Fail;
                    }
                } else {
#ifdef DEBUG
                    printf("max too close to 0\r\n");
                    printf("L1 unable to process\r\n");
#endif
                    return kL1UnableToProcess;
                }
            } else {
#ifdef DEBUG
                printf("RealFFT failed\r\n");
                printf("L1 unable to process\r\n");
#endif
                return kL1UnableToProcess;
            }
        }
#ifdef DEBUG
        printf("L1 pass\r\n");
#endif
        return kL1Pass;
    }
    
};

#endif // SN_SnL1SingleFreqSupp
