#include "SnCommWinUsb.h"

#include "SnCommUsb.h"

#ifdef USE_MODSERIAL
#include "MODSERIAL.h"
#endif

SnCommWinUsb::SnCommWinUsb(COMM_SERIALTYPE* cpu) :
    SnCommWin(new SnCommUsb(cpu)) {

}

SnCommWin::ECommWinResult SnCommWinUsb::OpenWindow(const bool sendStatus,
                                                   const SnConfigFrame& conf,
                                                   const SnPowerFrame& pow, // com win power
                                                   const SnEventFrame& stEvent,
                                                   const uint16_t seq,
                                                   const uint32_t numThmTrigs,
                                                   const uint32_t numSavedEvts, 
                                                   const float    seqlive,
                                                   const uint32_t powerOnTime,
                                                   const SnTempFrame& temper, // com win temp
                                                   char* const genBuf,
                                                   const uint32_t timeout_clock) {
#ifdef DEBUG
    printf("SnCommWinUsb::OpenWindow\r\n");
#endif

    SnCommWin::ECommWinResult ret = 
        fComm->Connect(timeout_clock) ? SnCommWin::kConnected : SnCommWin::kCanNotConnect;
    
    if (sendStatus) {
#ifdef DEBUG
        printf("SnCommWinUsb calling SendStatus\r\n");
#endif
     
        ret = SendStatus(conf, pow, stEvent, seq,
                         numThmTrigs, numSavedEvts, seqlive,
                         powerOnTime, temper,
                         genBuf,
                         timeout_clock);
    }
    
    return ret;
}
