#ifndef SNS_SnClockSetFrame
#define SNS_SnClockSetFrame

#include "mbed.h"
#include <stdint.h>

#include "SnCommWin.h"

class SnClockSetFrame {
 public:
    static const uint8_t    kIOVers;   // MUST BE INCREASED if any member var changes
    static const uint32_t   kMaxSizeOf  = sizeof(uint8_t) + (3u*sizeof(uint32_t))
                                          + sizeof(int32_t);


 private:
    uint32_t  fPrevTime;
    uint32_t  fSetTime;
    //Timer     fSinceSet;
    uint32_t  fCurTime;
    int32_t   fUsSinceSet; // Timer for some reason givse an int instead of an unsigned int
 
    //void ResetCCtimer() {  fSinceSet.reset(); fSinceSet.start(); }

 public:
    SnClockSetFrame() :
        fPrevTime(0), fSetTime(0),
        fCurTime(0), fUsSinceSet(0) {}
    virtual ~SnClockSetFrame() {}
    
    uint32_t GetCurTime() const { return fCurTime; }
    
    void SetClocks(const uint32_t prev, const uint32_t stim,
                   const uint32_t ctime, const int32_t usss) {
        //ResetCCtimer();
        fPrevTime   = prev;
        fSetTime    = stim;
        fCurTime    = ctime;
        fUsSinceSet = usss;
    }
    
    void UpdateClock(Timer& usSince) {
        fCurTime    = time(0);
        fUsSinceSet = usSince.read_us();
    }
    
    /*
    int32_t GetUsSinceSet() {
        return static_cast<int32_t>(fUsSinceSet.read_us());
    }
    */
    static
    uint32_t SizeOf(const uint8_t rv=SnClockSetFrame::kIOVers)
       { return kMaxSizeOf; }
    
    template<class T>
    SnCommWin::ECommWinResult WriteTo(T& x) const {
        // expect 'x' to be a MODSERIAL or a char const* or a FILE*
        x = SnBitUtils::WriteTo(x, kIOVers);
        x = SnBitUtils::WriteTo(x, fPrevTime);
        x = SnBitUtils::WriteTo(x, fSetTime);
        x = SnBitUtils::WriteTo(x, fCurTime);
        x = SnBitUtils::WriteTo(x, fUsSinceSet);
        // read_us returns a signed int for some reason. so we keep that
        // convention and merely make the number of bits explicit via the
        // cast. changing to an unsigned int is left for later.
        return SnCommWin::kOkMsgSent;
    }
    
    
    template<class T>
    static
    SnCommWin::ECommWinResult ReadFrom(T& b,
                                       uint32_t& prev,
                                       uint32_t& stim,
                                       uint32_t& ctim,
                                       int32_t& ss) {
        uint8_t Rv=0;
        b           = SnBitUtils::ReadFrom(b, Rv);
        b           = SnBitUtils::ReadFrom(b, prev);
        b           = SnBitUtils::ReadFrom(b, stim);
        b           = SnBitUtils::ReadFrom(b, ctim);
        b           = SnBitUtils::ReadFrom(b, ss);
        return SnCommWin::kOkWithMsg;
    }

    template<class T>
    SnCommWin::ECommWinResult ReadFrom(T& b) {
        return ReadFrom(b, fPrevTime, fSetTime, fCurTime, fUsSinceSet);
    }
    
};

#endif // SNS_SnClockSetFrame
