/*
#include "SnCommAfar.h"

#include "Websocket.h"
#include "SnConfigFrame.h"
#include "SnEventFrame.h"
#include "SnStatusFrame.h"
#include "SnHeaderFrame.h"
#include "SnSDUtils.h"

Websocket& SnCommAfar::GetWS() {
    // only one make one socket
    //static Websocket* ws = new Websocket("ws://snowflake.ps.uci.edu:6767/ws");
    // TODO: fix DNS
    // TODO: remove hardcoded IP addresses from Websocket.cpp
    static Websocket* ws = new Websocket("ws://128.195.204.151:6776/ws");
    return *ws;
}

bool SnCommAfar::Connect(const uint32_t timeout) {
    bool isConn = GetWS().connected();
    printf("connect: ct=%d, timeout=%u\r\n",time(0),timeout);
    while ( (isConn==false) && ( time(0) < timeout) ) {
        wait_ms(250);
#ifdef DEBUG
        printf("connecting..\r\n");
        DigitalOut led3(LED3);
        led3=1; wait(0.2);
#endif
        isConn = GetWS().connect(timeout);
#ifdef DEBUG
        printf("isConn=%d\r\n",(int)isConn);
        led3=0; wait(0.2);
#endif
    }
    return isConn;
}

SnCommWin::ECommWinResult SnCommAfar::OpenWindow(const uint32_t timeout,
                                                 const bool sendStatus,
                                                 const SnConfigFrame& conf,
                                                 const SnEventFrame& evt,
                                                 char* const genBuf) {
    
    const bool canCon = Connect(timeout);
    
    SnCommWin::ECommWinResult ret = canCon ? SnCommWin::kConnected
                                           : SnCommWin::kCanNotConnect;
    
    if (canCon && sendStatus) {
        ret = SendStatus(conf, evt, genBuf);
    }
    
    return ret;
}

SnCommWin::ECommWinResult SnCommAfar::WaitHandshake(const uint32_t timeout,
                                                    char* const buf,
                                                    const uint32_t bsize) {
    printf("WaitHandshake, to=%u\r\n",timeout);
    
    uint32_t mlen=0; // this message length
    const bool rd = GetWS().read(buf, mlen, bsize, timeout, fB64buf, fbblen);
    if (rd) {
        uint32_t msgLen=0;
        uint8_t  msgCode=0;
        const char* b = buf;
        SnHeaderFrame::ReadFrom(b, msgCode, msgLen);
        if (msgCode==SnHeaderFrame::kHandshakeCode) {
            return SnCommWin::kOkWithMsg;
        } else {
            // TODO: somehow handle unexpected message?
            return SnCommWin::kUnexpectedRec;
        }
    }
    return SnCommWin::kOkNoMsg;
}

SnCommWin::ECommWinResult SnCommAfar::GetConfig(SnConfigFrame& conf,
                                                const uint32_t timeOut,
                                                char* const confBuf,
                                                const uint32_t bsize) {
    // confBuf assumed to alread be of allocated size
    
    printf("GetConfig, to=%u\r\n",timeOut);
    
    SnCommWin::ECommWinResult res = SnCommWin::kUndefFail;
    
    bool redConf = false; 
    bool readHeader = true;
    uint8_t mcode=0x0;
    uint32_t mlen=0; // length of message specified in header
    uint32_t mread=0; // length of messages received so far
    const char* b = confBuf;
    while ( (redConf==false) && (time(0) < timeOut) ) {
        uint32_t msglen=0; // this message length
        redConf = GetWS().read(confBuf+mread, msglen, bsize, timeOut, fB64buf, fbblen);
        mread += msglen;
        if (redConf) {
            if (readHeader && mread>=SnHeaderFrame::SizeOf()) {
                printf("read head from %x\r\n",b);
                SnHeaderFrame::ReadFrom(b, mcode, mlen);
                // TODO: check that mcode is kConfigCode? What to do if not?
                printf("mcode=%02x, mlen=%u\r\n", mcode, mlen);
                readHeader=false;
            }
            printf("mread=%u, mlen=%u\r\n", mread, mlen);
            if (readHeader==false &&
                 ((mread-SnHeaderFrame::SizeOf())>=mlen)) {
                printf("read config from %x\r\n",b);
                conf.ReadFrom(b);
                printf("after read conf, b=%x (%d)\r\n",
                    b, int(b-confBuf));
                res = SnCommWin::kOkWithMsg;
            } else {
                redConf=false;
            }
        }
    }
    if (redConf==false) {
        res = SnCommWin::kOkNoMsg;
    }

    return res;
}

SnCommWin::ECommWinResult SnCommAfar::SendStatus(const SnConfigFrame& conf,
                                                 const SnEventFrame& evt,
                                                 char* const genBuf) {
    // TODO: check if connected?
    const uint32_t ssize = SnStatusFrame::SizeOf(conf);
    char* b = genBuf;
    SnHeaderFrame::WriteTo(b, SnHeaderFrame::kStatusCode, ssize);
    SnStatusFrame::WriteTo(b, SnConfigFrame::kAfar, conf, evt, genBuf);
#ifdef DEBUG
    printf("status frame:\r\n");
    for (uint32_t i=0; i<msize; i++) {
        printf("%02X ",genBuf[i]);
    }
    printf("\r\n");
#endif
    const bool ok = GetWS().sendBinary(
        genBuf, b-genBuf, fB64buf);
    printf("status sent\r\n");
    return ok ? SnCommWin::kOkMsgSent : SnCommWin::kFailPartSent;
}

SnCommWin::ECommWinResult SnCommAfar::SendFilename(const char* fn, char* const genBuf) {
    printf("afar send filename %s\r\n",fn);
    const size_t flen = strlen(fn);
    char* b = genBuf;
    SnHeaderFrame::WriteTo(b, SnHeaderFrame::kFilenameCode, flen);
    sprintf(b, "%s", fn);
    const bool ok = GetWS().sendBinary(
        genBuf, SnHeaderFrame::SizeOf()+flen, fB64buf);
    return ok ? SnCommWin::kOkMsgSent : SnCommWin::kFailPartSent;
}

SnCommWin::ECommWinResult SnCommAfar::SendData(FILE* inf) {
    printf("afar send whole file\r\n");
    fseek(inf, 0, SEEK_END);
    const int32_t fsize = ftell(inf);
    fseek(inf, 0, SEEK_SET);
    if (fsize<0) {
        return SnCommWin::kFailNoneSent;
    } else {
        // send file data with header
        const bool ok = GetWS().sendBinary(
            SnHeaderFrame::GetHdBuf(SnHeaderFrame::kFileCode, fsize),
            SnHeaderFrame::SizeOf(),
            inf, fsize,
            fB64buf);
        return ok ? SnCommWin::kOkMsgSent : SnCommWin::kFailPartSent;
    }
}

SnCommWin::ECommWinResult SnCommAfar::SendConfAndEvents(FILE* inf,
                                                    const SnConfigFrame& curConf,
                                                    SnEventFrame& evt,
                                                    char* const genBuf,
                                                    const uint32_t nevts,
                                                    const uint32_t firstEvt) {
    printf("afar send conf and events\r\n");
    // firstEvt==0 ==> start at beginning
    // nevts==0 ==> NO events! (see SnCommWin::SendData
    //    for the fcn to send the full file)
    
    const int fpos = ftell(inf);
    if (fpos>0) {
        fseek(inf, 0, SEEK_SET);
    }
    
    printf("fpos=%d\r\n",fpos);
    
    // TODO: check memory for temporary config/event frames?
    uint64_t macadr;
    uint32_t run;
    uint16_t seq, v1, v2;
    SnSDUtils::ReadFileHeader(inf, macadr, run, seq, v1, v2);
    SnConfigFrame conf;
    conf.ReadFrom(inf);
    
    uint8_t sLoseLSB=0, sLoseMSB=0;
    uint16_t sWvBase=0;
    curConf.GetPackParsFor(SnConfigFrame::kAfar, sLoseLSB, sLoseMSB, sWvBase);
    // do we have to unpack & repack events?
    const bool repack =    (sLoseLSB != conf.GetWvLoseLSB())
                        && (sLoseMSB != conf.GetWvLoseMSB())
                        && (sWvBase  != conf.GetWvBaseline());
    
    // size of event in file
    const uint32_t esize = SnEventFrame::SizeOf(conf.GetWvLoseLSB(),
                                                conf.GetWvLoseMSB());
    
    printf("repack=%d, esize=%u\r\n",(int)repack,esize);
    
    // send the header and conf
    char* b = genBuf;
    SnHeaderFrame::WriteTo(b, SnHeaderFrame::kConfAndEvtsCode, conf.SizeOf());
    conf.WriteTo(b);
    
    bool ok  = GetWS().sendBinary(
        genBuf, conf.SizeOf()+SnHeaderFrame::SizeOf(),
        fB64buf);
    
    printf("ok=%d, nevts=%u\r\n",(int)ok,nevts);
    
    // size of event sent over afar
    const uint32_t ssize = (repack) ?
        SnEventFrame::SizeOf(sLoseLSB, sLoseMSB) :
        esize;
    
    // move up to first event
    if (firstEvt>0) {
        printf("skip ahead %d\r\n",firstEvt*esize);
        fseek(inf, (firstEvt*esize), SEEK_CUR);
    }
    
    // get file size
    const int fcur = ftell(inf);
    fseek(inf, 0, SEEK_END);
    const int fend = ftell(inf);
    fseek(inf, fcur, SEEK_SET);
    
    for (uint32_t i=0; (i<nevts) && ok; i++) {
        if (feof(inf)==0 && ferror(inf)==0 && ((ftell(inf)+ssize)<=fend)) {
            printf("sending evt %u\r\n",i);
            if (repack) {
                evt.ReadFrom(inf, genBuf,
                    conf.GetWvLoseLSB(), conf.GetWvLoseMSB(),
                    conf.GetWvBaseline());
                // must be after evt.Read, since that uses the buffer
                b = genBuf;
                SnHeaderFrame::WriteTo(b, SnHeaderFrame::kEventCode, ssize);
                evt.WriteTo(b, sLoseLSB, sLoseMSB, sWvBase);
                ok &= GetWS().sendBinary(
                    genBuf, ssize+SnHeaderFrame::SizeOf(),
                    fB64buf);
            } else {
                ok &= GetWS().sendBinary(
                    SnHeaderFrame::GetHdBuf(SnHeaderFrame::kEventCode,
                                            ssize),
                    SnHeaderFrame::SizeOf(),
                    inf, ssize,
                    fB64buf);
            }
        } else {
            printf("cannot send requested event\r\n");
            ok=false;
        }
    }
    
    fseek(inf, fpos, SEEK_SET);
    
    return ok ? SnCommWin::kOkMsgSent : SnCommWin::kFailPartSent;
}
*/