#ifndef SN_SnUIDtoMac
#define SN_SnUIDtoMac

#include <stdint.h>

#include "SnPreCompOptions.h"
#include "SnLPC1768UID.h"

class SnUIDtoMac {
 public:
    
    static const uint8_t kNumMacBytes = 6; // 48 bit MAC addresses
    
    static
    void GetMacAddress( char mac[kNumMacBytes] );

    static
    bool GetMacFromUIDtable(const uint32_t uid[SnLPC1768UID::kUIDlen],
                            char mac[kNumMacBytes] );

    static
    void GetMacFromCRCofUID(const uint32_t uid[SnLPC1768UID::kUIDlen],
                            char mac[kNumMacBytes] );

};

#endif // SN_SnUIDtoMac
