#include "SnCommWinSBD.h"

#include "SnCommSBD.h"

SnCommWinSBD::SnCommWinSBD(COMM_SERIALTYPE* sbd) :
    SnCommWin(new SnCommSBD(sbd)) {
    
}

SnCommWin::ECommWinResult SnCommWinSBD::OpenWindow(const bool sendStatus,
                                                   const SnConfigFrame& conf,
                                                   const SnPowerFrame& pow, // com win power
                                                   const SnEventFrame& stEvent,
                                                   const uint16_t seq,
                                                   const uint32_t numThmTrigs,
                                                   const uint32_t numSavedEvts, 
                                                   const float    seqlive,
                                                   const uint32_t powerOnTime,
                                                   const SnTempFrame& temper, // com win temp
                                                   char* const genBuf,
                                                   const uint32_t timeout_clock) {

#ifdef DEBUG
    printf("SnCommWinSBD::OpenWindow\r\n");
#endif

    const bool canCon = fComm->Connect(timeout_clock);
    
#ifdef DEBUG
    printf("canCon=%d\r\n",(int)canCon);
#endif

    SnCommWin::ECommWinResult ret = canCon ? SnCommWin::kConnected
                                           : SnCommWin::kCanNotConnect;
    
    if (canCon && sendStatus) {
        ret = SendStatus(conf, pow, stEvent, seq,
                         numThmTrigs, numSavedEvts, seqlive,
                         powerOnTime, temper,
                         genBuf, timeout_clock);

    }

#ifdef DEBUG
    printf("SBD OpenWindow returning %d\r\n",(int)ret);
#endif
    
    return ret;

}

