#ifndef SN_SnTempFrame
#define SN_SnTempFrame

#include <stdint.h>

#include "SnCommWin.h"


class SnTempFrame {
 public:
    // i/o version
    static const uint8_t    kIOvers;   // MUST BE INCREASED if any member var changes
    static const uint32_t   kMaxSizeOfV1 = sizeof(float) + sizeof(uint32_t); // DO NOT USE! forgot the byte for i/o version
    static const uint32_t   kMaxSizeOfV2 = kMaxSizeOfV1 + sizeof(uint8_t); // add i/o version
    static const uint32_t   kMaxSizeOf   = kMaxSizeOfV2;

 private:
    float          fTemp; // the temperature
    uint32_t       fTime; // time of temp check
    
 public:
    SnTempFrame(const float tmp=0, const uint32_t tim=0) :
        fTemp(tmp), fTime(tim) {
    }
    virtual ~SnTempFrame() {}
    
    static
    uint32_t SizeOf(const uint8_t rv=SnTempFrame::kIOvers) { 
        if (rv==1) {
            return kMaxSizeOfV1;
        } else if (rv==2) {
            return kMaxSizeOfV2;
        } else {
            return kMaxSizeOf;
        }
    }

    float       GetTemperature() const { return fTemp; }
    uint32_t    GetTime() const { return fTime; }
    
    void        SetTempOnly(const float tmp) { fTemp = tmp; }
    void        SetTime(const uint32_t t) { fTime = t; }

    void        SetTempAndTime(const float tmp, const uint32_t tim) {
        fTemp = tmp;
        fTime = tim;
    }
    
    template<class T>
    SnCommWin::ECommWinResult WriteTo(T& x) const {
        x = SnBitUtils::WriteTo(x, kIOvers);
        x = SnBitUtils::WriteTo(x, fTemp);
        x = SnBitUtils::WriteTo(x, fTime);
        return SnCommWin::kOkWithMsg;
    }

    template<class T>
    SnCommWin::ECommWinResult ReadFrom(T& b) {
        uint8_t Rv=0;
        b       = SnBitUtils::ReadFrom(b, Rv);
        b       = SnBitUtils::ReadFrom(b, fTemp);
        b       = SnBitUtils::ReadFrom(b, fTime);
        return SnCommWin::kOkWithMsg;
    }

};

#endif // SN_SnTempFrame
