#ifndef SNS_SnSignalStrengthFrame
#define SNS_SnSignalStrengthFrame

#include "mbed.h"
#include <stdint.h>

#include "SnCommWin.h"

class SnSignalStrengthFrame {
 public:
    static const uint8_t    kIOVers;   // MUST BE INCREASED if any member var changes
    static const uint32_t   kMaxSizeOf  = 2u*sizeof(uint8_t) + sizeof(float) + sizeof(uint32_t);


 private:
    uint8_t   fCommType;
    float     fSigStr;
    uint32_t  fSSTime;
 
 public:
    SnSignalStrengthFrame() :
        fCommType(0), fSigStr(0), fSSTime(0) {}
    virtual ~SnSignalStrengthFrame() {}
    
    void SetSigStr(const float ss, const uint32_t stim) {
        fSigStr = ss;
        fSSTime = stim;
    }
    
    void SetCommType(const uint8_t t) { fCommType = t; }
    
    static
    uint32_t SizeOf(const uint8_t rv=SnSignalStrengthFrame::kIOVers)
       { return kMaxSizeOf; }
    
    template<class T>
    SnCommWin::ECommWinResult WriteTo(T& x) {
        // expect 'x' to be a MODSERIAL or a char const* or a FILE*
        x = SnBitUtils::WriteTo(x, kIOVers);
        x = SnBitUtils::WriteTo(x, fCommType);
        x = SnBitUtils::WriteTo(x, fSigStr);
        x = SnBitUtils::WriteTo(x, fSSTime);
        return SnCommWin::kOkMsgSent;
    }
    
    template<class T>
    static
    SnCommWin::ECommWinResult ReadFrom(T& b,
                                       uint8_t& commtype,
                                       float& sigstr,
                                       uint32_t& stim) {
        uint8_t Rv=0;
        b           = SnBitUtils::ReadFrom(b, Rv);
        b           = SnBitUtils::ReadFrom(b, commtype);
        b           = SnBitUtils::ReadFrom(b, sigstr);
        b           = SnBitUtils::ReadFrom(b, stim);
        return SnCommWin::kOkWithMsg;
    }
    
    
};

#endif // SNS_SnSignalStrengthFrame
