#include "SnSigProcDataTable.h"

// save RAM by not implementing data tables that won't be used
// (altho I guess they will be optimized away in any case)
#if (CHIPBOARD==SST4CH) || (CHIPBOARD==SST4CH_1GHz) || (CHIPBOARD==SST8CH) || (CHIPBOARD==SST8CH_1GHz)
// hard code the number here because these tables are only valid for this value.
// use kNsamps when instantiating it, though, so a compiler error will happen
// if there's no data table for that number of samples.

// these are the pairs: (j, m) at each step of the loop over odd
// values of i in DiscreteCpxFFT
const SnSigProcDataTable<256>::DfftDivideIndicies_t SnSigProcDataTable<256>::kDfftDivideIndicies[256] = {
    129, 128, 65, 64, 193, 128, 33, 32, 161, 128, 97, 64, 225, 128, 17, 16, 145, 128, 81, 64, 209, 128, 49, 32, 177, 128, 113, 64, 241, 128, 9, 8, 137, 128, 73, 64, 201, 128, 41, 32, 169, 128, 105, 64, 233, 128, 25, 16, 153, 128, 89, 64, 217, 128, 57, 32, 185, 128, 121, 64, 249, 128, 5, 4, 133, 128, 69, 64, 197, 128, 37, 32, 165, 128, 101, 64, 229, 128, 21, 16, 149, 128, 85, 64, 213, 128, 53, 32, 181, 128, 117, 64, 245, 128, 13, 8, 141, 128, 77, 64, 205, 128, 45, 32, 173, 128, 109, 64, 237, 128, 29, 16, 157, 128, 93, 64, 221, 128, 61, 32, 189, 128, 125, 64, 253, 128, 3, 2, 131, 128, 67, 64, 195, 128, 35, 32, 163, 128, 99, 64, 227, 128, 19, 16, 147, 128, 83, 64, 211, 128, 51, 32, 179, 128, 115, 64, 243, 128, 11, 8, 139, 128, 75, 64, 203, 128, 43, 32, 171, 128, 107, 64, 235, 128, 27, 16, 155, 128, 91, 64, 219, 128, 59, 32, 187, 128, 123, 64, 251, 128, 7, 4, 135, 128, 71, 64, 199, 128, 39, 32, 167, 128, 103, 64, 231, 128, 23, 16, 151, 128, 87, 64, 215, 128, 55, 32, 183, 128, 119, 64, 247, 128, 15, 8, 143, 128, 79, 64, 207, 128, 47, 32, 175, 128, 111, 64, 239, 128, 31, 16, 159, 128, 95, 64, 223, 128, 63, 32, 191, 128, 127, 64, 255, 128, 2, 1
};

// these are the twidle factors: wr, wi used in DiscreteCpxFFT
const SnSigProcDataTable<256>::DfftTwidleFactor_t SnSigProcDataTable<256>::kDfftTwidleFactors[254] = {
    1.00000000000000e+00, 0.00000000000000e+00, 1.00000000000000e+00, 0.00000000000000e+00, 2.22044604925031e-16, 1.00000000000000e+00, 1.00000000000000e+00, 0.00000000000000e+00, 7.07106781186547e-01, 7.07106781186547e-01, 0.00000000000000e+00, 1.00000000000000e+00, -7.07106781186547e-01, 7.07106781186547e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.23879532511287e-01, 3.82683432365090e-01, 7.07106781186547e-01, 7.07106781186548e-01, 3.82683432365090e-01, 9.23879532511287e-01, -5.55111512312578e-17, 1.00000000000000e+00, -3.82683432365090e-01, 9.23879532511287e-01, -7.07106781186548e-01, 7.07106781186547e-01, -9.23879532511287e-01, 3.82683432365090e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.80785280403230e-01, 1.95090322016128e-01, 9.23879532511287e-01, 3.82683432365090e-01, 8.31469612302545e-01, 5.55570233019602e-01, 7.07106781186548e-01, 7.07106781186547e-01, 5.55570233019602e-01, 8.31469612302545e-01, 3.82683432365090e-01, 9.23879532511287e-01, 1.95090322016128e-01, 9.80785280403230e-01, 1.38777878078145e-16, 1.00000000000000e+00, -1.95090322016128e-01, 9.80785280403230e-01, -3.82683432365090e-01, 9.23879532511287e-01, -5.55570233019602e-01, 8.31469612302545e-01, -7.07106781186547e-01, 7.07106781186547e-01, -8.31469612302545e-01, 5.55570233019602e-01, -9.23879532511286e-01, 3.82683432365090e-01, -9.80785280403230e-01, 1.95090322016128e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.95184726672197e-01, 9.80171403295606e-02, 9.80785280403231e-01, 1.95090322016128e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.23879532511287e-01, 3.82683432365090e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.31469612302545e-01, 5.55570233019602e-01, 7.73010453362737e-01, 6.34393284163646e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.34393284163646e-01, 7.73010453362737e-01, 5.55570233019602e-01, 8.31469612302545e-01, 4.71396736825998e-01, 8.81921264348355e-01, 3.82683432365090e-01, 9.23879532511287e-01, 2.90284677254462e-01, 9.56940335732209e-01, 1.95090322016128e-01, 9.80785280403231e-01, 9.80171403295606e-02, 9.95184726672197e-01, 0.00000000000000e+00, 1.00000000000000e+00, -9.80171403295606e-02, 9.95184726672197e-01, -1.95090322016128e-01, 9.80785280403231e-01, -2.90284677254462e-01, 9.56940335732209e-01, -3.82683432365090e-01, 9.23879532511287e-01, -4.71396736825998e-01, 8.81921264348355e-01, -5.55570233019602e-01, 8.31469612302545e-01, -6.34393284163646e-01, 7.73010453362737e-01, -7.07106781186548e-01, 7.07106781186548e-01, -7.73010453362737e-01, 6.34393284163646e-01, -8.31469612302545e-01, 5.55570233019602e-01, -8.81921264348355e-01, 4.71396736825998e-01, -9.23879532511287e-01, 3.82683432365090e-01, -9.56940335732209e-01, 2.90284677254462e-01, -9.80785280403231e-01, 1.95090322016128e-01, -9.95184726672197e-01, 9.80171403295606e-02, 1.00000000000000e+00, 0.00000000000000e+00, 9.98795456205172e-01, 4.90676743274180e-02, 9.95184726672197e-01, 9.80171403295606e-02, 9.89176509964781e-01, 1.46730474455362e-01, 9.80785280403231e-01, 1.95090322016128e-01, 9.70031253194544e-01, 2.42980179903264e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.41544065183021e-01, 3.36889853392220e-01, 9.23879532511287e-01, 3.82683432365090e-01, 9.03989293123443e-01, 4.27555093430282e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.57728610000272e-01, 5.14102744193222e-01, 8.31469612302545e-01, 5.55570233019602e-01, 8.03207531480645e-01, 5.95699304492433e-01, 7.73010453362737e-01, 6.34393284163645e-01, 7.40951125354959e-01, 6.71558954847018e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.71558954847018e-01, 7.40951125354959e-01, 6.34393284163645e-01, 7.73010453362737e-01, 5.95699304492433e-01, 8.03207531480645e-01, 5.55570233019602e-01, 8.31469612302545e-01, 5.14102744193222e-01, 8.57728610000272e-01, 4.71396736825998e-01, 8.81921264348355e-01, 4.27555093430282e-01, 9.03989293123443e-01, 3.82683432365090e-01, 9.23879532511287e-01, 3.36889853392220e-01, 9.41544065183021e-01, 2.90284677254462e-01, 9.56940335732209e-01, 2.42980179903264e-01, 9.70031253194544e-01, 1.95090322016128e-01, 9.80785280403231e-01, 1.46730474455362e-01, 9.89176509964781e-01, 9.80171403295605e-02, 9.95184726672197e-01, 4.90676743274180e-02, 9.98795456205172e-01, -6.24500451351651e-17, 1.00000000000000e+00, -4.90676743274181e-02, 9.98795456205172e-01, -9.80171403295607e-02, 9.95184726672197e-01, -1.46730474455362e-01, 9.89176509964781e-01, -1.95090322016128e-01, 9.80785280403231e-01, -2.42980179903264e-01, 9.70031253194544e-01, -2.90284677254462e-01, 9.56940335732209e-01, -3.36889853392220e-01, 9.41544065183021e-01, -3.82683432365090e-01, 9.23879532511287e-01, -4.27555093430282e-01, 9.03989293123443e-01, -4.71396736825998e-01, 8.81921264348355e-01, -5.14102744193222e-01, 8.57728610000272e-01, -5.55570233019602e-01, 8.31469612302545e-01, -5.95699304492433e-01, 8.03207531480645e-01, -6.34393284163645e-01, 7.73010453362737e-01, -6.71558954847018e-01, 7.40951125354959e-01, -7.07106781186548e-01, 7.07106781186548e-01, -7.40951125354959e-01, 6.71558954847018e-01, -7.73010453362737e-01, 6.34393284163645e-01, -8.03207531480645e-01, 5.95699304492433e-01, -8.31469612302545e-01, 5.55570233019602e-01, -8.57728610000272e-01, 5.14102744193222e-01, -8.81921264348355e-01, 4.71396736825998e-01, -9.03989293123443e-01, 4.27555093430282e-01, -9.23879532511287e-01, 3.82683432365090e-01, -9.41544065183021e-01, 3.36889853392220e-01, -9.56940335732209e-01, 2.90284677254462e-01, -9.70031253194544e-01, 2.42980179903264e-01, -9.80785280403231e-01, 1.95090322016128e-01, -9.89176509964781e-01, 1.46730474455362e-01, -9.95184726672197e-01, 9.80171403295605e-02, -9.98795456205172e-01, 4.90676743274180e-02
};

// these are the twidle factors: wr, wi used in RealFFT
const SnSigProcDataTable<256>::RealDfftTwidleFactor_t SnSigProcDataTable<256>::kRealDfftTwidleFactor[126] = {
    9.99698818696204e-01, 2.45412285229123e-02, 9.98795456205172e-01, 4.90676743274180e-02, 9.97290456678690e-01, 7.35645635996674e-02, 9.95184726672197e-01, 9.80171403295606e-02, 9.92479534598710e-01, 1.22410675199216e-01, 9.89176509964781e-01, 1.46730474455362e-01, 9.85277642388941e-01, 1.70961888760301e-01, 9.80785280403231e-01, 1.95090322016128e-01, 9.75702130038529e-01, 2.19101240156870e-01, 9.70031253194544e-01, 2.42980179903264e-01, 9.63776065795440e-01, 2.66712757474898e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.49528180593037e-01, 3.13681740398891e-01, 9.41544065183021e-01, 3.36889853392220e-01, 9.32992798834739e-01, 3.59895036534988e-01, 9.23879532511287e-01, 3.82683432365090e-01, 9.14209755703531e-01, 4.05241314004990e-01, 9.03989293123444e-01, 4.27555093430282e-01, 8.93224301195516e-01, 4.49611329654607e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.70086991108712e-01, 4.92898192229784e-01, 8.57728610000272e-01, 5.14102744193222e-01, 8.44853565249707e-01, 5.34997619887097e-01, 8.31469612302545e-01, 5.55570233019602e-01, 8.17584813151584e-01, 5.75808191417845e-01, 8.03207531480645e-01, 5.95699304492433e-01, 7.88346427626607e-01, 6.15231590580627e-01, 7.73010453362737e-01, 6.34393284163645e-01, 7.57208846506485e-01, 6.53172842953777e-01, 7.40951125354959e-01, 6.71558954847018e-01, 7.24247082951467e-01, 6.89540544737067e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.89540544737067e-01, 7.24247082951467e-01, 6.71558954847019e-01, 7.40951125354959e-01, 6.53172842953777e-01, 7.57208846506485e-01, 6.34393284163646e-01, 7.73010453362737e-01, 6.15231590580627e-01, 7.88346427626606e-01, 5.95699304492433e-01, 8.03207531480645e-01, 5.75808191417845e-01, 8.17584813151584e-01, 5.55570233019602e-01, 8.31469612302545e-01, 5.34997619887097e-01, 8.44853565249707e-01, 5.14102744193222e-01, 8.57728610000272e-01, 4.92898192229784e-01, 8.70086991108712e-01, 4.71396736825998e-01, 8.81921264348355e-01, 4.49611329654607e-01, 8.93224301195515e-01, 4.27555093430282e-01, 9.03989293123443e-01, 4.05241314004990e-01, 9.14209755703531e-01, 3.82683432365090e-01, 9.23879532511287e-01, 3.59895036534988e-01, 9.32992798834739e-01, 3.36889853392220e-01, 9.41544065183021e-01, 3.13681740398892e-01, 9.49528180593037e-01, 2.90284677254462e-01, 9.56940335732209e-01, 2.66712757474899e-01, 9.63776065795440e-01, 2.42980179903264e-01, 9.70031253194544e-01, 2.19101240156870e-01, 9.75702130038529e-01, 1.95090322016128e-01, 9.80785280403231e-01, 1.70961888760301e-01, 9.85277642388941e-01, 1.46730474455362e-01, 9.89176509964781e-01, 1.22410675199216e-01, 9.92479534598710e-01, 9.80171403295608e-02, 9.95184726672197e-01, 7.35645635996676e-02, 9.97290456678690e-01, 4.90676743274182e-02, 9.98795456205172e-01, 2.45412285229125e-02, 9.99698818696204e-01
};

#endif // SST4CH


#if CHIPBOARD==ATWD4CH
// these are the pairs: (j, m) at each step of the loop over odd
// values of i in DiscreteCpxFFT
const SnSigProcDataTable<128>::DfftDivideIndicies_t SnSigProcDataTable<128>::kDfftDivideIndicies[128] = {
65, 64, 33, 32, 97, 64, 17, 16, 81, 64, 49, 32, 113, 64, 9, 8, 73, 64, 41, 32, 105, 64, 25, 16, 89, 64, 57, 32, 121, 64, 5, 4, 69, 64, 37, 32, 101, 64, 21, 16, 85, 64, 53, 32, 117, 64, 13, 8, 77, 64, 45, 32, 109, 64, 29, 16, 93, 64, 61, 32, 125, 64, 3, 2, 67, 64, 35, 32, 99, 64, 19, 16, 83, 64, 51, 32, 115, 64, 11, 8, 75, 64, 43, 32, 107, 64, 27, 16, 91, 64, 59, 32, 123, 64, 7, 4, 71, 64, 39, 32, 103, 64, 23, 16, 87, 64, 55, 32, 119, 64, 15, 8, 79, 64, 47, 32, 111, 64, 31, 16, 95, 64, 63, 32, 127, 64, 2, 1
};

// these are the twidle factors: wr, wi used in DiscreteCpxFFT
const SnSigProcDataTable<128>::DfftTwidleFactor_t SnSigProcDataTable<128>::kDfftTwidleFactors[126] = {
1.00000000000000e+00, 0.00000000000000e+00, 1.00000000000000e+00, 0.00000000000000e+00, 2.22044604925031e-16, 1.00000000000000e+00, 1.00000000000000e+00, 0.00000000000000e+00, 7.07106781186547e-01, 7.07106781186547e-01, 0.00000000000000e+00, 1.00000000000000e+00, -7.07106781186547e-01, 7.07106781186547e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.23879532511287e-01, 3.82683432365090e-01, 7.07106781186547e-01, 7.07106781186548e-01, 3.82683432365090e-01, 9.23879532511287e-01, -5.55111512312578e-17, 1.00000000000000e+00, -3.82683432365090e-01, 9.23879532511287e-01, -7.07106781186548e-01, 7.07106781186547e-01, -9.23879532511287e-01, 3.82683432365090e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.80785280403230e-01, 1.95090322016128e-01, 9.23879532511287e-01, 3.82683432365090e-01, 8.31469612302545e-01, 5.55570233019602e-01, 7.07106781186548e-01, 7.07106781186547e-01, 5.55570233019602e-01, 8.31469612302545e-01, 3.82683432365090e-01, 9.23879532511287e-01, 1.95090322016128e-01, 9.80785280403230e-01, 1.38777878078145e-16, 1.00000000000000e+00, -1.95090322016128e-01, 9.80785280403230e-01, -3.82683432365090e-01, 9.23879532511287e-01, -5.55570233019602e-01, 8.31469612302545e-01, -7.07106781186547e-01, 7.07106781186547e-01, -8.31469612302545e-01, 5.55570233019602e-01, -9.23879532511286e-01, 3.82683432365090e-01, -9.80785280403230e-01, 1.95090322016128e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.95184726672197e-01, 9.80171403295606e-02, 9.80785280403231e-01, 1.95090322016128e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.23879532511287e-01, 3.82683432365090e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.31469612302545e-01, 5.55570233019602e-01, 7.73010453362737e-01, 6.34393284163646e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.34393284163646e-01, 7.73010453362737e-01, 5.55570233019602e-01, 8.31469612302545e-01, 4.71396736825998e-01, 8.81921264348355e-01, 3.82683432365090e-01, 9.23879532511287e-01, 2.90284677254462e-01, 9.56940335732209e-01, 1.95090322016128e-01, 9.80785280403231e-01, 9.80171403295606e-02, 9.95184726672197e-01, 0.00000000000000e+00, 1.00000000000000e+00, -9.80171403295606e-02, 9.95184726672197e-01, -1.95090322016128e-01, 9.80785280403231e-01, -2.90284677254462e-01, 9.56940335732209e-01, -3.82683432365090e-01, 9.23879532511287e-01, -4.71396736825998e-01, 8.81921264348355e-01, -5.55570233019602e-01, 8.31469612302545e-01, -6.34393284163646e-01, 7.73010453362737e-01, -7.07106781186548e-01, 7.07106781186548e-01, -7.73010453362737e-01, 6.34393284163646e-01, -8.31469612302545e-01, 5.55570233019602e-01, -8.81921264348355e-01, 4.71396736825998e-01, -9.23879532511287e-01, 3.82683432365090e-01, -9.56940335732209e-01, 2.90284677254462e-01, -9.80785280403231e-01, 1.95090322016128e-01, -9.95184726672197e-01, 9.80171403295606e-02
};

// these are the twidle factors: wr, wi used in RealFFT
const SnSigProcDataTable<128>::RealDfftTwidleFactor_t SnSigProcDataTable<128>::kRealDfftTwidleFactor[62] = {
9.98795456205172e-01, 4.90676743274180e-02, 9.95184726672197e-01, 9.80171403295606e-02, 9.89176509964781e-01, 1.46730474455362e-01, 9.80785280403231e-01, 1.95090322016128e-01, 9.70031253194544e-01, 2.42980179903264e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.41544065183021e-01, 3.36889853392220e-01, 9.23879532511287e-01, 3.82683432365090e-01, 9.03989293123443e-01, 4.27555093430282e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.57728610000272e-01, 5.14102744193222e-01, 8.31469612302545e-01, 5.55570233019602e-01, 8.03207531480645e-01, 5.95699304492433e-01, 7.73010453362737e-01, 6.34393284163645e-01, 7.40951125354959e-01, 6.71558954847018e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.71558954847018e-01, 7.40951125354959e-01, 6.34393284163645e-01, 7.73010453362737e-01, 5.95699304492433e-01, 8.03207531480645e-01, 5.55570233019602e-01, 8.31469612302545e-01, 5.14102744193222e-01, 8.57728610000272e-01, 4.71396736825998e-01, 8.81921264348355e-01, 4.27555093430282e-01, 9.03989293123443e-01, 3.82683432365090e-01, 9.23879532511287e-01, 3.36889853392220e-01, 9.41544065183021e-01, 2.90284677254462e-01, 9.56940335732209e-01, 2.42980179903264e-01, 9.70031253194544e-01, 1.95090322016128e-01, 9.80785280403231e-01, 1.46730474455362e-01, 9.89176509964781e-01, 9.80171403295605e-02, 9.95184726672197e-01, 4.90676743274180e-02, 9.98795456205172e-01
};

#endif // ATWD4CH

#if (CHIPBOARD==SST4CH512) || (CHIPBOARD==SST4CH512_1GHz)
// these are the pairs: (j, m) at each step of the loop over odd
// values of i in DiscreteCpxFFT
const SnSigProcDataTable<512>::DfftDivideIndicies_t SnSigProcDataTable<512>::kDfftDivideIndicies[512] = {
257, 256, 129, 128, 385, 256, 65, 64, 321, 256, 193, 128, 449, 256, 33, 32, 289, 256, 161, 128, 417, 256, 97, 64, 353, 256, 225, 128, 481, 256, 17, 16, 273, 256, 145, 128, 401, 256, 81, 64, 337, 256, 209, 128, 465, 256, 49, 32, 305, 256, 177, 128, 433, 256, 113, 64, 369, 256, 241, 128, 497, 256, 9, 8, 265, 256, 137, 128, 393, 256, 73, 64, 329, 256, 201, 128, 457, 256, 41, 32, 297, 256, 169, 128, 425, 256, 105, 64, 361, 256, 233, 128, 489, 256, 25, 16, 281, 256, 153, 128, 409, 256, 89, 64, 345, 256, 217, 128, 473, 256, 57, 32, 313, 256, 185, 128, 441, 256, 121, 64, 377, 256, 249, 128, 505, 256, 5, 4, 261, 256, 133, 128, 389, 256, 69, 64, 325, 256, 197, 128, 453, 256, 37, 32, 293, 256, 165, 128, 421, 256, 101, 64, 357, 256, 229, 128, 485, 256, 21, 16, 277, 256, 149, 128, 405, 256, 85, 64, 341, 256, 213, 128, 469, 256, 53, 32, 309, 256, 181, 128, 437, 256, 117, 64, 373, 256, 245, 128, 501, 256, 13, 8, 269, 256, 141, 128, 397, 256, 77, 64, 333, 256, 205, 128, 461, 256, 45, 32, 301, 256, 173, 128, 429, 256, 109, 64, 365, 256, 237, 128, 493, 256, 29, 16, 285, 256, 157, 128, 413, 256, 93, 64, 349, 256, 221, 128, 477, 256, 61, 32, 317, 256, 189, 128, 445, 256, 125, 64, 381, 256, 253, 128, 509, 256, 3, 2, 259, 256, 131, 128, 387, 256, 67, 64, 323, 256, 195, 128, 451, 256, 35, 32, 291, 256, 163, 128, 419, 256, 99, 64, 355, 256, 227, 128, 483, 256, 19, 16, 275, 256, 147, 128, 403, 256, 83, 64, 339, 256, 211, 128, 467, 256, 51, 32, 307, 256, 179, 128, 435, 256, 115, 64, 371, 256, 243, 128, 499, 256, 11, 8, 267, 256, 139, 128, 395, 256, 75, 64, 331, 256, 203, 128, 459, 256, 43, 32, 299, 256, 171, 128, 427, 256, 107, 64, 363, 256, 235, 128, 491, 256, 27, 16, 283, 256, 155, 128, 411, 256, 91, 64, 347, 256, 219, 128, 475, 256, 59, 32, 315, 256, 187, 128, 443, 256, 123, 64, 379, 256, 251, 128, 507, 256, 7, 4, 263, 256, 135, 128, 391, 256, 71, 64, 327, 256, 199, 128, 455, 256, 39, 32, 295, 256, 167, 128, 423, 256, 103, 64, 359, 256, 231, 128, 487, 256, 23, 16, 279, 256, 151, 128, 407, 256, 87, 64, 343, 256, 215, 128, 471, 256, 55, 32, 311, 256, 183, 128, 439, 256, 119, 64, 375, 256, 247, 128, 503, 256, 15, 8, 271, 256, 143, 128, 399, 256, 79, 64, 335, 256, 207, 128, 463, 256, 47, 32, 303, 256, 175, 128, 431, 256, 111, 64, 367, 256, 239, 128, 495, 256, 31, 16, 287, 256, 159, 128, 415, 256, 95, 64, 351, 256, 223, 128, 479, 256, 63, 32, 319, 256, 191, 128, 447, 256, 127, 64, 383, 256, 255, 128, 511, 256, 2, 1
};

// these are the twidle factors: wr, wi used in DiscreteCpxFFT
const SnSigProcDataTable<512>::DfftTwidleFactor_t SnSigProcDataTable<512>::kDfftTwidleFactors[510] = {
1.00000000000000e+00, 0.00000000000000e+00, 1.00000000000000e+00, 0.00000000000000e+00, 2.22044604925031e-16, 1.00000000000000e+00, 1.00000000000000e+00, 0.00000000000000e+00, 7.07106781186547e-01, 7.07106781186547e-01, 0.00000000000000e+00, 1.00000000000000e+00, -7.07106781186547e-01, 7.07106781186547e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.23879532511287e-01, 3.82683432365090e-01, 7.07106781186547e-01, 7.07106781186548e-01, 3.82683432365090e-01, 9.23879532511287e-01, -5.55111512312578e-17, 1.00000000000000e+00, -3.82683432365090e-01, 9.23879532511287e-01, -7.07106781186548e-01, 7.07106781186547e-01, -9.23879532511287e-01, 3.82683432365090e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.80785280403230e-01, 1.95090322016128e-01, 9.23879532511287e-01, 3.82683432365090e-01, 8.31469612302545e-01, 5.55570233019602e-01, 7.07106781186548e-01, 7.07106781186547e-01, 5.55570233019602e-01, 8.31469612302545e-01, 3.82683432365090e-01, 9.23879532511287e-01, 1.95090322016128e-01, 9.80785280403230e-01, 1.38777878078145e-16, 1.00000000000000e+00, -1.95090322016128e-01, 9.80785280403230e-01, -3.82683432365090e-01, 9.23879532511287e-01, -5.55570233019602e-01, 8.31469612302545e-01, -7.07106781186547e-01, 7.07106781186547e-01, -8.31469612302545e-01, 5.55570233019602e-01, -9.23879532511286e-01, 3.82683432365090e-01, -9.80785280403230e-01, 1.95090322016128e-01, 1.00000000000000e+00, 0.00000000000000e+00, 9.95184726672197e-01, 9.80171403295606e-02, 9.80785280403231e-01, 1.95090322016128e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.23879532511287e-01, 3.82683432365090e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.31469612302545e-01, 5.55570233019602e-01, 7.73010453362737e-01, 6.34393284163646e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.34393284163646e-01, 7.73010453362737e-01, 5.55570233019602e-01, 8.31469612302545e-01, 4.71396736825998e-01, 8.81921264348355e-01, 3.82683432365090e-01, 9.23879532511287e-01, 2.90284677254462e-01, 9.56940335732209e-01, 1.95090322016128e-01, 9.80785280403231e-01, 9.80171403295606e-02, 9.95184726672197e-01, 0.00000000000000e+00, 1.00000000000000e+00, -9.80171403295606e-02, 9.95184726672197e-01, -1.95090322016128e-01, 9.80785280403231e-01, -2.90284677254462e-01, 9.56940335732209e-01, -3.82683432365090e-01, 9.23879532511287e-01, -4.71396736825998e-01, 8.81921264348355e-01, -5.55570233019602e-01, 8.31469612302545e-01, -6.34393284163646e-01, 7.73010453362737e-01, -7.07106781186548e-01, 7.07106781186548e-01, -7.73010453362737e-01, 6.34393284163646e-01, -8.31469612302545e-01, 5.55570233019602e-01, -8.81921264348355e-01, 4.71396736825998e-01, -9.23879532511287e-01, 3.82683432365090e-01, -9.56940335732209e-01, 2.90284677254462e-01, -9.80785280403231e-01, 1.95090322016128e-01, -9.95184726672197e-01, 9.80171403295606e-02, 1.00000000000000e+00, 0.00000000000000e+00, 9.98795456205172e-01, 4.90676743274180e-02, 9.95184726672197e-01, 9.80171403295606e-02, 9.89176509964781e-01, 1.46730474455362e-01, 9.80785280403231e-01, 1.95090322016128e-01, 9.70031253194544e-01, 2.42980179903264e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.41544065183021e-01, 3.36889853392220e-01, 9.23879532511287e-01, 3.82683432365090e-01, 9.03989293123443e-01, 4.27555093430282e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.57728610000272e-01, 5.14102744193222e-01, 8.31469612302545e-01, 5.55570233019602e-01, 8.03207531480645e-01, 5.95699304492433e-01, 7.73010453362737e-01, 6.34393284163645e-01, 7.40951125354959e-01, 6.71558954847018e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.71558954847018e-01, 7.40951125354959e-01, 6.34393284163645e-01, 7.73010453362737e-01, 5.95699304492433e-01, 8.03207531480645e-01, 5.55570233019602e-01, 8.31469612302545e-01, 5.14102744193222e-01, 8.57728610000272e-01, 4.71396736825998e-01, 8.81921264348355e-01, 4.27555093430282e-01, 9.03989293123443e-01, 3.82683432365090e-01, 9.23879532511287e-01, 3.36889853392220e-01, 9.41544065183021e-01, 2.90284677254462e-01, 9.56940335732209e-01, 2.42980179903264e-01, 9.70031253194544e-01, 1.95090322016128e-01, 9.80785280403231e-01, 1.46730474455362e-01, 9.89176509964781e-01, 9.80171403295605e-02, 9.95184726672197e-01, 4.90676743274180e-02, 9.98795456205172e-01, -6.24500451351651e-17, 1.00000000000000e+00, -4.90676743274181e-02, 9.98795456205172e-01, -9.80171403295607e-02, 9.95184726672197e-01, -1.46730474455362e-01, 9.89176509964781e-01, -1.95090322016128e-01, 9.80785280403231e-01, -2.42980179903264e-01, 9.70031253194544e-01, -2.90284677254462e-01, 9.56940335732209e-01, -3.36889853392220e-01, 9.41544065183021e-01, -3.82683432365090e-01, 9.23879532511287e-01, -4.27555093430282e-01, 9.03989293123443e-01, -4.71396736825998e-01, 8.81921264348355e-01, -5.14102744193222e-01, 8.57728610000272e-01, -5.55570233019602e-01, 8.31469612302545e-01, -5.95699304492433e-01, 8.03207531480645e-01, -6.34393284163645e-01, 7.73010453362737e-01, -6.71558954847018e-01, 7.40951125354959e-01, -7.07106781186548e-01, 7.07106781186548e-01, -7.40951125354959e-01, 6.71558954847018e-01, -7.73010453362737e-01, 6.34393284163645e-01, -8.03207531480645e-01, 5.95699304492433e-01, -8.31469612302545e-01, 5.55570233019602e-01, -8.57728610000272e-01, 5.14102744193222e-01, -8.81921264348355e-01, 4.71396736825998e-01, -9.03989293123443e-01, 4.27555093430282e-01, -9.23879532511287e-01, 3.82683432365090e-01, -9.41544065183021e-01, 3.36889853392220e-01, -9.56940335732209e-01, 2.90284677254462e-01, -9.70031253194544e-01, 2.42980179903264e-01, -9.80785280403231e-01, 1.95090322016128e-01, -9.89176509964781e-01, 1.46730474455362e-01, -9.95184726672197e-01, 9.80171403295605e-02, -9.98795456205172e-01, 4.90676743274180e-02, 1.00000000000000e+00, 0.00000000000000e+00, 9.99698818696204e-01, 2.45412285229123e-02, 9.98795456205172e-01, 4.90676743274180e-02, 9.97290456678690e-01, 7.35645635996674e-02, 9.95184726672197e-01, 9.80171403295606e-02, 9.92479534598710e-01, 1.22410675199216e-01, 9.89176509964781e-01, 1.46730474455362e-01, 9.85277642388941e-01, 1.70961888760301e-01, 9.80785280403231e-01, 1.95090322016128e-01, 9.75702130038529e-01, 2.19101240156870e-01, 9.70031253194544e-01, 2.42980179903264e-01, 9.63776065795440e-01, 2.66712757474898e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.49528180593037e-01, 3.13681740398891e-01, 9.41544065183021e-01, 3.36889853392220e-01, 9.32992798834739e-01, 3.59895036534988e-01, 9.23879532511287e-01, 3.82683432365090e-01, 9.14209755703531e-01, 4.05241314004990e-01, 9.03989293123444e-01, 4.27555093430282e-01, 8.93224301195516e-01, 4.49611329654607e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.70086991108712e-01, 4.92898192229784e-01, 8.57728610000272e-01, 5.14102744193222e-01, 8.44853565249707e-01, 5.34997619887097e-01, 8.31469612302545e-01, 5.55570233019602e-01, 8.17584813151584e-01, 5.75808191417845e-01, 8.03207531480645e-01, 5.95699304492433e-01, 7.88346427626607e-01, 6.15231590580627e-01, 7.73010453362737e-01, 6.34393284163645e-01, 7.57208846506485e-01, 6.53172842953777e-01, 7.40951125354959e-01, 6.71558954847018e-01, 7.24247082951467e-01, 6.89540544737067e-01, 7.07106781186548e-01, 7.07106781186548e-01, 6.89540544737067e-01, 7.24247082951467e-01, 6.71558954847019e-01, 7.40951125354959e-01, 6.53172842953777e-01, 7.57208846506485e-01, 6.34393284163646e-01, 7.73010453362737e-01, 6.15231590580627e-01, 7.88346427626606e-01, 5.95699304492433e-01, 8.03207531480645e-01, 5.75808191417845e-01, 8.17584813151584e-01, 5.55570233019602e-01, 8.31469612302545e-01, 5.34997619887097e-01, 8.44853565249707e-01, 5.14102744193222e-01, 8.57728610000272e-01, 4.92898192229784e-01, 8.70086991108712e-01, 4.71396736825998e-01, 8.81921264348355e-01, 4.49611329654607e-01, 8.93224301195515e-01, 4.27555093430282e-01, 9.03989293123443e-01, 4.05241314004990e-01, 9.14209755703531e-01, 3.82683432365090e-01, 9.23879532511287e-01, 3.59895036534988e-01, 9.32992798834739e-01, 3.36889853392220e-01, 9.41544065183021e-01, 3.13681740398892e-01, 9.49528180593037e-01, 2.90284677254462e-01, 9.56940335732209e-01, 2.66712757474899e-01, 9.63776065795440e-01, 2.42980179903264e-01, 9.70031253194544e-01, 2.19101240156870e-01, 9.75702130038529e-01, 1.95090322016128e-01, 9.80785280403231e-01, 1.70961888760301e-01, 9.85277642388941e-01, 1.46730474455362e-01, 9.89176509964781e-01, 1.22410675199216e-01, 9.92479534598710e-01, 9.80171403295608e-02, 9.95184726672197e-01, 7.35645635996676e-02, 9.97290456678690e-01, 4.90676743274182e-02, 9.98795456205172e-01, 2.45412285229125e-02, 9.99698818696204e-01, 1.66533453693773e-16, 1.00000000000000e+00, -2.45412285229121e-02, 9.99698818696204e-01, -4.90676743274178e-02, 9.98795456205172e-01, -7.35645635996673e-02, 9.97290456678690e-01, -9.80171403295604e-02, 9.95184726672197e-01, -1.22410675199216e-01, 9.92479534598710e-01, -1.46730474455362e-01, 9.89176509964781e-01, -1.70961888760301e-01, 9.85277642388941e-01, -1.95090322016128e-01, 9.80785280403231e-01, -2.19101240156870e-01, 9.75702130038529e-01, -2.42980179903264e-01, 9.70031253194544e-01, -2.66712757474898e-01, 9.63776065795440e-01, -2.90284677254462e-01, 9.56940335732209e-01, -3.13681740398891e-01, 9.49528180593037e-01, -3.36889853392220e-01, 9.41544065183021e-01, -3.59895036534988e-01, 9.32992798834739e-01, -3.82683432365090e-01, 9.23879532511287e-01, -4.05241314004990e-01, 9.14209755703531e-01, -4.27555093430282e-01, 9.03989293123444e-01, -4.49611329654606e-01, 8.93224301195516e-01, -4.71396736825997e-01, 8.81921264348355e-01, -4.92898192229784e-01, 8.70086991108712e-01, -5.14102744193222e-01, 8.57728610000272e-01, -5.34997619887097e-01, 8.44853565249707e-01, -5.55570233019602e-01, 8.31469612302545e-01, -5.75808191417845e-01, 8.17584813151584e-01, -5.95699304492433e-01, 8.03207531480645e-01, -6.15231590580627e-01, 7.88346427626607e-01, -6.34393284163645e-01, 7.73010453362737e-01, -6.53172842953777e-01, 7.57208846506485e-01, -6.71558954847018e-01, 7.40951125354959e-01, -6.89540544737067e-01, 7.24247082951467e-01, -7.07106781186547e-01, 7.07106781186548e-01, -7.24247082951467e-01, 6.89540544737067e-01, -7.40951125354959e-01, 6.71558954847019e-01, -7.57208846506484e-01, 6.53172842953777e-01, -7.73010453362737e-01, 6.34393284163646e-01, -7.88346427626606e-01, 6.15231590580627e-01, -8.03207531480645e-01, 5.95699304492433e-01, -8.17584813151584e-01, 5.75808191417845e-01, -8.31469612302545e-01, 5.55570233019602e-01, -8.44853565249707e-01, 5.34997619887097e-01, -8.57728610000272e-01, 5.14102744193222e-01, -8.70086991108711e-01, 4.92898192229784e-01, -8.81921264348355e-01, 4.71396736825998e-01, -8.93224301195515e-01, 4.49611329654607e-01, -9.03989293123443e-01, 4.27555093430282e-01, -9.14209755703531e-01, 4.05241314004990e-01, -9.23879532511287e-01, 3.82683432365090e-01, -9.32992798834739e-01, 3.59895036534988e-01, -9.41544065183021e-01, 3.36889853392220e-01, -9.49528180593037e-01, 3.13681740398892e-01, -9.56940335732209e-01, 2.90284677254462e-01, -9.63776065795440e-01, 2.66712757474899e-01, -9.70031253194544e-01, 2.42980179903264e-01, -9.75702130038528e-01, 2.19101240156870e-01, -9.80785280403230e-01, 1.95090322016128e-01, -9.85277642388941e-01, 1.70961888760301e-01, -9.89176509964781e-01, 1.46730474455362e-01, -9.92479534598710e-01, 1.22410675199216e-01, -9.95184726672197e-01, 9.80171403295608e-02, -9.97290456678690e-01, 7.35645635996676e-02, -9.98795456205172e-01, 4.90676743274182e-02, -9.99698818696204e-01, 2.45412285229125e-02
};

// these are the twidle factors: wr, wi used in RealFFT
const SnSigProcDataTable<512>::RealDfftTwidleFactor_t SnSigProcDataTable<512>::kRealDfftTwidleFactor[254] = {
9.99924701839145e-01, 1.22715382857199e-02, 9.99698818696204e-01, 2.45412285229123e-02, 9.99322384588349e-01, 3.68072229413588e-02, 9.98795456205172e-01, 4.90676743274180e-02, 9.98118112900149e-01, 6.13207363022086e-02, 9.97290456678690e-01, 7.35645635996674e-02, 9.96312612182778e-01, 8.57973123444399e-02, 9.95184726672197e-01, 9.80171403295606e-02, 9.93906970002356e-01, 1.10222207293883e-01, 9.92479534598710e-01, 1.22410675199216e-01, 9.90902635427780e-01, 1.34580708507126e-01, 9.89176509964781e-01, 1.46730474455362e-01, 9.87301418157858e-01, 1.58858143333861e-01, 9.85277642388941e-01, 1.70961888760301e-01, 9.83105487431216e-01, 1.83039887955141e-01, 9.80785280403230e-01, 1.95090322016128e-01, 9.78317370719628e-01, 2.07111376192219e-01, 9.75702130038528e-01, 2.19101240156870e-01, 9.72939952205560e-01, 2.31058108280671e-01, 9.70031253194544e-01, 2.42980179903264e-01, 9.66976471044852e-01, 2.54865659604515e-01, 9.63776065795440e-01, 2.66712757474898e-01, 9.60430519415566e-01, 2.78519689385053e-01, 9.56940335732209e-01, 2.90284677254462e-01, 9.53306040354194e-01, 3.02005949319228e-01, 9.49528180593036e-01, 3.13681740398891e-01, 9.45607325380521e-01, 3.25310292162263e-01, 9.41544065183020e-01, 3.36889853392220e-01, 9.37339011912575e-01, 3.48418680249435e-01, 9.32992798834739e-01, 3.59895036534988e-01, 9.28506080473215e-01, 3.71317193951837e-01, 9.23879532511286e-01, 3.82683432365090e-01, 9.19113851690057e-01, 3.93992040061048e-01, 9.14209755703530e-01, 4.05241314004990e-01, 9.09167983090522e-01, 4.16429560097637e-01, 9.03989293123443e-01, 4.27555093430282e-01, 8.98674465693953e-01, 4.38616238538528e-01, 8.93224301195515e-01, 4.49611329654606e-01, 8.87639620402854e-01, 4.60538710958240e-01, 8.81921264348355e-01, 4.71396736825998e-01, 8.76070094195406e-01, 4.82183772079123e-01, 8.70086991108711e-01, 4.92898192229784e-01, 8.63972856121586e-01, 5.03538383725717e-01, 8.57728610000272e-01, 5.14102744193222e-01, 8.51355193105265e-01, 5.24589682678469e-01, 8.44853565249707e-01, 5.34997619887097e-01, 8.38224705554838e-01, 5.45324988422046e-01, 8.31469612302545e-01, 5.55570233019602e-01, 8.24589302785025e-01, 5.65731810783613e-01, 8.17584813151583e-01, 5.75808191417845e-01, 8.10457198252594e-01, 5.85797857456439e-01, 8.03207531480645e-01, 5.95699304492433e-01, 7.95836904608883e-01, 6.05511041404325e-01, 7.88346427626606e-01, 6.15231590580627e-01, 7.80737228572094e-01, 6.24859488142386e-01, 7.73010453362737e-01, 6.34393284163645e-01, 7.65167265622459e-01, 6.43831542889791e-01, 7.57208846506484e-01, 6.53172842953777e-01, 7.49136394523459e-01, 6.62415777590172e-01, 7.40951125354959e-01, 6.71558954847018e-01, 7.32654271672413e-01, 6.80600997795453e-01, 7.24247082951467e-01, 6.89540544737067e-01, 7.15730825283818e-01, 6.98376249408973e-01, 7.07106781186547e-01, 7.07106781186547e-01, 6.98376249408973e-01, 7.15730825283819e-01, 6.89540544737067e-01, 7.24247082951467e-01, 6.80600997795453e-01, 7.32654271672413e-01, 6.71558954847018e-01, 7.40951125354959e-01, 6.62415777590171e-01, 7.49136394523459e-01, 6.53172842953776e-01, 7.57208846506485e-01, 6.43831542889791e-01, 7.65167265622459e-01, 6.34393284163645e-01, 7.73010453362737e-01, 6.24859488142386e-01, 7.80737228572094e-01, 6.15231590580626e-01, 7.88346427626606e-01, 6.05511041404325e-01, 7.95836904608883e-01, 5.95699304492433e-01, 8.03207531480645e-01, 5.85797857456438e-01, 8.10457198252595e-01, 5.75808191417845e-01, 8.17584813151584e-01, 5.65731810783613e-01, 8.24589302785025e-01, 5.55570233019602e-01, 8.31469612302545e-01, 5.45324988422046e-01, 8.38224705554838e-01, 5.34997619887097e-01, 8.44853565249707e-01, 5.24589682678468e-01, 8.51355193105265e-01, 5.14102744193221e-01, 8.57728610000272e-01, 5.03538383725717e-01, 8.63972856121587e-01, 4.92898192229783e-01, 8.70086991108711e-01, 4.82183772079122e-01, 8.76070094195406e-01, 4.71396736825997e-01, 8.81921264348355e-01, 4.60538710958240e-01, 8.87639620402854e-01, 4.49611329654606e-01, 8.93224301195515e-01, 4.38616238538527e-01, 8.98674465693954e-01, 4.27555093430282e-01, 9.03989293123443e-01, 4.16429560097637e-01, 9.09167983090522e-01, 4.05241314004989e-01, 9.14209755703531e-01, 3.93992040061048e-01, 9.19113851690058e-01, 3.82683432365089e-01, 9.23879532511287e-01, 3.71317193951837e-01, 9.28506080473215e-01, 3.59895036534988e-01, 9.32992798834739e-01, 3.48418680249434e-01, 9.37339011912575e-01, 3.36889853392220e-01, 9.41544065183021e-01, 3.25310292162262e-01, 9.45607325380521e-01, 3.13681740398891e-01, 9.49528180593037e-01, 3.02005949319228e-01, 9.53306040354194e-01, 2.90284677254462e-01, 9.56940335732209e-01, 2.78519689385053e-01, 9.60430519415566e-01, 2.66712757474898e-01, 9.63776065795440e-01, 2.54865659604514e-01, 9.66976471044852e-01, 2.42980179903263e-01, 9.70031253194544e-01, 2.31058108280671e-01, 9.72939952205560e-01, 2.19101240156869e-01, 9.75702130038529e-01, 2.07111376192218e-01, 9.78317370719628e-01, 1.95090322016128e-01, 9.80785280403230e-01, 1.83039887955141e-01, 9.83105487431216e-01, 1.70961888760301e-01, 9.85277642388941e-01, 1.58858143333861e-01, 9.87301418157858e-01, 1.46730474455361e-01, 9.89176509964781e-01, 1.34580708507126e-01, 9.90902635427780e-01, 1.22410675199216e-01, 9.92479534598710e-01, 1.10222207293883e-01, 9.93906970002356e-01, 9.80171403295602e-02, 9.95184726672197e-01, 8.57973123444395e-02, 9.96312612182778e-01, 7.35645635996671e-02, 9.97290456678690e-01, 6.13207363022082e-02, 9.98118112900149e-01, 4.90676743274176e-02, 9.98795456205172e-01, 3.68072229413585e-02, 9.99322384588349e-01, 2.45412285229119e-02, 9.99698818696204e-01, 1.22715382857196e-02, 9.99924701839145e-01
};
#endif // SST4CH512 or SST4CH512_1GHz
