#ifndef SN_SnConstants
#define SN_SnConstants

// see this file for various switches and options
// used to buid the mbed binary
#include "SnPreCompOptions.h"

#include "SnBitUtils.h"
#include "SnCommConstants.h"

//
// constants
//

// this should be updated for each and every mbed board (ugh!)
static const char kDefaultMacAdress[] = {0x00, 0x02, 0xAA, 0xAA, 0xAA, 0xAA}; // for testing SST
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xBB, 0xBB, 0xBB, 0xBB}; // for testing ATWD
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF0, 0xAE, 0xE0}; // STN 20 (ATWD MB 1) 0002F7F0AEE0
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF0, 0xC3, 0xB6}; // STN  3 (ATWD MB 5) 0002F7F0C3B6
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF2, 0x1A, 0x8A}; // STN 18 (SST 111)   0002F7F21A8A
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF0, 0xC6, 0x1A}; // STN 10 (ATWD MB 8) 0002F7F0C61A
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF2, 0x0A, 0x9C}; // STN 14 (SST 104)   0002F7F20A9C
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF2, 0x02, 0xC1}; // STN 17 (SST 109)   0002F7F202C1
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF2, 0x24, 0x44}; // STN 19 (SST 105)   0002F7F22444
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF1, 0xF7, 0xA8}; // STN 15 (SST 110)   0002F7F1F7A8
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF2, 0x24, 0x4B}; // STN 13 (SST 102)   0002F7F2244B
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF1, 0xF6, 0x34}; // STN 31 (SST 107)   0002F7F1F634
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF1, 0xF2, 0x1A}; // STN 32 (SST 112)   0002F7F1F21A (slow)
//static const char kDefaultMacAdress[] = {0x00, 0x02, 0xF7, 0xF1, 0xF2, 0x12}; // STN 30 (SST 113)   0002F7F1F212

// if these change, it is likely that some i/o version (config, event, etc) will need to change
static const bool     kIridPwrFromAfar  = false; // true if Iridium & Afar are on the same relay, false if not
static const uint32_t kBStime           = 946684800u; // 1/1/2000 00:00:00 UTC

// these constants are used to specify the size of a specific i/o version of a frame, even if e.g. the number of samples changes for later i/o versions
// these values should NEVER be changed!!
// these values should be used in i/o functions
static const uint8_t  kNplasV1          = 5u; // to preserve i/o version sizes
static const uint16_t kNsampsAtwd       = 128u;
static const uint16_t kNsampsSst        = 256u;
static const uint16_t kNsampsSst512     = 512u;
static const uint8_t  kNchanDacsAtwd    = 4u;
static const uint8_t  kNchanDacsSst     = 2u;
static const uint8_t  kNchansFourAnt    = 4u;
static const uint8_t  kNchansEightAnt   = 8u;
static const uint8_t  kNchipsSst4ch     = 1u;
static const uint8_t  kNchipsSst8ch     = 2u;
static const uint16_t kTotSampsAtwd4ch  = kNchansFourAnt*kNsampsAtwd;
static const uint16_t kTotDacsAtwd4ch   = kNchansFourAnt*kNchanDacsAtwd;
static const uint16_t kTotSampsSst4ch   = kNchansFourAnt*kNsampsSst;
static const uint16_t kTotSampsSst4ch512= kNchansFourAnt*kNsampsSst512;
static const uint16_t kTotSampsSst8ch   = kNchansEightAnt*kNsampsSst;
static const uint16_t kTotDacsSst4ch    = kNchansFourAnt*kNchanDacsSst;
static const uint16_t kTotDacsSst8ch    = kNchansEightAnt*kNchanDacsSst;
static const uint16_t kNstopBytesSst4ch    = kNchipsSst4ch * (kNsampsSst / BITS_IN_CHAR); // if the values change, may need to round this numebr
static const uint16_t kNstopBytesSst4ch512 = kNchipsSst4ch * (kNsampsSst512 / BITS_IN_CHAR); // if the values change, may need to round this numebr
static const uint16_t kNstopBytesSst8ch    = kNchipsSst8ch * (kNsampsSst / BITS_IN_CHAR); // if the values change, may need to round this numebr

// these are the station config sizes, and may change. they should not be used in i/o functions. i/o versions need updating as these change!
#if CHIPBOARD==ATWD4CH
static const uint8_t  kNchans           = kNchansFourAnt;
static const uint16_t kNsamps           = kNsampsAtwd;
static const uint8_t  kNplas            = kNplasV1; // update config i/o version if this changes
static const uint8_t  kNchanDacs        = kNchanDacsAtwd;
static const uint16_t kNoTrigPla        = 0x0000u;
static const float    kAsfClkPrdUs      = 8.535; // us -- change kAdcToMBtimeCut if this is <=2us
static const float    kAdcToMBtimeCut   = (kNsamps*kAsfClkPrdUs)+(kAsfClkPrdUs/2.0);
#elif (CHIPBOARD==SST4CH) || (CHIPBOARD==SST4CH_1GHz)
static const uint8_t  kNchans           = kNchansFourAnt;
static const uint16_t kNsamps           = kNsampsSst;
static const uint8_t  kNchanDacs        = kNchanDacsSst;
static const uint16_t kNstopBytes       = kNstopBytesSst4ch;
static const uint8_t  kNumLTC2657s      = 1;
static const uint8_t  kChansPerLTC2657  = 4;
static const uint8_t  kLTC2657Adrs[]    = { 0x73u << 1 }; // slave address that every LTC2657 DAC chip will respond to
static const uint8_t  kUpdateDacCmd     = 0x3u;       // LTC2657 DAC chip command bits that write to & update DAC value
static const uint8_t  kMaxDacSetTries   = 3u;         // how many times to retry setting a dac in case no ACK is received from the DAC chip
static const uint8_t  kMaxRateReadTries = 3u;         // how many times to retry reading a single-channel rate from FPGA if no ACK is receiv
#elif (CHIPBOARD==SST4CH512) || (CHIPBOARD==SST4CH512_1GHz)
static const uint8_t  kNchans           = kNchansFourAnt;
static const uint16_t kNsamps           = kNsampsSst512;
static const uint8_t  kNchanDacs        = kNchanDacsSst;
static const uint16_t kNstopBytes       = kNstopBytesSst4ch512;
static const uint8_t  kNumLTC2657s      = 1;
static const uint8_t  kChansPerLTC2657  = 4;
static const uint8_t  kLTC2657Adrs[]    = { 0x73u << 1 }; // slave address that every LTC2657 DAC chip will respond to
static const uint8_t  kUpdateDacCmd     = 0x3u;       // LTC2657 DAC chip command bits that write to & update DAC value
static const uint8_t  kMaxDacSetTries   = 3u;         // how many times to retry setting a dac in case no ACK is received from the DAC chip
static const uint8_t  kMaxRateReadTries = 3u;         // how many times to retry reading a single-channel rate from FPGA if no ACK is receiv
#elif (CHIPBOARD==SST8CH) || (CHIPBOARD==SST8CH_1GHz)
static const uint8_t  kNchans           = kNchansEightAnt;
static const uint16_t kNsamps           = kNsampsSst;
static const uint8_t  kNchanDacs        = kNchanDacsSst;
static const uint16_t kNstopBytes       = kNstopBytesSst8ch;
static const uint8_t  kNumLTC2657s      = 2;
static const uint8_t  kChansPerLTC2657  = 4;
static const uint8_t  kLTC2657Adrs[]    = { 0x41u << 1, 0x32u << 1 }; // Adr[0]=1000001 (flt-flt-flt), Adr[2]=0110010 (flt-gnd-flt)
static const uint8_t  kUpdateDacCmd     = 0x3u;       // LTC2657 DAC chip command bits that write to & update DAC value
static const uint8_t  kMaxDacSetTries   = 3u;         // how many times to retry setting a dac in case no ACK is received from the DAC chip
static const uint8_t  kMaxRateReadTries = 3u;         // how many times to retry reading a single-channel rate from FPGA if no ACK is receiv
#endif
static const uint8_t  kNcomms           = 2u;   // must match the number of comms enabled in SnPreCompOptions
static const uint16_t kNvoltsAve        = 500u; // must be greater than ~10 (but value is not checked, so <2 will result in a divide by 0)

static const uint32_t kAbsMaxTimer      = 1800u; // timers use integers counting us and can't go longer than ~ this many secs

// NOTE: these times (in sec) must be less than kAbsMaxTimer (this is not checked, however)
static const uint8_t  kDefTimeoutMin    = 1u;    // minutes. used in case (minimum) range needs enforcing
static const uint8_t  kDefTimeoutSafe   = 3u;    // minutes. used in case a clock error is detected or max range needs enforcing
static const uint32_t kCommWinLongPrdTk = 300u;  // seconds. check if it's time for a comm win every X sec. this way comm per can be longer than Timer allows

// 2015-10-12: increased from 4 to 75. this raises the window before a reboot from ~1 hour to ~1 day, depending on config options
static const uint16_t kMaxConsecCommFails = 75;    // (exclusive) number of times a comm win can fail before the mbed resets

// safety nets
static const uint16_t kMaxFirstSeq      = 25000;  // max specifiable seq number -- leave room to grow
static const float    kMinForcePer      = 0.05;   // seconds -- safety net for max force trigger rate
static const uint16_t kMaxThrottlePerMs = 60000;  // ms -- max time between thermal triggers
static const uint16_t kMaxBatVoltLowPwr = 25000;  // ADCs -- probably futile, but try to prevent it from being in low power mode always
static const uint32_t kMinCommWinPeriod = 120;    // seconds -- min time between communication windows
static const uint32_t kMaxCommWinPeriod = 259200; // seconds -- max time between communication windows
static const uint32_t kMinCommWinDur    = 600;    // seconds -- min communication window duration -- must be >= Ncomms*listen/connect timeout
static const uint32_t kMaxWatchDogPer   = 3600;   // seconds -- max time before watchdog reset on idle
static const uint32_t kMinWatchDogPer   = 300;    // seconds -- min time before watchdog reset on idle
static const uint8_t  kMinSingleFreqSuppRatio = 26; // L1>0.1 is the min cut value (avoid rejecting absolutely all events)
static const uint8_t  kMaxSingleFreqSuppRatio =255; // L1>1.0 is the max cut value
static const uint8_t  kDefSingleFreqSuppRatio = 77; // L1=0.3 is the default

static const uint16_t kTotSamps         = kNchans*kNsamps;
static const uint16_t kTotDacs          = kNchans*kNchanDacs;


enum ETrgBit_t {
      // see SnEventFrame::fTrgBits for number of available bits
      kThermal     = BIT(0),  // thermal trigger
      kForced      = BIT(1),  // forced trigger
      kExternal    = BIT(2),  // reserved for external, but impossible to set with current DAQ
      kSingleFreqSupp = BIT(3), // the L1 trigger to cut away events with a large fraction of power in a single frequency
      // bit 4 not yet used
      kL1Scaledown  = BIT(5), // whether the event is written thanks to the L1 scaledown
      kL1TrgApplied = BIT(6), // whether to throw away events based on L1 triggers
      kAdcToMBflag = BIT(7)  // flag events that took too long to get data from dCards to MB
};

enum EL1TrigStatus {
    kL1Fail=0,
    kL1Pass=1,
    kL1UnableToProcess=2
};

#endif // SN_SnConstants