#include "SnCommWinAfar.h"

#include "SnCommAfarNetIf.h"

SnCommWinAfar::SnCommWinAfar(SnConfigFrame& conf) :
    SnCommWin(new SnCommAfarNetIf(conf.GetRemoteServer(),
                                  conf.GetRemotePort(),
                                  conf.GetMbedIP(), 
                                  conf.GetMbedMask(),
                                  conf.GetMbedGate())) {

}

SnCommWin::ECommWinResult SnCommWinAfar::OpenWindow(const bool sendStatus,
                                                    const SnConfigFrame& conf,
                                                    const SnPowerFrame& pow, // com win power
                                                    const SnEventFrame& stEvent,
                                                    const uint16_t seq,
                                                    const uint32_t numThmTrigs,
                                                    const uint32_t numSavedEvts, 
                                                    const float    seqlive,
                                                    const uint32_t powerOnTime,
                                                    const SnTempFrame& temper, // com win temp
                                                    char* const genBuf,
                                                    const uint32_t timeout_clock) {
#ifdef DEBUG
    printf("SnCommWinAfar::OpenWindow\r\n");
#endif

    const bool canCon = fComm->Connect(timeout_clock);
    
    SnCommWin::ECommWinResult ret = canCon ? SnCommWin::kConnected
                                           : SnCommWin::kCanNotConnect;
    
    if (canCon && sendStatus) {
#ifdef DEBUG
    printf("calling SendStatus\r\n");
#endif
        ret = SendStatus(conf, pow, stEvent, seq,
                         numThmTrigs, numSavedEvts, seqlive,
                         powerOnTime, temper,
                         genBuf,
                         timeout_clock);

#ifdef DEBUG
    printf("Send Status returned\r\n");
#endif
    }
    
    return ret;
}
