#ifndef SNS_SnHeaderFrame
#define SNS_SnHeaderFrame

#include <stdint.h>

#include "SnBitUtils.h"

class SnHeaderFrame {
 public:
    //
    // A simple class to function like namespace.
    // The header for each i/o message is read/sent from here, in order to
    // ensure consistency across the communication methods.
    //
    
    static const uint32_t    kMaxSizeOf       = sizeof(uint8_t) + sizeof(uint32_t);

    // these are not in an enum so that we can control their size in bytes (1 byte)
    // the values should NEVER change
    static const uint8_t    kStatusCode      = 0x10;
    static const uint8_t    kStatusDataPack  = 0x12; // signal that some data (config, event, etc) is being sent in a status update
    static const uint8_t    kStatusUpdDone   = 0x13; // signal the end of the status update (status i/o V9+)
    static const uint8_t    kStatusDatPakDone= 0x14; // signal the end of the status data packs (status i/o version 9+)
    static const uint8_t    kFileCode        = 0x20;
    static const uint8_t    kFilenameCode    = 0x23;
    static const uint8_t    kFileTrgStrtCode = 0x24;
    static const uint8_t    kFileTrgStopCode = 0x25;
    static const uint8_t    kFileNevtsCode   = 0x26;
    static const uint8_t    kFileNpwrsCode   = 0x28;
    static const uint8_t    kFileHeadrCode   = 0x2A;
    static const uint8_t    kFileReadFailCode= 0x2C;
    static const uint8_t    kMbedFileCode    = 0x30;
    static const uint8_t    kMbedFilenameCode= 0x33;
    static const uint8_t    kMbedFileChksCode= 0x35;
    static const uint8_t    kConfigCode      = 0x40;
    static const uint8_t    kEventCode       = 0x50;
    static const uint8_t    kHndShkBits      = 0x60; // all handshakes have these bits set
    static const uint8_t    kHnShOkComplCode = 0x61;
    static const uint8_t    kHnShOkRqPtRnCode= 0x62; // partial run req
    static const uint8_t    kHnShOkRqPtSqCode= 0x63; // [minseq,maxseq] of partial run req
    static const uint8_t    kHnShOkPartlCode = 0x64;
    static const uint8_t    kHnShOkReqRnCode = 0x65;
    static const uint8_t    kHnShOkStopCode  = 0x66;
    static const uint8_t    kHnShOkDelRnCode = 0x67;
    static const uint8_t    kHnShOkDelAlCode = 0x68;
    static const uint8_t    kHnShOkClRSLCode = 0x69; // clear run/seq list since last comm win file
    static const uint8_t    kHnShFailPrtCode = 0x6A;
    static const uint8_t    kHnShFailNonCode = 0x6C;
    static const uint8_t    kHnShDemandCode  = 0x6E;
    static const uint8_t    kHnShNoReplyCode = 0x6F;
    static const uint8_t    kPowerCode       = 0x70;
    static const uint8_t    kTemperatureCode = 0x74;
    static const uint8_t    kHeartbeatCode   = 0x78;
    static const uint8_t    kNoConfigCode    = 0x80;
    static const uint8_t    kSbdMsgCode      = 0x90;
    static const uint8_t    kStringCode      = 0xA0; // a debug string
    static const uint8_t    kSignalStrCode   = 0xB0;
    static const uint8_t    kCommSignOffCode = 0xC0;

 private:
    static       char       fgHdBuf[kMaxSizeOf];

 public:

    static
    char* GetHdBuf(const uint8_t mcode, const uint32_t mlen) {
        char* b = fgHdBuf;
        WriteTo(b, mcode, mlen);
        return fgHdBuf;
    }
    
    template<class T>
    static
    bool WriteTo(T& x,
                 const uint8_t msgCode,
                 const uint32_t msgLen) {
        // expect 'x' to be a MODSERIAL or a char const* or a FILE*
        x = SnBitUtils::WriteTo(x, msgCode);
        x = SnBitUtils::WriteTo(x, msgLen);
        return true;
    }
    
    template<class T>
    static
    bool ReadFrom(T& b,
                  uint8_t& msgCode,
                  uint32_t& msgLen) {
        b = SnBitUtils::ReadFrom(b, msgCode);
        b = SnBitUtils::ReadFrom(b, msgLen);
        return true;
    }
    
    static
    uint32_t SizeOf() {
        return kMaxSizeOf;
    }
    
};

#endif // SNS_SnHeaderFrame
