#ifndef SN_SnCommUsb
#define SN_SnCommUsb

#include "SnCommPeripheral.h"

#ifdef ENABLE_USB


#define CALL_MEMBER_FN(object,ptrToMember)  ((object).*(ptrToMember))

class SnCommUsb : public SnCommPeripheral {
 public:
    typedef int (COMM_SERIALTYPE::*USBCheckDataInBuf)();
    //typedef int (SnCommUsb::*USBPutGetC)(char* const);
    
 private:
    static COMM_SERIALTYPE* fgCpu;

    int             GetC(char* const d);
    int             PutC(const char* const d);

 protected:
    template<class DATA, class SENDRECV>
    int DoIO(DATA data,
             const uint32_t length,
             const uint32_t timeout_clock,
             USBCheckDataInBuf able,
             SENDRECV fcn) {
        // TODO: if B64, must return number of bytes of raw (non encoded) message
        int res=0;
        uint32_t b=0;
        while ( (length>b) ) {
            if (IsTimedOut(timeout_clock)) {
                break;
            }
            if ( CALL_MEMBER_FN(*fgCpu, able)() ) { // readable/writable ?
                res = CALL_MEMBER_FN(*this, fcn)(data+b);
                if (res<sizeof(char)) {
                    return b; // error
                } else {
                    b += res;
                }
            } else {
#ifdef USE_RTOS
                Thread::wait(10);
#else
                wait_ms(10);
#endif
            }
        }
    
        return b;
    }
/*
    int             DoIO(char* const data,
                         const uint32_t length,
                         const uint32_t timeout_clock,
                         USBCheckDataInBuf able,
                         USBPutGetC fcn);
*/
    virtual int32_t ReceiveAll(char* const buf, const uint32_t mlen,
                               const uint32_t timeout_clock);
    virtual int32_t SendAll(const char* const data, const uint32_t length,
                            const uint32_t timeout_clock);
    virtual int32_t FinishSending(const uint32_t) {
        // all data sent in SendAll; 0 bytes sent here
        return 0;
    }

    
 public:
    SnCommUsb(COMM_SERIALTYPE* c=0) { if (c!=0) { SetupPort(c); } }

    virtual ~SnCommUsb() {}
    
    static
    bool         IsPortSetup() { return fgCpu!=0; }
    
    static
    bool         SetupPort(COMM_SERIALTYPE* cpu);
    
    virtual bool Connect(const uint32_t timeout)
        { return IsPortSetup(); }

    virtual bool CloseConn(const uint32_t) { return true; }
    virtual bool PowerDown(const uint32_t) { return true; }
    
    
    
};

#endif // ENABLE_USB


#endif // SN_SnCommUsb
