#ifndef SN_SnCommConstants
#define SN_SnCommConstants

//#define CPUBAUD_SN 921600
//#define CPUBAUD_SN 460800
#define CPUBAUD_SN 115200

// undefine any of these to disable the peripheral
#define ENABLE_AFAR
#define ENABLE_USB
#define ENABLE_SBD
//#define USE_RTOS

//#define DEBUG

#define USE_MODSERIAL

static const uint32_t kSecsPerDay       = 3600u*24u;
static const uint32_t kSecsPerYear      = kSecsPerDay*365u;

//static const double   kIridEpoch        = 1173325835.000; // 2007-3-08 03:50:35 GMT (needs to be a double)
static const double   kIridEpoch        = 1399818234.000; // 2014-05-11 14:23:54 GMT (needs to be a double)
static const double   kSecPerIridTick   = 90.000e-3;      // 90ms/tick

static const size_t   kMaxStrLen        = 512;   // max bytes for a string send. prevent something crazy

// we have to do this shit because Serial and MODSERIAL don't have virtual functions
// so calling, e.g. readable from a Serial* will call Serial::readable instead of MODSERIAL::readable
// and the comms will wait forever
#ifdef USE_MODSERIAL
namespace AjK {
    class MODSERIAL;
};
#define COMM_SERIALTYPE AjK::MODSERIAL
#else
#define COMM_SERIALTYPE Serial
#endif

#endif // SN_SnCommConstants