#include "SnCommUsb.h"

#ifdef ENABLE_USB


#include <stdint.h>

#include "SnCommConstants.h"

#ifdef USE_MODSERIAL
#include "MODSERIAL.h"
#endif

//#define DEBUG

COMM_SERIALTYPE* SnCommUsb::fgCpu     =  0;

static const uint8_t __kMaxUChar     = ~0;

bool SnCommUsb::SetupPort(COMM_SERIALTYPE* cpu) {
    fgCpu = cpu;

#ifdef DEBUG
    printf("fgCpu=%p\r\n",fgCpu);
#endif

    // set up serial-usb port
    if (fgCpu!=0) {
        fgCpu->baud( CPUBAUD_SN );
        fgCpu->format( 8, Serial::None, 1 );
#ifdef USE_MODSERIAL
        static_cast<AjK::MODSERIAL*>(fgCpu)->txBufferFlush();
        static_cast<AjK::MODSERIAL*>(fgCpu)->rxBufferFlush();
#endif
        while ( fgCpu->readable() ) {
            fgCpu->getc();
        }
        return true;
    } else {
        return false;
    }
}

int SnCommUsb::GetC(char* const d) {
    // return number of bytes gotten (1) or -1 on error
    // no check that d is not 0
    const int c = fgCpu->getc();
    if ( (c>-1) && (c<=__kMaxUChar)) {
        *d = static_cast<char>(c);
        return sizeof(char);
    } else {
        return -1;
    }
}

int SnCommUsb::PutC(const char* const d) {
    // return number of bytes put (1) or -1 on error
    // no check that d is not 0
    const int c = fgCpu->putc(*d);
    if (c<0) { // putc can return 0 on success
        return -1;
    } else {
        return sizeof(char);
    }
}

int32_t SnCommUsb::ReceiveAll(char* const buf, const uint32_t mlen,
                              const uint32_t timeout_clock) {
    return DoIO(buf, mlen, timeout_clock, &COMM_SERIALTYPE::readable, &SnCommUsb::GetC);
}

int32_t SnCommUsb::SendAll(const char* const data, const uint32_t length,
                           const uint32_t timeout_clock) {
#ifdef DEBUG
    printf("calling (PutC)DoIO len=%u, to=%u, time=%u\r\n",
        length, timeout_clock, time(0));
#endif
    return DoIO(data, length, timeout_clock, &COMM_SERIALTYPE::writeable, &SnCommUsb::PutC);
}


#endif // ENABLE_USB