#ifndef SN_SnCommPeripheral
#define SN_SnCommPeripheral

#include "mbed.h"
#include <stdint.h>
#include <string>

#include "SnCommConstants.h"

// ABC for communication peripherals

class SnCommPeripheral {

 public:
    virtual ~SnCommPeripheral() {}
    
    //
    // optional overloads
    //
    virtual bool TrySetSysTimeUnix(const uint32_t timeout,
                                   uint32_t& prvTime,
                                   uint32_t& setTime) { return false; }
    virtual bool CheckSignalStrength(const uint32_t timeout,
                                     float& sigstr) { return false; }
    virtual bool IsTimedOut(const uint32_t timeout_clock) const;
    virtual bool SendString(const char* str, const uint32_t timeout);
    
    //
    // mandatory overloads
    //
    
    //
    // send and receive must not kick the watchdog, or a bad timeout
    // could block a station forever!!
    //
    
    // try to get 'mlen' number of bytes, put them in 'buf' and return the
    // number of bytes received.
    virtual int32_t ReceiveAll(char* const buf, const uint32_t mlen,
                               const uint32_t timeout_clock)=0;
    // try to send 'length' number of bytes from 'data'. peripheral may use
    // a buffer, so the bytes may not actually go out.
    // return the number of bytes sent; not buffered.
    virtual int32_t SendAll(const char* const data, const uint32_t length,
                            const uint32_t timeout_clock)=0;
    // if the peripheral buffers sends, flush the buffers and return the
    // number of bytes sent.
    virtual int32_t FinishSending(const uint32_t timeout_clock)=0;
    
    // try to connect to the remote system
    virtual bool            Connect(const uint32_t timeout)=0;
    // close connection with the remote system
    virtual bool            CloseConn(const uint32_t timeout)=0;
    // send any necessary signals to the peripheral prior to powering off
    virtual bool            PowerDown(const uint32_t timeout)=0;
    
    // utility function
    static
    void CapitalizeInPlace(std::string::iterator s,
                           const std::string::const_iterator send);

    // for debugging
    void dispStrBytes(const char* const s, const uint32_t len,
                      const bool dispLetters=true) const {
        const char* c = s;
        for (uint32_t i=0; i<len; ++i, ++c) {
            if (dispLetters) {
                if (*c>0x1F && *c<0x7F) {
                    printf("%c", *c);
                } else {
                    printf(".x%02x.", *c);
                }
            } else {
                printf("%02x ", *c);
            }
        }
    }
    
};

#endif // SN_SnCommPeripheral
