#include "SnCommPeripheral.h"

#include <string>

#include "SnHeaderFrame.h"

bool SnCommPeripheral::IsTimedOut(const uint32_t timeout_clock) const {
    /* - don't handle the not obeying timeout like this; it seems too risky
     * instead, a long timeout will keep refreshing after each handshake
    if (timeout_clock==0) {
        // for not obeying timeout option
        return false;
    } else {
    */
    const uint32_t ct = time(0);
    if ( (ct==0) ||
         (fabs(static_cast<double>(timeout_clock-ct))>kSecsPerDay) ) {
        // clock problems!
        // timeout now. hope the clock problems
        // get fixed in the next comm window
        return true;
    } else {
        return (ct>timeout_clock);
    }
    /*
    }
    */
}

bool SnCommPeripheral::SendString(const char* str,
                                  const uint32_t timeout) {
#ifdef DEBUG
    printf("SnCommPeripheral::SendString %s. to=%u, ct=%u\r\n",
        str, timeout, time(0));
#endif
    const size_t rlen = strlen(str);
    const size_t slen = (rlen > kMaxStrLen) ? kMaxStrLen : rlen;
    // write header to genBuf and send it
    int32_t msiz =      SnHeaderFrame::SizeOf();
    static char hdrbuf[ SnHeaderFrame::kMaxSizeOf+1 ];
    char* t = hdrbuf;
    SnHeaderFrame::WriteTo(t, SnHeaderFrame::kStringCode, slen);
    int32_t mlen = SendAll(hdrbuf, msiz, timeout);
    // send the string
    msiz += slen;
    mlen += SendAll(str, slen, timeout);
    mlen += FinishSending(timeout);
    /*
    const size_t rlen = strlen(str);
    const size_t slen = rlen > kMaxStrLen ? kMaxStrLen : rlen;
    const int msiz = slen+SnHeaderFrame::SizeOf();
    char* const ts = new char[msiz];
    char* t = ts;
    SnHeaderFrame::WriteTo(t, SnHeaderFrame::kStringCode, slen);
    strncpy(t, str, slen);
    int32_t mlen = SendAll(ts, msiz, timeout);
    delete[] ts;
    mlen += FinishSending(timeout);
    */
    return (msiz==mlen);
}

void SnCommPeripheral::CapitalizeInPlace(std::string::iterator s,
                                  const std::string::const_iterator send) {
    static const char upd = 'a' - 'A'; // a>A
    for (; s!=send; ++s) {
        if ( ((*s)>='a') && ((*s)<='z') ) {
            (*s) -= upd;
        }
    }
}
