#ifndef SN_SnCommAfarNetIf
#define SN_SnCommAfarNetIf

#include "SnCommPeripheral.h"

#ifdef ENABLE_AFAR

#include "string"

#include "TCPSocket.h"
#include "EthernetNetIf.h"


//#define DEBUG



#define CALL_MEMBER_FN(object,ptrToMember)  ((object).*(ptrToMember))

#define RX_BUF_LEN      512     // bytes
#define RX_TIMEOUT      1       // seconds


class SnEventFrame;

class SnCommAfarNetIf : public SnCommPeripheral {    
 private:
    void    NewEthAndSocket();
    int32_t PullFromBuffTo(char* const buf, const uint32_t len);


 protected:
    bool                fUseB64;
    std::string         fRserv;
    uint16_t            fRport;
    std::string         fMyIp;
    std::string         fMyMask;
    std::string         fMyGate;
    EthernetNetIf*      fEth;
    TCPSocket*          fSock;
    volatile bool       fEthConnected;
    volatile bool       fSockReading;
    volatile bool       fEthWriteable;
    volatile bool       fConnAborted;
    volatile bool       fEthSetup;
    
    char                fRxBuf[RX_BUF_LEN];
    char*               fRxRd;              // the position to read from
    char*               fRxWt;              // the position to write to
    char*               fRxEnd;             // always stay under this (init'd in ctor)
    volatile bool       fRxBufWriteable;    // if it's ok to write into fRxBuf
    
    bool    SockConnect(const Host& server, const uint32_t timeout);
    virtual void    onTCPSocketEvent(TCPSocketEvent e);
    void    NewSocket();

    template<class DATA, class SENDRECV>
    int DoIO(DATA data,
             const uint32_t length,
             const uint32_t timeout_clock,
             SENDRECV fcn,
             volatile bool& able) {
#ifdef DEBUG
        //printf("SnCommAfarNetIf::DoIO data:\r\n");
        //dispStrBytes(data, length);
        //printf("\r\n");
#endif
        int res=0;
        int b=0;
        while ( (length>b) ) {
            Net::poll();
            if (IsTimedOut(timeout_clock)) {
#ifdef DEBUG
                printf("SnCommAfarNetIf::DoIO timing out\r\n");
#endif
                break;
            }
            if (fEthConnected && able) {
                res = CALL_MEMBER_FN(*fSock, fcn)(data+b, length-b);
                if (res>0) {
                    b += res;
                }
            } else {
#ifdef USE_RTOS
                Thread::wait(50);
#else
                wait(0.05);
#endif
            }
        }
#ifdef DEBUG
        printf("SnCommAfarNetIf::DoIO: return b=%d\r\n",b);
#endif
        return b; // timeout
    }

    virtual int32_t ReceiveAll(char* const buf, const uint32_t mlen,
                               const uint32_t timeout_clock);
    virtual int32_t SendAll(const char* const data, const uint32_t length,
                            const uint32_t timeout_clock);
    virtual int32_t SendAll(char* const data, const uint32_t length,
                            const uint32_t timeout_clock) {
        const char* const d = data;
        return SendAll(d, length, timeout_clock);
    }
    virtual int32_t FinishSending(const uint32_t) {
        // all data sent in SendAll; 0 bytes sent here
        return 0;
    }
    
 public:
    SnCommAfarNetIf(const char* rserv,
        const uint16_t rport, const char* ip,
        const char* mask, const char* gate);
    virtual ~SnCommAfarNetIf();
    
    void    Set(const char* remote, const uint16_t rport,
                const char* myip, const char* mask,
                const char* gate, const bool useb64);
    
    void    Set(const char* remote, const uint16_t rport);
    
    void    SetEthSetup(const bool x) { fEthSetup = x; } // TODO: put in a whisperer
    
    virtual bool Connect(const uint32_t timeout);
    
    virtual bool CloseConn(const uint32_t);
    virtual bool PowerDown(const uint32_t) { return true; }
    
};

#endif // ENABLE_AFAR

#endif // SN_SnCommAfarNetIf
