#ifndef SN_SnCommSBD
#define SN_SnCommSBD

#include "SnCommPeripheral.h"

#ifdef ENABLE_SBD

#include "SnHeaderFrame.h"
#include "string"

#define CALL_MEMBER_FN(object,ptrToMember)  ((object).*(ptrToMember))

class SnCommSBD : public SnCommPeripheral {
 public:
    static const uint16_t   kMaxSend = 340-SnHeaderFrame::kMaxSizeOf; // max bytes sendable by SBD
    static const uint16_t   kMaxRecv = 270-SnHeaderFrame::kMaxSizeOf; // max bytes readable by SBD
    static const uint16_t   kWaitOnGSS = 30;                          // seconds
    static const uint16_t   kRxBufSz = 5*kMaxRecv;                    // size of read buffer in bytes
    static const uint16_t   kTxBufSz =   kMaxSend;                    // size of send buffer in bytes
    
    //typedef int32_t (SnCommSBD::*SBDSendRecv)(char* const, const uint32_t, const uint32_t);
    typedef bool    (SnCommSBD::*SerialReadWriteable)();
    
 private:
    COMM_SERIALTYPE*        fSBD;              // serial connection to the SBD modem. maybe a MODSERIAL (which inherits from Serial)
    char                    fRxBuf[kRxBufSz];  // store the incoming SBD msg in case it's not read all at once
    char                    fTxBuf[kTxBufSz];  // store the incoming SBD msg in case it's not read all at once
    uint16_t                fTxPos;            // current position in tx buffer
    uint16_t                fRxPos;            // position in rx buffer
    uint16_t                fRxSiz;            // size of message stored in rx buffer
    uint16_t                fRMsgNum;          // recv SBD message number
    uint16_t                fRMsgTot;          // recv total SBD messages
    uint16_t                fSMsgNum;          // send SBD message number
    uint16_t                fSMsgTot;          // send total SBD messages. separate from the read num/tot to allow (a) read 1/2, (b) send msg, (c) read 2/2
    // TODO: with outgoing buffering, the total number of messages to be sent cannot be known ahead of time!
    
    template<class DATA, class SENDRECV>
    int DoIO(DATA data,
             const uint32_t length,
             const uint32_t timeout_clock,
             SENDRECV fcn,
             SerialReadWriteable able=0) {
        // TODO: if B64, must return number of bytes of raw (non encoded) message
        int res=0;
        uint32_t b=0;
        while ( (length>b) ) {
            if (IsTimedOut(timeout_clock)) {
                break;
            }
            if ( (able==0) ||
                 ((able!=0) && (CALL_MEMBER_FN(*this, able)())) ) {
                res = CALL_MEMBER_FN(*this, fcn)(data+b, length-b, timeout_clock);
                if (res<0) {
                    return b;
                } else {
                    b += res;
                }
            } else if (able!=0) {
#ifdef USE_RTOS
                Thread::wait(10);
#else
                wait_ms(10); // wait for readable/writeable
#endif
            }
        }
        return b; // timeout
    }
    /*
    template<class DATA, class SENDRECV>    
    int32_t DoIOInChunks(DATA data, const uint32_t length,
                         const uint32_t timeout_clock,
                         const uint16_t maxBufLen,
                         SENDRECV fcn) {
        // get/ship the data in chunks (since SBD limits incoming/outgoing messages)
        int32_t b=0, cl=0;
        while ( length>b ) {
            if (IsTimedOut(timeout_clock)) {
                break;
            }
            cl = (length-b);
            if (cl>maxBufLen) {
                cl = maxBufLen;
            }
#ifdef DEBUG
            printf("DoIOInChunks: call DoIO with b=%d, cl=%d\r\n",b,cl);
#endif
            b += DoIO<DATA>(data+b, cl, timeout_clock, fcn);
#ifdef DEBUG
            printf("DoIOInChunks: b=%d, length=%u\r\n",b,length);
#endif
        }
#ifdef DEBUG
        printf("DoIOInChunks: return %d\r\n",b);
#endif
        return b;
    }
    */
    bool    SerialReadable();
    bool    SerialWriteable();
    int32_t PutC(const char* const data, const uint32_t, const uint32_t);
    int32_t GetC(char* const data, const uint32_t, const uint32_t);
    int32_t SendBufferedSBD(const char* const data,
                            const uint32_t length,
                            const uint32_t timeout_clock);
    int32_t SendSBD(const char* const data, const uint32_t length, 
                    const uint32_t timeout_clock);
    int32_t RecvSBD(char* const data, const uint32_t length, 
                    const uint32_t timeout_clock);
    int32_t AtCmd(const char* const cmd,
                  const uint32_t timeout);
    int32_t AtResp(char* const res, const uint32_t rlen,
                   const uint32_t timeout);
    void     AppendRespTxt(std::string& str,
                           const uint32_t timeout,
                           const uint32_t maxslen);
    bool     AtRespContainsTxt(const char* const desired,
                               const uint32_t timeout,
                               std::string& str,
                               const char* until="\r\n",
                               const uint32_t maxslen=1024);
    bool    WaitForAtResponse(const char* const desired,
                              const uint32_t timeout,
                              const char* until="\r\n");
    bool    WaitForAtResponse(const char* const desired,
                              const uint32_t timeout,
                              std::string& str,
                              const char* until="\r\n");
    bool    WaitForAtResponses(const char* const desired,
                               const uint32_t timeout,
                               const char* until="\r\n");
    bool    WaitForAtResponses(const char* const desired,
                               const uint32_t timeout,
                               std::string& str,
                               const char* until="\r\n");
    void    EmptyRxBuffer(const uint32_t timeout);
    static
    uint16_t GetMsgNumFromHeader(const uint32_t hlen) {
        return (hlen>>16u);
    }
    static
    uint16_t GetMsgTotFromHeader(const uint32_t hlen) {
        return (hlen&0xFFFF);
    }
    static
    void    GetMsgNumTotFromHeader(const uint32_t hlen,
                                   uint16_t& mnum,
                                   uint16_t& mtot) {
        mnum = GetMsgNumFromHeader(hlen);
        mtot = GetMsgTotFromHeader(hlen);
    }
    uint32_t GetHeaderFromMsgNumTot(const bool isSending) const {
        uint32_t h = (isSending ? fSMsgNum : fRMsgNum);
        h <<= 16u;
        h  |= (isSending ? fSMsgTot : fRMsgTot);
        return h;
    }
    
 protected:
    virtual int32_t ReceiveAll(char* const buf, const uint32_t mlen,
                               const uint32_t timeout_clock);
    virtual int32_t SendAll(const char* const data, const uint32_t length,
                            const uint32_t timeout_clock);
    virtual int32_t FinishSending(const uint32_t timeout_clock);

 public:
    // Serial and MODSERIAL don't share virtual functions, so we MUST obtain
    // a pointer of type MODSERIAL if that's what we're using
    SnCommSBD(COMM_SERIALTYPE* sbdPort=0) :
        fSBD(sbdPort), fTxPos(0), fRxPos(0), fRxSiz(0),
        fRMsgNum(0), fRMsgTot(0), // essential that these start at 0!
        fSMsgNum(0), fSMsgTot(0) {
        
        memset(fRxBuf, 0, kRxBufSz*sizeof(char));
        memset(fTxBuf, 0, kTxBufSz*sizeof(char));
    }
    virtual ~SnCommSBD() {}
    
    virtual bool TrySetSysTimeUnix(const uint32_t timeout,
                                   uint32_t& prvTime,
                                   uint32_t& setTime);

    virtual bool CheckSignalStrength(const uint32_t timeout,
                                     float& sigstr);

    virtual bool Connect(const uint32_t timeout);
    
    virtual bool CloseConn(const uint32_t timeout) { 
        ClearSendReceiveBuffers();
        return true;
    }
    
    virtual bool PowerDown(const uint32_t);

    void         ClearSendReceiveBuffers() {
        fRxPos=0;
        fRxSiz=0;
        fRMsgNum=0;
        fRMsgTot=0;
        fSMsgNum=0;
        fSMsgTot=0;
        memset(fRxBuf, 0, kMaxRecv*sizeof(char));
    }
    
    static
    bool    ParseSBDSresp(const std::string& sr,
                          int32_t& mo, int32_t& momsn,
                          int32_t& mt, int32_t& mtmsn);

    static
    bool ParseSBDIXresp(const std::string& ixr,
                        int32_t& mo, int32_t& momsn,
                        int32_t& mt, int32_t& mtmsn,
                        int32_t& mtlen, int32_t& mtq);
    
    
};

#endif // ENABLE_SBD

#endif // SN_SnCommSBD
