/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Target board general functions implementation

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __BOARD_H__
#define __BOARD_H__

#include "Config.h"
#include "mbed.h"
#include "system/timer.h"
#include "system/utilities.h"
#include "sx1272-hal.h"
#include "XNucleoIKS01A2.h"

#ifdef USE_GROVE_SENSOR
// Grove temperature-humidity sensor
#include "driver_mbed_TH02.h"
#endif

#if defined ( TARGET_NUCLEO_L152RE )
/*!
 * Unique Devices IDs register set ( STM32L1xxx )
 */
#define         ID1                                 ( 0x1FF800D0 )
#define         ID2                                 ( 0x1FF800D4 )
#define         ID3                                 ( 0x1FF800E4 )

#elif defined ( TARGET_NUCLEO_F401RE )
/*!
 * Unique Devices IDs register set ( STM32F4xxx )
 */
#define         ID1                                 ( 0x1FFF7A10 )
#define         ID2                                 ( 0x1FFF7A14 )
#define         ID3                                 ( 0x1FFF7A18 )

#elif defined ( TARGET_NUCLEO_L073RZ )
/*!
 * Unique Devices IDs register set ( STM32L0xxx )
 */
#define         ID1                                 ( 0x1FF80050 )
#define         ID2                                 ( 0x1FF80054 )
#define         ID3                                 ( 0x1FF80064 )

#endif

#define LOW_BAT_THRESHOLD   3.45
#define AIN_VREF            3.3     // STM32 internal refernce
#define AIN_VBAT_DIV        2       // Resistor divider

extern SX1272MB2xAS Radio;

extern DigitalIn UsrButton;

extern DigitalOut Led;

/* Instantiate the expansion board */
extern XNucleoIKS01A2 *mems_expansion_board;
 
/* Retrieve the composing elements of the expansion board */
extern LSM303AGRMagSensor *magnetometer;
extern HTS221Sensor *hum_temp;
extern LPS22HBSensor *press_temp;
extern LSM6DSLSensor *acc_gyro;
extern LSM303AGRAccSensor *accelerometer;

/*!
 * \brief Initializes the target board peripherals.
 */
void BoardInit( void );

/*!
 * \brief Measure the Battery level
 *
 * \retval value  battery level ( 0: very low, 254: fully charged )
 */
uint8_t BoardGetBatteryLevel( void );

/*!
 * Returns a pseudo random seed generated using the MCU Unique ID
 *
 * \retval seed Generated pseudo random seed
 */
uint32_t BoardGetRandomSeed( void );

/*!
 * \brief Generates Lower 32 bits of DEVEUI using 96 bits unique device ID 
 *
 * \param [IN] id Pointer to an array that will contain the Unique ID
 */
void BoardGetDevEUI( uint8_t *id );

/*!
 * \brief Gets the board 64 bits unique ID 
 *
 * \param [IN] id Pointer to an array that will contain the Unique ID
 */
void BoardGetUniqueId( uint8_t *id );

#endif // __BOARD_H__
