/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: User-defined applications such as GPS, Temp, Accelerometer, LED indications etc.
            Event based actions such as LED blink on Tx, LED toggle on downlink etc

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#include "LoRaApp.h"

float sensor_data;

int32_t Accl_Value[3] = {0};


#ifdef USE_CAYENNE_LPP
/*
.... Pressure
.... Temperature
.... Humidity
.... Accelerometer
*/
uint8_t maxLPPsize[5] = {4, 4, 3, 8, 8};
#endif

bool VerticalStatus = false;


Application::Application( uint8_t * memptr )
{
    BuffAddr = memptr;
    memset( BuffAddr, 0, LORAWAN_APP_DATA_MAX_SIZE );
    BuffPtr = 0;    
}

Application::~Application( )
{
}

void Application::ApplicationAppendData( uint8_t *pData, uint8_t len )
{
    memcpy( BuffAddr + BuffPtr, pData, len );
    BuffPtr += len;
}

void Application::ApplicationPtrPos( uint8_t ptrPos )
{
    BuffPtr = ptrPos;
}

void Application::ApplicationCall( eAppType App )
{
    switch( App )
    {        
        // Appends 1 Byte to TX buffer
        case AppTemp:
        {   
                        
            hum_temp->get_temperature(&sensor_data);
                     
            printf("Temp = %f, %d\r\n", sensor_data, (int8_t) sensor_data);
                               
            if( ( BuffPtr + 1 ) <= LORAWAN_APP_DATA_SIZE )
            {
#ifdef USE_CAYENNE_LPP
                int16_t tmp_data = (int16_t) (sensor_data*10 + 0.5);
                BuffAddr[BuffPtr++] = (int8_t) ( ( tmp_data >> 8 ) & 0xFF );
                BuffAddr[BuffPtr++] = (int8_t) tmp_data & 0xFF;
#else                
                BuffAddr[BuffPtr++] = (int8_t) sensor_data;
#endif                
            }
                        
            break;
        }
        
        // Appends 2 Bytes to TX buffer
        case AppPressr:
        {                            
            press_temp->get_pressure(&sensor_data);
                                    
            printf("Pressure = %f, %d\r\n", sensor_data, (uint16_t) sensor_data);
                               
            if( ( BuffPtr + 2 ) <= LORAWAN_APP_DATA_SIZE )
            {
#ifdef USE_CAYENNE_LPP
                int16_t tmp;
                
                tmp =  (int16_t) ( sensor_data * 10 );
                BuffAddr[BuffPtr++] = ( tmp >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( tmp ) & 0xFF;
#else                
                BuffAddr[BuffPtr++] = ( (int16_t) sensor_data >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) sensor_data ) & 0xFF;
#endif                
            }
                 
            break;
        }
        
        // Appends 2 Bytes to TX buffer
        case AppHumid:
        {   
                                 
            hum_temp->get_humidity(&sensor_data);           
                                  
            printf("Humidity = %f, %d\r\n", sensor_data, (uint8_t) sensor_data);
                               
            if( ( BuffPtr + 1 ) <= LORAWAN_APP_DATA_SIZE )
            {
#ifdef USE_CAYENNE_LPP
                BuffAddr[BuffPtr++] = (uint8_t) ( sensor_data * 2 );
#else                
                BuffAddr[BuffPtr++] = (int8_t) sensor_data;
#endif                
            }
                        
            break;
        }
        
        // Appends 2 Bytes to TX buffer
        case AppGyro:
        {                  
            acc_gyro->get_g_axes(Accl_Value);         
                                  
            printf("Gyro X/Y/Z = %d/%d/%d\r\n", Accl_Value[0], Accl_Value[1], Accl_Value[2]);
                               
            if( ( BuffPtr + 6 ) <= LORAWAN_APP_DATA_SIZE )
            {
                Accl_Value[0] /= 10;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[0] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[0] ) & 0xFF; 
                Accl_Value[1] /= 10;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[1] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[1] ) & 0xFF; 
                Accl_Value[2] /= 10;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[2] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[2] ) & 0xFF;                                         
            }
                        
            break;
        }

        // Appends 1 Byte to TX buffer
        case AppBat:
        {  
            if( ( BuffPtr + 1 ) <= LORAWAN_APP_DATA_SIZE )
            {
                BuffAddr[BuffPtr++] = BoardGetBatteryLevel( );              // Per LoRaWAN spec; 0 = Charging; 1...254 = level, 255 = N/A
            }
            break;
        }

        // Appends incremental values of 1 Byte each to TX buffer until Full
        case AppRamp:
        {
            int32_t i, j;

            // Populate Tx Buffer with increasing byte values starting from 0x00, 0x01, 0x02 ... 
            for( i = BuffPtr, j = 0; i < LORAWAN_APP_DATA_SIZE; i++ )
            {
                BuffAddr[i] = j++;
            }
            BuffPtr = LORAWAN_APP_DATA_SIZE;
            break;
        }

        // Appends 2 Bytes to TX buffer
        case AppAccl:
        {  
                        
            accelerometer->get_x_axes(Accl_Value);
                                    
            printf("X/Y/Z = %d/%d/%d\r\n", Accl_Value[0], Accl_Value[1], Accl_Value[2]);
                               
            if( ( BuffPtr + 6 ) <= LORAWAN_APP_DATA_SIZE )
            {
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[0] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[0] ) & 0xFF; 
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[1] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[1] ) & 0xFF; 
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[2] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[2] ) & 0xFF; 
            }
                 
            break;
        }       

        case AppPushButton:
        {   
            static uint8_t PushButtonCnt = 0;

            PushButtonCnt = LoRaMacUplinkStatus.UplinkCounter;
            PushButtonCnt = (PushButtonCnt + 1) & 0xFF;
                
            //memcpy( &BuffAddr[BuffPtr], p, sizeof(uint16_t) );
            BuffAddr[BuffPtr] = PushButtonCnt;
            
            break;
        }

        default:
        {            
            break;
        }
    }
}

/*
static void OnRedLedTimerEvent( void )
{
    TimerStop( &RedLedTimer.LedTimer );

    if( RedLed == LED_OFF )
    {
        RedLed = LED_ON;
    }
    else
    {
        RedLed = LED_OFF;
    }
}

static void OnYellowLedTimerEvent( void )
{
    TimerStop( &YellowLedTimer.LedTimer );

    if( YellowLed == LED_OFF )
    {
        YellowLed = LED_ON;
    }
    else
    {
        YellowLed = LED_OFF;
    }
}

static void OnGreenLedTimerEvent( void )
{
    TimerStop( &GreenLedTimer.LedTimer );

    if( GreenLed == LED_OFF )
    {
        GreenLed = LED_ON;
    }
    else
    {
        GreenLed = LED_OFF;
    }
}

TimerLed::TimerLed( eLedType led )
{
    switch( led )
    {
        case Red:
        {
            TimerInit( &LedTimer, OnRedLedTimerEvent );
            break;
        }

        case Yellow:
        {
            TimerInit( &LedTimer, OnYellowLedTimerEvent );
            break;
        }

        case Green:
        {
            TimerInit( &LedTimer, OnGreenLedTimerEvent );
            break;
        }
    }
    
}
        
TimerLed::~TimerLed( )
{
}

void BlinkLED( eLedType led, uint32_t time )
{
    switch( led )
    {
        case Red:
        {
            TimerSetValue( &RedLedTimer.LedTimer, time );
            TimerStart( &RedLedTimer.LedTimer );
            RedLed = LED_ON;
            break;
        }

        case Yellow:
        {
            TimerSetValue( &YellowLedTimer.LedTimer, time );
            TimerStart( &YellowLedTimer.LedTimer );
            YellowLed = LED_ON;
            break;
        }

        case Green:
        {
            TimerSetValue( &GreenLedTimer.LedTimer, time );
            TimerStart( &GreenLedTimer.LedTimer );
            GreenLed = LED_ON;
            break;
        }
    }
}

void ToggleLED( eLedType led )
{
    switch( led )
    {
        case Red:
        {
            if( RedLed == LED_OFF )
            {
                RedLed = LED_ON;
            }
            else
            {
                RedLed = LED_OFF;
            }
            break;
        }

        case Yellow:
        {
            if( YellowLed == LED_OFF )
            {
                YellowLed = LED_ON;
            }
            else
            {
                YellowLed = LED_OFF;
            }
            break;
        }

        case Green:
        {
            if( GreenLed == LED_OFF )
            {
                GreenLed = LED_ON;
            }
            else
            {
                GreenLed = LED_OFF;
            }
            break;
        }
    }
}   

void CtrlLED( eLedType led, uint8_t state )
{
    switch( led )
    {
        case Red:
        {
            RedLed = state;
            break;
        }

        case Yellow:
        {
            YellowLed = state;
            break;
        }

        case Green:
        {
            GreenLed = state;
            break;
        }

        case Usr:
        {
            if( state )
            {
                UsrLed = LED_ON;
            }
            else
            {
                UsrLed = LED_OFF;
            }
            break;
        }
    }
}
*/
void CheckOrientation( void )
{
    /*
    uint8_t statusReg; 
    
    // Read the PS_STATUS register
    statusReg = Mma8451q.read_single( MMA8451_PL_STATUS );

     // If Orientation of the Mote changed then populate Upper Nibble of 0th Byte of Tx Buffer                       
    if( ( statusReg & 0x40 ) != 0 )
    {           
        CtrlLED( Green, LED_OFF );
        VerticalStatus = false; // horizontal
    }
    else
    {        
        CtrlLED( Green, LED_ON );
        VerticalStatus = true; // vertical
    } 
    */      
}