/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Process function calls from various Device states

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/
#ifndef __LORA_DEVICE_STATE_H__
#define __LORA_DEVICE_STATE_H__

#include "Common.h"
#include "board.h"
#include "LoRaMac.h"
#include "LoRaEventProc.h"
#include "SerialDisplay.h"
#include "mbed.h"
#include "LoRaMacLayerService.h"

/*!
 * Strucure containing the Uplink status
 */
struct sLoRaMacUplinkStatus
{
    /*!
     * MCPS-Request type
     */
    Mcps_t Type;    
    uint8_t Acked;
    int8_t Datarate;
    uint16_t UplinkCounter;
    uint8_t Port;
    uint8_t *Buffer;
    uint8_t BufferSize;
    int8_t TxPower;
};

/*!
 * Strucure containing the Downlink status
 */
struct sLoRaMacDownlinkStatus
{
    int16_t Rssi;
    int8_t Snr;
    uint16_t DownlinkCounter;
    bool RxData;
    uint8_t Port;
    uint8_t *Buffer;
    uint8_t BufferSize;
    uint8_t RxSlot;
};

/*!
 * Device states
 */
enum eDevicState
{
    DEVICE_STATE_INIT,
    DEVICE_STATE_JOIN,
    DEVICE_STATE_SEND,
    DEVICE_STATE_SLEEP
};

extern sLoRaMacUplinkStatus LoRaMacUplinkStatus;

extern sLoRaMacDownlinkStatus LoRaMacDownlinkStatus;

extern eDevicState DeviceState;

/*!
 * \brief Initialize Device: Timer, MAC Services, MAC
 */
void DeviceInit( void );

/*!
 * \brief Device Join update
 */
void DeviceJoinUpdate( void );

/*!
 * \brief OTA: if device not joined, send JOIN REQUEST to network
 *      ABP: Request DevAddr if not already set
 */
void DeviceJoin( void );

/*!
 * \brief   Prepares the payload of the frame to be transmitted
 *
 * \param [IN] port application port corresponding to which payload is generated
 */
void PrepareTxFrame( uint8_t port );

/*!
 * \brief   Send the frame
 *
 */
bool SendFrame( void );

#endif // __LORA_DEVICE_STATE_H__