/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device communication parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#ifndef __LORA_CONFIG_H__
#define __LORA_CONFIG_H__

/*!
 * Configure End-Device to use 8-channels corresponding to Block A
 * Comment/Uncomment to disable/enable Hybrid mode
 */
#define USE_BAND_915_HYBRID

#ifndef USE_BAND_915_HYBRID
/*!
 * Configure End-Device to use 64-channels across to Block A thru Block H
 */
#define USE_BAND_915

#else

// define channel block: e.g. USE_BAND_915_HYBRID_BLOCK_A, USE_BAND_915_HYBRID_BLOCK_B ... USE_BAND_915_HYBRID_BLOCK_H etc.
#define USE_BAND_915_HYBRID_BLOCK_A

#endif

/*!
 * Join requests trials periodicity. It is the time between RX1/RX2 and next TX
 */
#define OVER_THE_AIR_ACTIVATION_DUTYCYCLE           5000000  // value in us

/*!
 * Defines the application data transmission periodicity. It is the time between RX1/RX2 and next TX
 */
#define APP_TX_DUTYCYCLE                            6000000  // value in us

/*!
 * Defines the randomness in the dutycycle. 
 */
#define APP_TX_DUTYCYCLE_RND                        3000000

/*!
 * LoRaWAN confirmed messages
 * \remark 1 : Confirmed messages enabled. Must receive ACK from network server
           0 : Confirmed messages disabled. 
 */
#define LORAWAN_CONFIRMED_MSG_ON                    1

/*!
 * LoRaWAN Adaptive Data Rate
 *
 * \remark Please note that when ADR is enabled the end-device uses default datarate of DR_0
 */
#define LORAWAN_ADR_ON                              0

/*!
 * Default mote datarate
 * \remark DR_0 : 980 bps; DR_1 : 1760 bps; DR_2 : 3125 bps; DR_3 : 5470 bps; DR_4 : 12500 bps
 */
#define LORAWAN_DEFAULT_DATARATE                    DR_0

/*!
 * LoRaWAN application port
 */
#define LORAWAN_APP_PORT                            5

/*!
 * LoRaWAN User defined Tx Power
 *
 * \remark The Tx power level is set as TX_POWER_P_DBM, where 10 <= P <= 30 and P is even value { i.e. P = 10, 12, 14 ... 28 or 30 }
 */
#define LORAWAN_TX_POWER                            TX_POWER_10_DBM

#if ( LORAWAN_APP_PORT == 5 )
/*====================================================
            US01 GPS APPLICATION DEMO (PORT 5)
====================================================*/

/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_SIZE                       11

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#elif ( LORAWAN_APP_PORT == 8 )
/*====================================================
                IKS01A1 SENSOR DATA (PORT 8)
====================================================*/

#define USE_IKS01A1_SENSOR
/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_SIZE                       11

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#elif ( LORAWAN_APP_PORT == 9 )
/*====================================================
    IKS01A1 SENSOR DATA (PORT 9) + CAYENNE LPP
====================================================*/

#define USE_IKS01A1_SENSOR

#define USE_CAYENNE_LPP
/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_SIZE                       11

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#elif ( LORAWAN_APP_PORT == 11 )
/*====================================================
                PUSH BUTTON DEMO (PORT 11)
====================================================*/

/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_SIZE                       2

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#elif ( LORAWAN_APP_PORT == 12 )
/*====================================================
                GROVE SENSOR DEMO (PORT 11)
====================================================*/

#define USE_GROVE_SENSOR

#define USE_CAYENNE_LPP

/*!
 * User application data buffer size
 */
#define LORAWAN_APP_DATA_SIZE                       7

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#endif

#endif //  __LORA_CONFIG_H__
