/*

    MAX7314.hpp

    Library include file for the MAX7314 16-bit I/O Expander with PWM

    Tom Gambone
    Chad Joppeck

    Based on code by mBed user: "Ale C.-" / Suky (PCA9538_Expander Library)

    4/13/2011 - Initial porting

*/

#include "mbed.h"

enum ExpPinName {
    exp_p0=0,
    exp_p1,
    exp_p2,
    exp_p3,
    exp_p4,
    exp_p5,
    exp_p6,
    exp_p7,
    exp_p8,
    exp_p9,
    exp_p10,
    exp_p11,
    exp_p12,
    exp_p13,
    exp_p14,
    exp_p15,
};


//*****************************************************************************


class MAX7314_OutputPin {

public:
    MAX7314_OutputPin(ExpPinName Pin,PinName PIN_SDA,PinName PIN_SCL,unsigned char Address);
    void vWrite(int value);
    int read();
#ifdef MBED_OPERATORS
    MAX7314_OutputPin& operator= (int value);
    operator int();
#endif
protected:
    ExpPinName _Pin;
    unsigned char _Address;
    I2C Bus;
};



//*****************************************************************************



class MAX7314_InputPin {

public:
    MAX7314_InputPin(ExpPinName Pin,PinName PIN_SDA,PinName PIN_SCL,unsigned char Address);
    int read();
#ifdef MBED_OPERATORS
    operator int();
#endif
protected:
    ExpPinName _Pin;
    unsigned char _Address;
    I2C Bus;
};



//*****************************************************************************



class MAX7314 {

public:
    MAX7314(PinName PIN_SDA,PinName PIN_SCL,unsigned char Address,PinName PIN_INT=NC);
    void vInit(unsigned char Dir,void (*fptr)(void));
    void vSetConfiguration(unsigned char Dir);
    void vSetPolarity(unsigned char Pol);
    unsigned char cRead(void);
    void vWrite(unsigned char Data);
    void vEnableSetInterrupt(void (*fptr)(void));
    void vDisableInterrupt(void);
    bool bReadPinINT(void);
protected:
    I2C Bus;
    InterruptIn MAX7314_Event;
    DigitalIn _PIN_INT;
    unsigned char _Address;
};
