/*

    MAX7314.cpp

    Library implementation file for the MAX7314 16-bit I/O Expander with PWM

    Tom Gambone
    Chad Joppeck

    Based on code by mBed user: "Ale C.-" / Suky (PCA9538_Expander Library)

    4/13/2011 - Initial porting

*/

#include "mbed.h"




//*****************************************************************************



MAX7314_OutputPin::MAX7314_OutputPin(ExpPinName Pin,PinName PIN_SDA,PinName PIN_SCL,unsigned char Address)
        :Bus(PIN_SDA,PIN_SCL),_Pin(Pin),_Address(Address<<1) {

    unsigned char Temp;

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x03);
    Bus.start();
    Bus.write(_Address | 0x01);
    Temp=Bus.read(0);
    Bus.stop();

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x03);
    Bus.write((~(0x01<<_Pin))&Temp);
    Bus.stop();
}

void MAX7314_OutputPin::vWrite(int value) {
    unsigned char Temp;

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x01);
    Bus.start();
    Bus.write(_Address | 0x01);
    Temp=Bus.read(0);
    Bus.stop();

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x01);
    if (value==0) {
        Bus.write((~(0x01<<_Pin))&Temp);
    } else {
        Bus.write((0x01<<_Pin)|Temp);
    }
    Bus.stop();
}

int MAX7314_OutputPin::read() {
    unsigned char Temp;

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x01);
    Bus.start();
    Bus.write(_Address | 0x01);
    Temp=Bus.read(0);
    Bus.stop();

    return((Temp>>_Pin)&0x01);
}

MAX7314_OutputPin& MAX7314_OutputPin::operator= (int value) {
    vWrite(value);
}

MAX7314_OutputPin::operator int() {

    return(read());
}



//*****************************************************************************



MAX7314_InputPin::MAX7314_InputPin(ExpPinName Pin,PinName PIN_SDA,PinName PIN_SCL,unsigned char Address)
        :Bus(PIN_SDA,PIN_SCL),_Pin(Pin),_Address(Address<<1) {
    unsigned char Temp;

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x03);
    Bus.start();
    Bus.write(_Address | 0x01);
    Temp=Bus.read(0);
    Bus.stop();

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x03);
    Bus.write((0x01<<_Pin)|Temp);
    Bus.stop();
}

int MAX7314_InputPin::read() {
    unsigned char Temp;

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x00);
    Bus.start();
    Bus.write(_Address | 0x01);
    Temp=Bus.read(0);
    Bus.stop();

    return((Temp>>_Pin)&0x01);
}

MAX7314_InputPin::operator int() {

    return(read());
}



//*****************************************************************************



MAX7314::MAX7314(PinName PIN_SDA,PinName PIN_SCL,unsigned char Address,PinName PIN_INT)
        : Bus(PIN_SDA,PIN_SCL),_PIN_INT(PIN_INT),MAX7314_Event(PIN_INT) {
    _Address=Address<<1;
}

void MAX7314::vInit(unsigned char Dir,void (*fptr)(void)) {

    //Bus.frequency(400000);

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x03);
    Bus.write(Dir);
    Bus.stop();

    if (fptr!=NULL) {
        MAX7314_Event.fall(fptr);
    }
}

void MAX7314::vSetConfiguration(unsigned char Dir) {

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x03);
    Bus.write(Dir);
    Bus.stop();
}

void MAX7314::vSetPolarity(unsigned char Pol) {

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x02);
    Bus.write(Pol);
    Bus.stop();
}

unsigned char MAX7314::cRead(void) {
    unsigned char Temp;

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x00);
    Bus.start();
    Bus.write(_Address | 0x01);
    Temp=Bus.read(0);
    Bus.stop();

    return(Temp);
}

void MAX7314::vWrite(unsigned char Data) {

    Bus.start();
    Bus.write(_Address & 0xFE);
    Bus.write(0x01);
    Bus.write(Data);
    Bus.stop();
}

void MAX7314::vEnableSetInterrupt(void (*fptr)(void)) {
    MAX7314_Event.fall(fptr);
}

void MAX7314::vDisableInterrupt(void) {
    MAX7314_Event.fall(NULL);
}

bool MAX7314::bReadPinINT(void) {
    return(_PIN_INT);
}
