#include "mbed.h"                              // mbed 헤더파일 선언
#include "DHT.h"                               // DHT(온습도센서) 헤더파일 선언

void FND_Output(char Select, char Number);     // FND 한자리수 출력함수
void Number_Output(int Number);                // FND 두자리수 출력함수
void Read_Sensor1 (void);                      // 온도, 습도센서 데이터 Read함수
void Read_Sensor2 (void);                      // 미세먼지센서 데이터 Read함수

InterruptIn button(USER_BUTTON);               // 버튼 인터럽트(입력) 선언
Ticker Timer1;                                 // 타이머 선언
AnalogIn analog_value(A1);                     // ADC Read(A1) 선언
DHT dht(D3,DHT11);                             // 온도, 습도센서 D3핀, DHT11모듈 선언

DigitalOut LED_0(D0);                          // LED D0번핀 출력선언
DigitalOut LED_1(D1);                          // LED D1번핀 출력선언
DigitalOut LED_2(D2);                          // LED D2번핀 출력선언
DigitalOut iled(A0);                           // 미세먼지 센서 내부 LED 출력선언
DigitalOut FND0(D7);                           // FND 1번째 LED 출력선언
DigitalOut FND1(D8);                           // FND 2번째 LED 출력선언
DigitalOut FND2(D9);                           // FND 3번째 LED 출력선언
DigitalOut FND3(D10);                          // FND 4번째 LED 출력선언
DigitalOut FND4(D11);                          // FND 5번째 LED 출력선언
DigitalOut FND5(D12);                          // FND 6번째 LED 출력선언
DigitalOut FND6(D13);                          // FND 7번째 LED 출력선언
DigitalOut FND_Select0(D14);                   // 첫번째 FND 출력선언
DigitalOut FND_Select1(D15);                   // 두번째 FND 출력선언


uint8_t FND_DATA[10] = {0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x27,0x7F,0x6F};     // FND DATA값 {0,1,2,3,4,5,6,7,8,9}
float Buffer[10] = {0, };                                                       // 미세먼지센서 데이터 값 평균내기 위한 10개의 배열
uint8_t mybutton = 0;                                                           // 버튼 상태값 0:온도값, 1:습도값, 2:미세먼지값
int temperature = 0;                                                            // 온도값 데이터 변수
int humidity = 0;                                                               // 습도값 데이터 변수
float Dust = 0;                                                                 // 미세먼지값 데이터 변수
int delay_count = 0;                                                            // 데이터 수신을 너무자주 하는것을 막기  위한 Counter변수

void pressed()  // 버튼 외부 인터럽트 Falling edge(눌렀다 땟을 때)
{
    if(mybutton != 2) // 버튼값이 2가 아니면 플러스
        mybutton ++;
    else              // 버튼값이 2일경우 0으로 초기화
        mybutton = 0;
}

void Time_Out()       // 10ms마다 한번씩 동작하는 함수
{
        if (mybutton == 0) //버튼값이 0일 경우
        {
            Number_Output(temperature%100); //FND에 
            LED_0 = 1; // 1번 LED(D0) ON
            LED_1 = 0; // 2번 LED(D1) OFF
            LED_2 = 0; // 3번 LED(D2) OFF
        }
        else if(mybutton == 1) // 버튼값이 1일 경우
        {
            Number_Output(humidity%100);
            LED_0 = 0; // 1번 LED(D0) OFF
            LED_1 = 1; // 2번 LED(D1) ON
            LED_2 = 0; // 3번 LED(D2) OFF
        } 
        else if(mybutton == 2) // 버튼값이 2일 경우
        {
            Number_Output((int)Dust%100);
            LED_0 = 0; // 1번 LED(D0) OFF
            LED_1 = 0; // 2번 LED(D1) OFF
            LED_2 = 1; // 3번 LED(D2) ON
        }
}
    
int main() //메인루프
{
    button.fall(&pressed);               // 인터럽트 Falling edge로 동작하도록 설정 (pressed() 함수)
    Timer1.attach_us(&Time_Out,10000);   // 타이머 10ms마다 함수 동작하도록 설정 (Time_Out() 함수)
    while(1)                   // main문 무한루프
    {
        delay_count++;
        if(delay_count == 10)  // 10번 카운트 이후 동작하도록 (delay용도)
        {
            delay_count = 0;   // 카운터 초기화
            Read_Sensor1();    // 온도, 습도센서 데이터 Read 함수
            Read_Sensor2();    // 미세먼지센서 데이터 Read 함수
        }
    }
}

void FND_Output(char Select, char Number)  // FND 1개 출력하는 함수 ex) FND_Output(0,1); 일 경우 0번째 FND에 "1" 출력
{
    FND0 = FND_DATA[Number] & 0b00000001;  // FND 첫번째 LED 출력
    FND1 = FND_DATA[Number] & 0b00000010;  // FND 두번째 LED 출력
    FND2 = FND_DATA[Number] & 0b00000100;  // FND 세번째 LED 출력
    FND3 = FND_DATA[Number] & 0b00001000;  // FND 네번째 LED 출력
    FND4 = FND_DATA[Number] & 0b00010000;  // FND 다섯번째 LED 출력
    FND5 = FND_DATA[Number] & 0b00100000;  // FND 여섯번째 LED 출력
    FND6 = FND_DATA[Number] & 0b01000000;  // FND 일곱번째 LED 출력
    
    if(Select == 0) // Select 0일 경우
    {
        FND_Select0 = 0; // 0값일 경우 Ground로 변해서 해당 FND 켜짐
        FND_Select1 = 1; // 0값일 경우 Ground로 변해서 해당 FND 켜짐
    }
    else            // Select 1일 경우
    {
        FND_Select0 = 1; // 0값일 경우 Ground로 변해서 해당 FND 켜짐
        FND_Select1 = 0; // 0값일 경우 Ground로 변해서 해당 FND 켜짐
    }
}

void Number_Output(int Number) // FND 2자리 숫자 출력하는 함수
{
    FND_Output(0,Number/10);   // Number의 10의자리 숫자 0번째 FND에 출력
        wait_ms(2); // 2ms delay 짧은시간 FND를 켜서 잔상효과로 2개의 FND가 켜진것처럼 보임
    FND_Output(1,Number%10);   // Number의 10의자리 숫자 0번째 FND에 출력
        wait_ms(1); // 1ms delay 짧은시간 FND를 켜서 잔상효과로 2개의 FND가 켜진것처럼 보임
}

void Read_Sensor1 (void)        // 온도, 습도센서 데이터 Read 함수
{        
    int error = dht.readData(); // 센서 데이터 읽기
    if(error == ERROR_NONE)     // 센서 데이터 읽기 성공(에러 없을시)
    {
        temperature = dht.ReadTemperature(CELCIUS); // 온도 데이터 Read
        humidity = dht.ReadHumidity();              // 습도 데이터 Read
    }
}

void Read_Sensor2 (void)      // 미세먼지 센서 데이터 Read
{
    float meas_r;             // 미세먼지 데이터 변수 (0~1 값)
    float meas_v;             // 미세먼지 데이터 변수 (변환한 데이터 값)
    
    iled = 1;                        // 미세먼지 센서의 내부 LED ON
    wait_us(280);                    // 미세먼지센서 데이터를 받기위해 내부 LED를 킨 후 280us 이후 데이터 읽기
    meas_r = analog_value.read();    // 3.3V를 0~1 값으로 Read ex) 1.65V 일경우 0.5
    wait_us(40);                     // 40us의 안전시간 이후
    iled = 0;                        // 미세먼지센서 내부 LED OFF
    if(meas_r < 0.1f)                // 측정한 데이터 값이 0.1보다 작을 경우 잘못 읽힌 데이터로 판단
    {
        return;                      // return;
    }
    meas_v = meas_r * 3300 * 0.2f;   // 0~1의 값에 3300을 곱하여 mV 단위로 변환, mV 단위에 0.2를 곱하여 미세먼지 센서 모듈의 특성을 반영
    meas_v = meas_v /10;             // 백단위까지 값이 나오는 미세먼지 결과값의 백,십의 자리만 표시하기 위해 나누기 10
    for(int i = 0 ; i < 10 ; i++)    // 10번 반복 (10번 읽어들인 데이터 값을 평균내기 위함, 노이즈가 많은 센서이기 때문)
    {
        Buffer[i] = Buffer[i+1];     // 10개의 버퍼를 싀프트
        Dust = Dust + Buffer[i];     // Buffer에 있는 10개의 데이터를 모두 더함
    }
    Buffer[9] = meas_v;              // Buffer의 마지막주소에 읽어들인 값을 저장
    Dust = Dust/10;                  // 10개를 모두 더한 값을 평균 내기위해 나누기 10
}