#ifndef APPLICATION_USER_RLNDIS_USBD_DESC2_H
#define APPLICATION_USER_RLNDIS_USBD_DESC2_H

#include <stdint.h>
#include <stddef.h>
#include <stdio.h>

//#define WITHDEBUG	1

#define WITHUSBHW	1
//#define WITHUSBUAC		1	/* использовать виртуальную звуковую плату на USB соединении */
//#define WITHUSBUAC3		1	/* формируются три канала передачи звука */
//#define WITHUABUACOUTAUDIO48MONO	1	/* для уменьшения размера буферов в endpoints */

#define WITHUSBRNDIS	1	/* RNDIS использовать Remote NDIS на USB соединении */
#define WITHUSBCDCECM	1	/* ECM использовать Ethernet Control Model на USB соединении */

//#define WITHUSBCDC		1	/* ACM использовать виртуальный последовательный порт на USB соединении */
//#define WITHUSBCDCEEM	1	/* EEM использовать Ethernet Emulation Model на USB соединении */
//#define WITHUSBHID	1	/* HID использовать Human Interface Device на USB соединении */

#define WITHPLAINDESCROPTOR 0	/* один configuration descriptor с составным устройством */

#if WITHPLAINDESCROPTOR

	#if WITHUSBUAC
		#if WITHUSBUAC3
			//#define INTERFACE_UAC_count 2	/* количество интерфейсов в одном UAC */
		#else /* WITHUSBUAC3 */
			#define INTERFACE_UAC_count 3	/* количество интерфейсов в одном UAC */
		#endif /* WITHUSBUAC3 */
	#endif /* WITHUSBUAC */

	/* Последовательность в данном enum должна соответствовать порядку использования в fill_Configuration_main_group */
	enum
	{

	#if WITHUSBRNDIS
		INTERFACE_RNDIS_CONTROL_5,	/* RNDIS control Interface */
		INTERFACE_RNDIS_DATA_6,		/* RNDIS data Interface */
	#endif /* WITHUSBRNDIS */

	#if WITHUSBUAC
		#if WITHUSBUAC3
			INTERFACE_AUDIO_CONTROL_0,		/* AUDIO transmitter input control interface */
			INTERFACE_AUDIO_SPK_1,			/* USB Speaker Standard AS Interface Descriptor - Audio Streaming Zero Bandwith */
			INTERFACE_AUDIO_MIKE_2,		/* USB receiver output  Standard AS Interface Descriptor (Alt. Set. 0) (CODE == 3)*/ //zero-bandwidth interface
			/* */INTERFACE_AUDIO_CONTROL_1,		/* AUDIO spectrum control interface */
			INTERFACE_AUDIO_RTS_3,		/* USB spectrum Standard AS Interface Descriptor (Alt. Set. 0) (CODE == 3)*/ //zero-bandwidth interface
			//INTERFACE_AUDIO_last = INTERFACE_AUDIO_CONTROL_0 + 3,
		#else
			INTERFACE_AUDIO_CONTROL_0,		/* AUDIO control interface */
			INTERFACE_AUDIO_SPK_1,		/* USB Speaker Standard AS Interface Descriptor - Audio Streaming Zero Bandwith */
			INTERFACE_AUDIO_MIKE_2,		/* USB Microphone Standard AS Interface Descriptor (Alt. Set. 0) (CODE == 3)*/ //zero-bandwidth interface
			//INTERFACE_AUDIO_last = INTERFACE_AUDIO_CONTROL_0 + 2,
		#endif
	#endif /* WITHUSBUAC */

	#if WITHUSBCDC
		INTERFACE_CDC_base,
		INTERFACE_CDC_CONTROL_3a = INTERFACE_CDC_base,	/* CDC ACM control Interface */
		INTERFACE_CDC_DATA_4a,		/* CDC ACM data Interface */
		INTERFACE_CDC_CONTROL_3b,	/* CDC ACM control Interface */
		INTERFACE_CDC_DATA_4b,		/* CDC ACM data Interface */
		INTERFACE_CDC_last = INTERFACE_CDC_base + WITHUSBHWCDC_N * 2 - 1,
	#endif /* WITHUSBCDC */

	#if WITHUSBCDCEEM
		INTERFACE_CDCEEM_DATA_6,	/* CDC ECM/CDC EEM data Interface */
	#endif /* WITHUSBCDCEEM */

	#if WITHUSBCDCECM
		INTERFACE_CDCECM_CONTROL_5,	/* CDC ECM control Interface */
		INTERFACE_CDCECM_DATA_6,	/* CDC ECM/CDC EEM data Interface */
	#endif /* WITHUSBCDCECM */

	#if WITHUSBHID
		INTERFACE_HID_CONTROL_7,	/* HID control Interface */
	#endif /* WITHUSBHID */
		//
		INTERFACE_COMPOSITE_count				/* Значение для configuration descriptor */
	};

	#define INTERFACE_CDCACM_count 2	/* количество интерфейсов в одном CDC */
	#define INTERFACE_CDCEEM_count 1	/* количество интерфейсов в одном CDC EEM */
	#define INTERFACE_CDCECM_count 2	/* количество интерфейсов в одном CDC EEM */
	#define INTERFACE_HID_count 1	/* количество интерфейсов в одном HID */
	#define INTERFACE_RNDIS_count 2	/* количество интерфейсов в одном RNDIS */

	enum
	{
		RNDIS_cfgidx = 1,
		CDCECM_cfgidx = 1
	};

#else /* WITHPLAINDESCROPTOR */

	#if WITHUSBUAC
		#if WITHUSBUAC3
			//#define INTERFACE_UAC_count 2	/* количество интерфейсов в одном UAC */
		#else /* WITHUSBUAC3 */
			#define INTERFACE_UAC_count 3	/* количество интерфейсов в одном UAC */
		#endif /* WITHUSBUAC3 */
	#endif /* WITHUSBUAC */

#if WITHUSBRNDIS
	enum
	{
		INTERFACE_RNDIS_CONTROL_5,	/* RNDIS control Interface */
		INTERFACE_RNDIS_DATA_6,		/* RNDIS data Interface */
	};
#endif /* WITHUSBRNDIS */

#if WITHUSBUAC
	enum
	{
		#if WITHUSBUAC3
			INTERFACE_AUDIO_CONTROL_0,		/* AUDIO transmitter input control interface */
			INTERFACE_AUDIO_SPK_1,			/* USB Speaker Standard AS Interface Descriptor - Audio Streaming Zero Bandwith */
			INTERFACE_AUDIO_MIKE_2,		/* USB receiver output  Standard AS Interface Descriptor (Alt. Set. 0) (CODE == 3)*/ //zero-bandwidth interface
			/* */INTERFACE_AUDIO_CONTROL_1,		/* AUDIO spectrum control interface */
			INTERFACE_AUDIO_RTS_3,		/* USB spectrum Standard AS Interface Descriptor (Alt. Set. 0) (CODE == 3)*/ //zero-bandwidth interface
			//INTERFACE_AUDIO_last = INTERFACE_AUDIO_CONTROL_0 + 3,
		#else
			INTERFACE_AUDIO_CONTROL_0,		/* AUDIO control interface */
			INTERFACE_AUDIO_SPK_1,		/* USB Speaker Standard AS Interface Descriptor - Audio Streaming Zero Bandwith */
			INTERFACE_AUDIO_MIKE_2,		/* USB Microphone Standard AS Interface Descriptor (Alt. Set. 0) (CODE == 3)*/ //zero-bandwidth interface
			//INTERFACE_AUDIO_last = INTERFACE_AUDIO_CONTROL_0 + 2,
		#endif
	};
#endif /* WITHUSBUAC */
#if WITHUSBCDC
	enum
	{
		INTERFACE_CDC_base,
		INTERFACE_CDC_CONTROL_3a = INTERFACE_CDC_base,	/* CDC ACM control Interface */
		INTERFACE_CDC_DATA_4a,		/* CDC ACM data Interface */
		INTERFACE_CDC_CONTROL_3b,	/* CDC ACM control Interface */
		INTERFACE_CDC_DATA_4b,		/* CDC ACM data Interface */
		INTERFACE_CDC_last = INTERFACE_CDC_base + WITHUSBHWCDC_N * 2 - 1,
	};
#endif /* WITHUSBCDC */
#if WITHUSBCDCEEM
	enum
	{

		INTERFACE_CDCEEM_DATA_6,	/* CDC ECM/CDC EEM data Interface */
	};
#endif /* WITHUSBCDCEEM */
#if WITHUSBCDCECM
	enum
	{
		INTERFACE_CDCECM_CONTROL_5,	/* CDC ECM control Interface */
		INTERFACE_CDCECM_DATA_6,	/* CDC ECM/CDC EEM data Interface */
	};
	#endif /* WITHUSBCDCECM */
#if WITHUSBHID
	enum
	{
		INTERFACE_HID_CONTROL_7,	/* HID control Interface */
		//
	};
#endif /* WITHUSBHID */


	#define INTERFACE_CDCACM_count 2	/* количество интерфейсов в одном CDC */
	#define INTERFACE_CDCEEM_count 1	/* количество интерфейсов в одном CDC EEM */
	#define INTERFACE_CDCECM_count 2	/* количество интерфейсов в одном CDC ECM */
	#define INTERFACE_HID_count 1	/* количество интерфейсов в одном HID */
	#define INTERFACE_RNDIS_count 2	/* количество интерфейсов в одном RNDIS */

	enum
	{
		UNUSED_cfgidx = 0,
		//
		RNDIS_cfgidx,
		CDCECM_cfgidx,
		//
		UNUSED2_cfgidx
	};

#endif /* WITHPLAINDESCROPTOR */

//#define INTERFACE_UAC_count (INTERFACE_AUDIO_last - INTERFACE_AUDIO_CONTROL_0)

// STM32F429:
//	valid EPs: dcp, 0x01/0x81, 0x02/0x82, 0x03/0x83
// STM32F446, STM32F746:
//	valid EPs: dcp, 0x01/0x81, 0x02/0x82, 0x03/0x83, 0x04/0x84, 0x05/0x85


#if WITHUSBUAC
	#if WITHUSBUAC3

		#define WITHUSBHWCDC_N	2	// количество виртуальных последовательных портов

	#else /* WITHUSBUAC3 */

		#define WITHUSBHWCDC_N	2	// количество виртуальных последовательных портов

	#endif /* WITHUSBUAC3 */
#endif /* WITHUSBUAC */

#if ! defined (WITHUSBHWCDC_N)
	#define WITHUSBHWCDC_N	2	// количество виртуальных последовательных портов
#endif /* ! defined (WITHUSBHWCDC_N) */


// IN and INT Endpoints allocation
enum
{
	ep0inxxx = 0x80,

#if WITHUSBRNDIS
	RNDIS_NOTIFICATION_IN_EP,
	RNDIS_DATA_IN_EP,
#endif /* WITHUSBRNDIS */

#if WITHUSBUAC
	#if WITHUSBUAC3
		USBD_EP_AUDIO_IN,	// ISOC IN Аудиоданные в компьютер из TRX
		USBD_EP_RTS_IN,	// ISOC IN Аудиоданные в компьютер из TRX
	#else
		USBD_EP_AUDIO_IN,	// ISOC IN Аудиоданные в компьютер из TRX
	#endif
#endif /* WITHUSBUAC */

#if WITHUSBCDC
	USBD_EP_CDC_IN,		// CDC IN Данные ком-порта в компьютер из TRX
	USBD_EP_CDC_INb,	// CDC IN Данные ком-порта в компьютер из TRX
	USBD_EP_CDC_INlast = USBD_EP_CDC_IN + WITHUSBHWCDC_N - 1,

	USBD_EP_CDC_INT,	// CDC INT События ком-порта в компьютер из TRX
	USBD_EP_CDC_INTb,	// CDC INT События ком-порта в компьютер из TRX
	USBD_EP_CDC_INTlast = USBD_EP_CDC_INT + WITHUSBHWCDC_N - 1,
#endif /* WITHUSBCDC */

#if WITHUSBCDCEEM
	USBD_EP_CDCEEM_IN,	// CDC IN Данные ком-порта в компьютер из TRX
#endif /* WITHUSBCDCEEM */

#if WITHUSBCDCECM
	USBD_EP_CDCECM_IN,	// CDC IN Данные ком-порта в компьютер из TRX
	USBD_EP_CDCECM_INT,	// CDC INT События ком-порта в компьютер из TRX
#endif /* WITHUSBCDCECM */

#if WITHUSBHID
	//USBD_EP_HIDMOUSE_INT,	// HID INT События манипулятора в компьютер из TRX
#endif /* WITHUSBHID */

	//
	epincount
};

// OUT Endpoints allocation
enum
{
	ep0outxxx = 0x00,

#if WITHUSBRNDIS
	RNDIS_DATA_OUT_EP,
#endif /* WITHUSBRNDIS */

#if WITHUSBUAC
	#if WITHUSBUAC3
		USBD_EP_AUDIO_OUT,
	#else
		USBD_EP_AUDIO_OUT,	// ISOC OUT Аудиоданные от компьютера в TRX
	#endif
#endif /* WITHUSBUAC */

#if WITHUSBCDC
	USBD_EP_CDC_OUT,	// CDC OUT Данные ком-порта от компьютера в TRX
	USBD_EP_CDC_OUTb,	// CDC OUT Данные ком-порта от компьютера в TRX
	USBD_EP_CDC_OUTlast = USBD_EP_CDC_OUT + WITHUSBHWCDC_N - 1,
#endif /* WITHUSBCDC */

#if WITHUSBCDCEEM
	USBD_EP_CDCEEM_OUT,	// CDC OUT Данные ком-порта от компьютера в TRX
#endif /* WITHUSBCDCEEM */

#if WITHUSBCDCECM
	USBD_EP_CDCECM_OUT,	// CDC OUT Данные ком-порта от компьютера в TRX
#endif /* WITHUSBCDCECM */

#if WITHUSBHID
#endif /* WITHUSBHID */
	//
	epoutcount
};

//#if WITHUSBCDC
	#define VIRTUAL_COM_PORT_INT_SIZE 			10
	#define VIRTUAL_COM_PORT_DATA_SIZE			64
//#endif /* WITHUSBCDC */

//#if WITHUSBHID
	#define HIDMOUSE_INT_DATA_SIZE 4
//#endif /* WITHUSBHID */

//#if WITHUSBCDCEEM
	#define USBD_CDCEEM_BUFSIZE	64
//#endif /* WITHUSBCDCEEM */

//#if WITHUSBCDCECM
	#define CDCECM_NOTIFICATION_IN_SZ                        16
	#define CDCECM_DATA_IN_SZ                                64
	#define CDCECM_DATA_OUT_SZ                               64
//#endif /* WITHUSBCDCECM */

//#if WITHUSBRNDIS
	#define RNDIS_NOTIFICATION_IN_SZ                        8
	#define RNDIS_DATA_IN_SZ                                64
	#define RNDIS_DATA_OUT_SZ                               64
//#endif /* WITHUSBRNDIS */

#define HSINTERVAL_AUDIO48 4	// endpoint descriptor parameters - для обеспечсения 1 кГц периода
#define FSINTERVAL_AUDIO48 1

#define HSINTERVAL_32MS 9	// endpoint descriptor parameters - для обеспечсения 1 кГц периода
#define FSINTERVAL_32MS 32

struct descholder
{
	const uint8_t * data;
	unsigned size;
};

#define USBD_NCONFIGS 4

extern struct descholder StringDescrTbl [];
extern struct descholder ConfigDescrTbl [USBD_NCONFIGS];
extern struct descholder DeviceDescrTbl [USBD_NCONFIGS];
extern struct descholder DeviceQualifierTbl [USBD_NCONFIGS];
extern struct descholder OtherSpeedConfigurationTbl [USBD_NCONFIGS];
extern struct descholder BinaryDeviceObjectStoreTbl [1];
extern struct descholder HIDReportDescrTbl [1];

uint_fast8_t usbd_get_stringsdesc_count(void);

void usbd_descriptors_initialize(uint_fast8_t HSdesc);

#define  HI_32BY(w)  (((w) >> 24) & 0xFF)   /* Extract 31..24 bits from unsigned word */
#define  HI_24BY(w)  (((w) >> 16) & 0xFF)   /* Extract 23..16 bits from unsigned word */
#define  HI_BYTE(w)  (((w) >> 8) & 0xFF)   /* Extract high-order byte from unsigned word */
#define  LO_BYTE(w)  ((w) & 0xFF)          /* Extract low-order byte from unsigned word */

#define  ARRAY_SIZE(a)  (sizeof(a)/sizeof(a[0]))
/* bMaxPower in Configuration Descriptor */
#define USB_CONFIG_POWER_MA(mA)                ((mA)/2)


#include <inttypes.h>	// format specifiers for printing


#define FLASHMEM /* */

uint_fast8_t local_snprintf_P( char *buffer, uint_fast8_t count, const FLASHMEM char *format, ... );


void arm_hardware_invalidate(uintptr_t base, size_t size);	// Сейчас в эту память будем читать по DMA
void arm_hardware_flush(uintptr_t base, size_t size);	// Сейчас эта память будет записываться по DMA куда-то
void arm_hardware_flush_invalidate(uintptr_t base, size_t size);	// Сейчас эта память будет записываться по DMA куда-то. Потом содержимое не требуется
void arm_hardware_flush_all(void);



#define PSTR(s) (__extension__({static const char __c[] FLASHMEM = (s); &__c[0];}))

#if WITHDEBUG
	#define TP() \
		do { \
			static const char this_file [] = __FILE__; \
			printf(PSTR("At %d in %s.\n"), __LINE__, this_file); \
		} while(0)
#else /* WITHDEBUG */
	#define TP() do { } while(0)
#endif /* WITHDEBUG */

#if WITHDEBUG

	#define ASSERT(v) do { if ((v) == 0) { \
		printf(PSTR("%s(%d): Assert '%s'\n"), __FILE__, __LINE__, (# v)); \
		for (;;) ; \
		} } while (0)

	#define VERIFY(v) do { if ((v) == 0) { \
		printf(PSTR("%s(%d): Verify '%s'\n"), __FILE__, __LINE__, (# v)); \
		for (;;) ; \
		} } while (0)

	#define TRACE0(f)		printf( PSTR(f))
	#define TRACE1(f,a1)		printf( PSTR(f),(a1))
	#define TRACE2(f,a1,a2)		printf( PSTR(f),(a1),(a2))
	#define TRACE3(f,a1,a2,a3)	printf( PSTR(f),(a1),(a2),(a3))
	#define TRACE4(f,a1,a2,a3,a4)	printf( PSTR(f),(a1),(a2),(a3),(a4))
	#define TRACE5(f,a1,a2,a3,a4,a5) printf( PSTR(f),(a1),(a2),(a3),(a4),(a5))

#else /* WITHDEBUG */

	#define ASSERT(v) ((void) (0))
	#define VERIFY(v) ((void) (v))

	#define TRACE0(f)			do {} while (0)
	#define TRACE1(f,a1)			do {} while (0)
	#define TRACE2(f,a1,a2)			do {} while (0)
	#define TRACE3(f,a1,a2,a3)		do {} while (0)
	#define TRACE4(f,a1,a2,a3,a4)		do {} while (0)
	#define TRACE5(f,a1,a2,a3,a4,a5)		do {} while (0)

#endif /* WITHDEBUG */

/* NIC-to-LwIP buffers interface functions.
 * Should be called in IRQ handler request or in disabled IRQ state.
 * */
unsigned comm_allocbuffer(uint8_t * * bp);
void comm_freebuffer(uint8_t * p);
void comm_saverxbuffer(uint8_t * p, unsigned len);

#define PRINTF printf

#endif /* APPLICATION_USER_RLNDIS_USBD_DESC2_H */
