#include "mbed.h"
#include "USBSerial.h"
#include "usbd_desc2.h"

static USBSerial pc(0xFFFF, 0x0002, 0x0001);

//static DigitalOut beep(PB_11);
static PwmOut beep(PB_11);

/**TIM3 GPIO Configuration
PA7     ------> TIM3_CH2
PB0     ------> TIM3_CH3 !!!!
PB1     ------> TIM3_CH4
PB4     ------> TIM3_CH1
*/
/**TIM4 GPIO Configuration
PD12     ------> TIM4_CH1
PD13     ------> TIM4_CH2
*/
//static DigitalIn button(PE_2);
//static DigitalIn opn_sw(PD_7);
/*
static DigitalOut din(PA_7);
static DigitalOut din_light(PB_1);
static DigitalOut ud_pwm(PD_12);
static DigitalOut lr_pwm(PD_13);
*/
//static Serial bt(PG_14, PG_9, 9600);    // tx, rx USART6 work
//static Serial rfid(PD_5, PD_6, 9600);    // tx, rx USART2 work
//static Serial wifi(PA_9, PA_10, 9600);    // tx, rx USART1 work
//static Serial fifi2(PB_10, PC_5, 9600);   // tx, rx USART3 - overlap with STDIO USART

#define I2CADDR1 0xBE   // 7 bits: 0x5F
#define I2CADDR2 0xD6   // 7 bits: 0x6B

// LwIP timers support
extern "C" uint32_t sys_now()
{
    return 0;
}



//static I2C i2c(PB_9, PB_8);

int main(void)
{
    usbd_descriptors_initialize(0);
    //wifi.baud(115200);
    //wifi2.baud(115200);

    //beep.period_us(200000);
    //beep.write((float) 0.001); // duty
    /*
    din = 1;
    din_light = 1;
    ud_pwm = 1;
    lr_pwm = 1;
    */
    int i = 1;
    int devices_found;
    uint8_t curr_addr;
    char data[1] = {'\0'};
    pc.printf("\r\n");
    pc.printf("Program begin\r\n");
    wait(1);
    uint32_t ref;
    volatile uint32_t * const fmcbase = (volatile uint32_t *) 0xD0000000; // FMC_Bank5_6 memory window

    fmcbase [0] = 0xDEADBEEF;
    fmcbase [1] = ref = ~ 0xDEADBEEF;
    fmcbase [2] = 0x01234567;
    fmcbase [3] = 0x89ABCDEF;

#if 0
    while(0) {

        devices_found = 0;
        //beep = !beep;

        for (i = 0; i < 128; i++) {
            curr_addr = i << 1;
            if (!i2c.write(curr_addr, data, 1)) {
                pc.printf("found device at 0x%x\r\n", curr_addr);
                devices_found++;
            }
            wait(0.2);
        }

        pc.printf("%d devices found\r\n", devices_found);
        wait(2);
    }
#endif

    while(1) {
        //beep.period_us(20000);
        pc.printf("I am a virtual serial port - phase a1\r\n");
        //pc.printf("I am a virtual serial port - phase a1, btn=%d\r\n", (int) opn_sw.read());
        wait((float)0.2);
        //beep.period_us(5000);
        pc.printf("I am a virtual serial port - phase a2\r\n");
        //pc.printf("I am a virtual serial port - phase a2, btn=%d\r\n", (int) opn_sw.read());
        wait((float)0.2);
        //beep.period_us(2000);
        pc.printf("%08X %08X %08X %08X (ref=%08X, %s)\r\n", (unsigned) fmcbase [0], (unsigned) fmcbase [1], (unsigned) fmcbase [2], (unsigned) fmcbase [3], (unsigned) ref, ref == fmcbase [1] ? "Ok" : "Bad");
        wait((float)0.2);
        ++ ref;
        ++ fmcbase [1];
    }
}